/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.items;

import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.common.Tags;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class SeedItem
extends ItemNameBlockItem {
    private TagKey<Biome> category;

    public SeedItem(Block block, Item.Properties settings, TagKey<Biome> category) {
        super(block, settings);
        if (block instanceof CroptopiaCropBlock) {
            CroptopiaCropBlock crop = (CroptopiaCropBlock)block;
            crop.setSeed(this);
        }
        this.category = category;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos hitPos = context.getClickedPos();
        Level world = context.getLevel();
        BlockState state = world.getBlockState(hitPos);
        if (state.is(Tags.Blocks.VILLAGER_FARMLANDS) || state.is(Tags.FARMLANDS) || state.is(Tags.FARMLANDS)) {
            return super.useOn(context);
        }
        return InteractionResult.FAIL;
    }

    public TagKey<Biome> getCategory() {
        return this.category;
    }
}

