/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.common.generator.ConfiguredFeatureKeys;
import com.epherical.croptopia.common.generator.PlacedFeatureKeys;
import com.epherical.croptopia.datagen.WorldGenFeatures;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class CroptopiaWorldGeneration {
    public void addConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            context.register(treeCrop.getConfiguredFeatureKey(), treeCrop.getTreeConfig());
        }
        for (Tree tree : Tree.copy()) {
            context.register(tree.getConfiguredFeatureKey(), tree.getTreeGen());
        }
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            context.register(farmlandCrop.getConfigKey(), this.createCropPatch(farmlandCrop.asBlock()));
        }
        context.register(ConfiguredFeatureKeys.DISK_SALT_KEY, WorldGenFeatures.DISK_SALT);
    }

    public void addPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter lookup = context.lookup(Registries.CONFIGURED_FEATURE);
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            context.register(treeCrop.getPlacedFeatureKey(), (Object)new PlacedFeature((Holder)lookup.getOrThrow(treeCrop.getConfiguredFeatureKey()), WorldGenFeatures.datagenModifierLists.get(treeCrop.getPlacedFeatureKey())));
        }
        for (Tree tree : Tree.copy()) {
            context.register(tree.getPlacedFeatureKey(), (Object)new PlacedFeature((Holder)lookup.getOrThrow(tree.getConfiguredFeatureKey()), WorldGenFeatures.datagenModifierLists.get(tree.getPlacedFeatureKey())));
        }
        context.register(PlacedFeatureKeys.DISK_SALT_PLACED_KEY, (Object)new PlacedFeature((Holder)lookup.getOrThrow(ConfiguredFeatureKeys.DISK_SALT_KEY), WorldGenFeatures.datagenModifierLists.get(PlacedFeatureKeys.DISK_SALT_PLACED_KEY)));
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            context.register(farmlandCrop.getPlacedKey(), (Object)new PlacedFeature((Holder)lookup.getOrThrow(farmlandCrop.getConfigKey()), this.modifiers()));
        }
    }

    private List<PlacementModifier> modifiers() {
        return List.of(NoiseThresholdCountPlacement.of((double)-0.7, (int)0, (int)8), RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
    }

    private SimpleBlockConfiguration createCropConfiguration(Block block) {
        return new SimpleBlockConfiguration((BlockStateProvider)SimpleStateProvider.simple((BlockState)((BlockState)block.defaultBlockState().setValue((Property)CroptopiaCropBlock.AGE, (Comparable)Integer.valueOf(7)))));
    }

    private ConfiguredFeature<RandomPatchConfiguration, ?> createCropPatch(Block block) {
        return new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simpleRandomPatchConfiguration((int)6, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)this.createCropConfiguration(block))));
    }
}

