/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.config;

import com.epherical.epherolib.libs.org.spongepowered.configurate.ConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.SerializationException;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdentifierSerializer
implements TypeSerializer<ResourceLocation> {
    public static final IdentifierSerializer INSTANCE = new IdentifierSerializer();

    public ResourceLocation deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        return IdentifierSerializer.fromNode(value);
    }

    public void serialize(@NotNull Type type, @Nullable ResourceLocation obj, @NotNull ConfigurationNode value) {
        IdentifierSerializer.toNode(obj, value);
    }

    static ResourceLocation fromNode(ConfigurationNode node) throws SerializationException {
        if (node.virtual()) {
            return null;
        }
        if (node.isList()) {
            List children = node.childrenList();
            switch (children.size()) {
                case 2: {
                    String key = ((ConfigurationNode)children.get(0)).getString();
                    String value = ((ConfigurationNode)children.get(1)).getString();
                    if (key != null && value != null) {
                        return IdentifierSerializer.createIdentifier(key, value);
                    }
                    throw IdentifierSerializer.listAcceptedFormats();
                }
                case 1: {
                    String combined = ((ConfigurationNode)children.get(0)).getString();
                    if (combined != null) {
                        return IdentifierSerializer.createIdentifier(combined);
                    }
                    throw IdentifierSerializer.listAcceptedFormats();
                }
            }
            throw IdentifierSerializer.listAcceptedFormats();
        }
        String val = node.getString();
        if (val == null) {
            throw IdentifierSerializer.listAcceptedFormats();
        }
        return ResourceLocation.parse((String)val);
    }

    static ResourceLocation createIdentifier(String key, String value) throws SerializationException {
        try {
            return ResourceLocation.fromNamespaceAndPath((String)key, (String)value);
        }
        catch (ResourceLocationException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    static ResourceLocation createIdentifier(String data) throws SerializationException {
        try {
            return ResourceLocation.parse((String)data);
        }
        catch (ResourceLocationException ex) {
            throw new SerializationException(ex.getMessage());
        }
    }

    private static SerializationException listAcceptedFormats() {
        return new SerializationException("The provided item must be in [<namespace>:]<path> format");
    }

    static void toNode(ResourceLocation ident, ConfigurationNode node) {
        if (ident == null) {
            node.raw(null);
        } else {
            node.raw((Object)ident.toString());
        }
    }
}

