/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.config;

import com.epherical.croptopia.common.generator.PlacedFeatureKeys;
import com.epherical.croptopia.config.TreeConfiguration;
import com.epherical.epherolib.config.CommonConfig;
import com.epherical.epherolib.libs.org.spongepowered.configurate.CommentedConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.ScopedConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.SerializationException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class CroptopiaConfig
extends CommonConfig {
    public boolean generateSaltInWorld = true;
    public List<TreeConfiguration> treeConfigurations = new ArrayList<TreeConfiguration>();
    public TreeMultimap<ResourceKey<Biome>, TreeConfiguration> treeMap = TreeMultimap.create(Comparator.comparing(ResourceKey::toString), Comparator.comparing(o -> o.getFeatureKey().toString()));
    public boolean rightClickHarvest = true;

    public CroptopiaConfig(AbstractConfigurationLoader.Builder<?, ?> loaderBuilder, String configName) {
        super(loaderBuilder, configName);
    }

    public void parseConfig(CommentedConfigurationNode node) {
        this.configVersion = ((CommentedConfigurationNode)node.node(new Object[]{"version"})).getInt(this.configVersion);
        this.generateSaltInWorld = ((CommentedConfigurationNode)node.node(new Object[]{"generateSaltInWorld"})).getBoolean(this.generateSaltInWorld);
        this.rightClickHarvest = ((CommentedConfigurationNode)node.node(new Object[]{"rightCLickHarvest"})).getBoolean(this.rightClickHarvest);
        try {
            this.treeConfigurations = ((CommentedConfigurationNode)node.node(new Object[]{"treeConfig"})).getList(TreeConfiguration.class);
            if (this.treeConfigurations == null) {
                this.treeConfigurations = new ArrayList<TreeConfiguration>();
            }
            for (TreeConfiguration treeConfiguration : this.treeConfigurations) {
                for (ResourceKey<Biome> biomeResourceKey : treeConfiguration.getTreesAllowedInBiome()) {
                    this.treeMap.put(biomeResourceKey, (Object)treeConfiguration);
                }
            }
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    public CommentedConfigurationNode generateConfig(CommentedConfigurationNode node) {
        try {
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"version"})).set((Object)this.configVersion)).comment("Config Version, don't edit");
            ((CommentedConfigurationNode)node.node(new Object[]{"generateSaltInWorld"})).set((Object)this.generateSaltInWorld);
            ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{"rightClickHarvest"})).set((Object)this.rightClickHarvest)).set((Object)"Determines whether or not right click harvesting works (forge only)");
            this.generateTreeConfig(node, "treeConfig");
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        return node;
    }

    private void generateTreeConfig(CommentedConfigurationNode node, String nodeToAdd) {
        List<ResourceKey<Biome>> forestBiomes = Arrays.asList(Biomes.FOREST, Biomes.WINDSWEPT_FOREST, Biomes.FLOWER_FOREST);
        List<ResourceKey<Biome>> jungleBiomes = Arrays.asList(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE);
        List<ResourceKey<Biome>> plainsKeys = Arrays.asList(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS);
        List<ResourceKey<Biome>> darkForestKeys = Arrays.asList(Biomes.DARK_FOREST);
        HashMultimap biomes = HashMultimap.create();
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, forestBiomes, PlacedFeatureKeys.LIME_TREE_PLACED_KEY, PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.APRICOT_TREE_PLACED_KEY, PlacedFeatureKeys.AVOCADO_TREE_PLACED_KEY, PlacedFeatureKeys.STARFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.LEMON_TREE_PLACED_KEY, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.ORANGE_TREE_PLACED_KEY, PlacedFeatureKeys.NECTARINE_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, jungleBiomes, PlacedFeatureKeys.DATE_TREE_PLACED_KEY, PlacedFeatureKeys.DRAGONFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.MANGO_TREE_PLACED_KEY, PlacedFeatureKeys.NUTMEG_TREE_PLACED_KEY, PlacedFeatureKeys.COCONUT_TREE_PLACED_KEY, PlacedFeatureKeys.KUMQUAT_TREE_PLACED_KEY, PlacedFeatureKeys.GRAPEFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.BANANA_TREE_PLACED_KEY, PlacedFeatureKeys.FIG_TREE_PLACED_KEY, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, plainsKeys, PlacedFeatureKeys.APPLE_TREE_PLACED_KEY, PlacedFeatureKeys.ORANGE_TREE_PLACED_KEY, PlacedFeatureKeys.PEACH_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, darkForestKeys, PlacedFeatureKeys.ALMOND_TREE_PLACED_KEY, PlacedFeatureKeys.CASHEW_TREE_PLACED_KEY, PlacedFeatureKeys.PECAN_TREE_PLACED_KEY, PlacedFeatureKeys.WALNUT_TREE_PLACED_KEY);
        ResourceKey woodlands = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.travID("woodlands"));
        ResourceKey wooded_plateau = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.travID("wooded_plateau"));
        ResourceKey wooded_island = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.travID("wooded_island"));
        ResourceKey autumnal_woods = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.travID("autumnal_woods"));
        ResourceKey autumnal_wooded_hills = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.travID("autumnal_wooded_hills"));
        ResourceKey lush_swamp = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.travID("lush_swamp"));
        ResourceKey mini_jungle = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.travID("mini_jungle"));
        List<ResourceKey<Biome>> wooded = Arrays.asList(wooded_island, wooded_plateau, woodlands);
        List<ResourceKey<Biome>> autumnal = Arrays.asList(autumnal_woods, autumnal_wooded_hills);
        List<ResourceKey<Biome>> jungle = Arrays.asList(mini_jungle);
        List<ResourceKey<Biome>> lush = Arrays.asList(lush_swamp);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, wooded, PlacedFeatureKeys.APPLE_TREE_PLACED_KEY, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, autumnal, PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, jungle, PlacedFeatureKeys.DATE_TREE_PLACED_KEY, PlacedFeatureKeys.DRAGONFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.MANGO_TREE_PLACED_KEY, PlacedFeatureKeys.NUTMEG_TREE_PLACED_KEY, PlacedFeatureKeys.COCONUT_TREE_PLACED_KEY, PlacedFeatureKeys.KUMQUAT_TREE_PLACED_KEY, PlacedFeatureKeys.GRAPEFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.BANANA_TREE_PLACED_KEY, PlacedFeatureKeys.FIG_TREE_PLACED_KEY, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, lush, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        ResourceKey aspenForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("aspen_forest"));
        ResourceKey autumnalValley = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("autumnal_valley"));
        ResourceKey bayou = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("bayou"));
        ResourceKey blackForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("black_forest"));
        ResourceKey canadianShield = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("canadian_shield"));
        ResourceKey cherryBlossomForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("cherry_blossom_forest"));
        ResourceKey cikaWoods = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("cika_woods"));
        ResourceKey coniferousForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("coniferous_forest"));
        ResourceKey cragGardens = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("crag_gardens"));
        ResourceKey cypressSwamplands = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("cypress_swamplands"));
        ResourceKey deadSea = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("dead_sea"));
        ResourceKey daciteRidges = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("dacite_ridges"));
        ResourceKey windsweptDunes = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("windswept_dunes"));
        ResourceKey ebonyWoods = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("ebony_woods"));
        ResourceKey forgottenForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("forgotten_forest"));
        ResourceKey grove = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("temperate_grove"));
        ResourceKey guianaShield = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("guiana_shield"));
        ResourceKey jacarandaForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("jacaranda_forest"));
        ResourceKey mapleTaiga = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("maple_taiga"));
        ResourceKey coconinoMeadow = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("coconino_meadow"));
        ResourceKey mojaveDesert = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("mojave_desert"));
        ResourceKey lushTundra = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("lush_tundra"));
        ResourceKey orchard = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("orchard"));
        ResourceKey prairie = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("prairie"));
        ResourceKey redOakForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("red_oak_forest"));
        ResourceKey redRockValley = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("red_rock_valley"));
        ResourceKey roseFields = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("rose_fields"));
        ResourceKey autumnalForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("autumnal_forest"));
        ResourceKey autumnalTaiga = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("autumnal_taiga"));
        ResourceKey shatteredGlacier = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("shattered_glacier"));
        ResourceKey firecrackerShrubland = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("firecracker_shrubland"));
        ResourceKey sierraBadlands = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("sierra_badlands"));
        ResourceKey skyrisVale = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("skyris_vale"));
        ResourceKey redwoodThicket = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("redwood_thicket"));
        ResourceKey frostedTaiga = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("frosted_taiga"));
        ResourceKey frostedConiferousForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("frosted_coniferous_forest"));
        ResourceKey fragmentForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("fragment_forest"));
        ResourceKey tropicalIsland = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("tropical_islands"));
        ResourceKey tropicalRainforest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("tropical_rainforest"));
        ResourceKey twilightMeadow = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("twilight_meadow"));
        ResourceKey weepingWitchForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("weeping_witch_forest"));
        ResourceKey whiteMangroveMarshes = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("white_mangrove_marshes"));
        ResourceKey temperateRainforest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("temperate_rainforest"));
        ResourceKey zelkovaForest = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CroptopiaConfig.bygID("zelkova_forest"));
        List<ResourceKey<Biome>> bygWoods = Arrays.asList(aspenForest, orchard, redOakForest);
        List<ResourceKey<Biome>> cherry = Arrays.asList(cherryBlossomForest);
        List<ResourceKey<Biome>> nutty = Arrays.asList(weepingWitchForest, daciteRidges, ebonyWoods, mapleTaiga, twilightMeadow);
        List<ResourceKey<Biome>> jungleByg = Arrays.asList(cragGardens, tropicalIsland, tropicalRainforest);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, Collections.singleton(prairie), PlacedFeatureKeys.APPLE_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, Arrays.asList(jacarandaForest, autumnalForest, autumnalTaiga), PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, Arrays.asList(cypressSwamplands, whiteMangroveMarshes, temperateRainforest), PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, jungleByg, PlacedFeatureKeys.DATE_TREE_PLACED_KEY, PlacedFeatureKeys.DRAGONFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.MANGO_TREE_PLACED_KEY, PlacedFeatureKeys.NUTMEG_TREE_PLACED_KEY, PlacedFeatureKeys.COCONUT_TREE_PLACED_KEY, PlacedFeatureKeys.KUMQUAT_TREE_PLACED_KEY, PlacedFeatureKeys.GRAPEFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.BANANA_TREE_PLACED_KEY, PlacedFeatureKeys.FIG_TREE_PLACED_KEY, PlacedFeatureKeys.CINNAMON_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, nutty, PlacedFeatureKeys.ALMOND_TREE_PLACED_KEY, PlacedFeatureKeys.CASHEW_TREE_PLACED_KEY, PlacedFeatureKeys.PECAN_TREE_PLACED_KEY, PlacedFeatureKeys.WALNUT_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, cherry, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY);
        TreeConfiguration.createSameTreeConfigs((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)biomes, bygWoods, PlacedFeatureKeys.LIME_TREE_PLACED_KEY, PlacedFeatureKeys.PEAR_TREE_PLACED_KEY, PlacedFeatureKeys.APRICOT_TREE_PLACED_KEY, PlacedFeatureKeys.AVOCADO_TREE_PLACED_KEY, PlacedFeatureKeys.STARFRUIT_TREE_PLACED_KEY, PlacedFeatureKeys.LEMON_TREE_PLACED_KEY, PlacedFeatureKeys.CHERRY_TREE_PLACED_KEY, PlacedFeatureKeys.PLUM_TREE_PLACED_KEY, PlacedFeatureKeys.PERSIMMON_TREE_PLACED_KEY, PlacedFeatureKeys.ORANGE_TREE_PLACED_KEY, PlacedFeatureKeys.NECTARINE_TREE_PLACED_KEY);
        ArrayList<TreeConfiguration> allTreeConfigs = new ArrayList<TreeConfiguration>();
        for (Map.Entry entry : biomes.asMap().entrySet()) {
            allTreeConfigs.add(new TreeConfiguration((ResourceKey<PlacedFeature>)((ResourceKey)entry.getKey()), (Collection)entry.getValue()));
        }
        ScopedConfigurationNode node1 = node.node(new Object[]{nodeToAdd});
        try {
            node1.setList(TreeConfiguration.class, allTreeConfigs);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    private static ResourceLocation travID(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)name);
    }

    private static ResourceLocation bygID(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"byg", (String)name);
    }
}

