/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia;

import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.blocks.LeafCropBlock;
import com.epherical.croptopia.client.ClientFunctions;
import com.epherical.croptopia.config.CroptopiaConfig;
import com.epherical.croptopia.config.IdentifierSerializer;
import com.epherical.croptopia.config.TreeConfiguration;
import com.epherical.croptopia.datagen.CroptopiaBiomeTagProvider;
import com.epherical.croptopia.datagen.CroptopiaBlockTagProvider;
import com.epherical.croptopia.datagen.CroptopiaIndependentItemTagProvider;
import com.epherical.croptopia.datagen.CroptopiaItemModelProvider;
import com.epherical.croptopia.datagen.CroptopiaItemTagProvider;
import com.epherical.croptopia.datagen.CroptopiaLootTableProvider;
import com.epherical.croptopia.datagen.CroptopiaRecipeProvider;
import com.epherical.croptopia.datagen.CroptopiaWorldBiomeSelection;
import com.epherical.croptopia.datagen.CroptopiaWorldGeneration;
import com.epherical.croptopia.items.GuideBookItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.listeners.BlockBreakEvent;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.epherical.croptopia.register.helpers.Utensil;
import com.epherical.epherolib.libs.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import com.epherical.epherolib.libs.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="croptopia")
public class CroptopiaMod {
    public static final String MODID = "croptopia";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ArrayList<Item> cropItems = new ArrayList();
    public static ArrayList<Block> cropBlocks = new ArrayList();
    public static ArrayList<Block> leafBlocks = new ArrayList();
    public static ArrayList<Item> seeds = new ArrayList();
    public static CroptopiaMod mod;
    public static CroptopiaConfig config;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB;
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_SERIALIZER;
    public static final DeferredRegister<BiomeModifier> BIOME_MODIFIER;
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> GLM;

    public CroptopiaMod(IEventBus modEventBus, ModContainer modContainer) {
        config.addSerializer(TreeConfiguration.class, TreeConfiguration.Serializer.INSTANCE);
        config.addSerializer(ResourceLocation.class, IdentifierSerializer.INSTANCE);
        config.loadConfig(MODID);
        modEventBus.addListener(this::commonSetup);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)new BlockBreakEvent());
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        mod = this;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.MANGROVE_PROPAGULE), new ItemStack((ItemLike)Content.CINNAMON.getSapling()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            TreeCrop.TREE_CROPS.stream().map(TreeCrop::getSaplingItem).map(ItemStack::new).forEachOrdered(stack -> event.insertAfter(new ItemStack((ItemLike)Items.FLOWERING_AZALEA), stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            FarmlandCrop.FARMLAND_CROPS.stream().map(FarmlandCrop::getSeedItem).map(ItemStack::new).forEachOrdered(stack -> event.insertAfter(new ItemStack((ItemLike)Items.NETHER_WART), stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            event.insertBefore(new ItemStack((ItemLike)Items.COAL_ORE), new ItemStack((ItemLike)Content.SALT_ORE), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            Utensil.copy().stream().map(ItemStack::new).forEachOrdered(stack -> event.insertAfter(new ItemStack((ItemLike)Items.FLINT_AND_STEEL), stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static Item.Properties createGroup() {
        return new Item.Properties();
    }

    public static ResourceLocation createIdentifier(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    public static BlockBehaviour.Properties createCropSettings() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP);
    }

    public static LeafCropBlock createLeavesBlock() {
        return new LeafCropBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).ignitedByLava().randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(CroptopiaMod::canSpawnOnLeaves).isSuffocating((a, b, c) -> false).isViewBlocking((a, b, c) -> false));
    }

    public static LeavesBlock createRegularLeavesBlock() {
        return new LeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).ignitedByLava().randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(CroptopiaMod::canSpawnOnLeaves).isSuffocating(CroptopiaMod::never).isViewBlocking(CroptopiaMod::never));
    }

    public static BlockBehaviour.Properties createSaplingSettings() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.GRASS);
    }

    private static boolean never(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public static boolean canSpawnOnLeaves(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return type == EntityType.OCELOT || type == EntityType.PARROT;
    }

    static {
        config = new CroptopiaConfig((AbstractConfigurationLoader.Builder<?, ?>)HoconConfigurationLoader.builder(), "croptopia_v3.conf");
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)MODID);
        TAB = CREATIVE_MODE_TABS.register(MODID, () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.croptopia")).displayItems((featureFlagSet, output) -> BuiltInRegistries.ITEM.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals(MODID)).sorted(Comparator.comparing(entry -> BuiltInRegistries.ITEM.getId((Object)((Item)entry.getValue())))).forEach(entry -> output.accept((ItemLike)entry.getValue()))).icon(() -> new ItemStack((ItemLike)Content.COFFEE)).build());
        BIOME_SERIALIZER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MODID);
        BIOME_MODIFIER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (String)MODID);
        GLM = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)MODID);
    }

    @EventBusSubscriber(modid="croptopia", bus=EventBusSubscriber.Bus.MOD)
    public static class RegisterHandler {
        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            if (event.getRegistryKey() == Registries.ITEM) {
                Content.GUIDE = new GuideBookItem(CroptopiaMod.createGroup());
                event.register(Registries.ITEM, CroptopiaMod.createIdentifier("guide"), () -> Content.GUIDE);
                Content.registerItems((id, itemSupplier) -> {
                    if (Content.ITEM_REGISTER.getManipulations().containsKey(id)) {
                        itemSupplier = Content.ITEM_REGISTER.getManipulations().get(id);
                    }
                    Item item = (Item)itemSupplier.get();
                    event.register(Registries.ITEM, id, () -> item);
                    if (item instanceof ItemNameBlockItem) {
                        ((ItemNameBlockItem)item).registerBlocks(Item.BY_BLOCK, item);
                    }
                    if (item instanceof SeedItem) {
                        SeedItem it = (SeedItem)item;
                        CroptopiaCropBlock block = (CroptopiaCropBlock)it.getBlock();
                        block.setSeed(it);
                    }
                    return item;
                });
            } else if (event.getRegistryKey() == Registries.BLOCK) {
                Content.registerBlocks((id, supplier) -> {
                    if (Content.BLOCK_REGISTER.getManipulations().containsKey(id)) {
                        supplier = Content.BLOCK_REGISTER.getManipulations().get(id);
                    }
                    Block block = (Block)supplier.get();
                    event.register(Registries.BLOCK, id, () -> block);
                    return block;
                });
                FireBlock fire = (FireBlock)Blocks.FIRE;
                fire.setFlammable(Content.CINNAMON.getLog(), 5, 5);
                fire.setFlammable(Content.CINNAMON.getWood(), 5, 5);
                fire.setFlammable(Content.CINNAMON.getStrippedLog(), 5, 5);
                fire.setFlammable(Content.CINNAMON.getStrippedWood(), 5, 5);
            }
        }
    }

    @EventBusSubscriber(modid="croptopia", bus=EventBusSubscriber.Bus.MOD)
    public static class DataHandler {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            config.addSerializer(TreeConfiguration.class, TreeConfiguration.Serializer.INSTANCE);
            config.addSerializer(ResourceLocation.class, IdentifierSerializer.INSTANCE);
            config.loadConfig(CroptopiaMod.MODID);
            RegistrySetBuilder builder = new RegistrySetBuilder();
            builder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, CroptopiaWorldBiomeSelection::new);
            CroptopiaWorldGeneration generation = new CroptopiaWorldGeneration();
            builder.add(Registries.CONFIGURED_FEATURE, generation::addConfiguredFeatures);
            builder.add(Registries.PLACED_FEATURE, generation::addPlacedFeatures);
            DataGenerator generator = event.getGenerator();
            PackOutput output = generator.getPackOutput();
            ExistingFileHelper helper = event.getExistingFileHelper();
            CompletableFuture lookupProvider = event.getLookupProvider();
            generator.addProvider(event.includeClient(), (DataProvider)new CroptopiaItemModelProvider(output, helper));
            CroptopiaItemTagProvider itemProvider = (CroptopiaItemTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new CroptopiaItemTagProvider(output, (ResourceKey<? extends Registry<Item>>)Registries.ITEM, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, builder, Set.of(CroptopiaMod.MODID)));
            generator.addProvider(event.includeServer(), (DataProvider)new CroptopiaRecipeProvider(output, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new CroptopiaBiomeTagProvider(output, lookupProvider, helper));
            CroptopiaBlockTagProvider blockProvider = (CroptopiaBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new CroptopiaBlockTagProvider(output, (ResourceKey<? extends Registry<Block>>)Registries.BLOCK, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new CroptopiaLootTableProvider.GlobalLootProvider(output, lookupProvider));
            LootTableProvider.SubProviderEntry blocks = new LootTableProvider.SubProviderEntry(CroptopiaLootTableProvider::new, LootContextParamSets.BLOCK);
            LootTableProvider.SubProviderEntry chests = new LootTableProvider.SubProviderEntry(CroptopiaLootTableProvider.ChestLoot::new, LootContextParamSets.CHEST);
            LootTableProvider.SubProviderEntry entity = new LootTableProvider.SubProviderEntry(CroptopiaLootTableProvider.EntityLoot::new, LootContextParamSets.ENTITY);
            LootTableProvider.SubProviderEntry fishing = new LootTableProvider.SubProviderEntry(CroptopiaLootTableProvider.FishingLoot::new, LootContextParamSets.FISHING);
            LootTableProvider lootProvider = new LootTableProvider(output, Collections.emptySet(), List.of(blocks, chests, entity, fishing), lookupProvider);
            generator.addProvider(event.includeServer(), (DataProvider)lootProvider);
            CroptopiaIndependentItemTagProvider provider = new CroptopiaIndependentItemTagProvider(output, lookupProvider, itemProvider.contentsGetter(), blockProvider.contentsGetter(), helper);
            generator.addProvider(event.includeServer(), (DataProvider)provider);
        }
    }

    @EventBusSubscriber(modid="croptopia", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        private static ClientFunctions functions = new ClientFunctions();

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            functions.registerBlockLayers(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.cutoutMipped()));
            BlockColors colors = Minecraft.getInstance().getBlockColors();
            ItemColors itemColors = Minecraft.getInstance().getItemColors();
            colors.register(functions.registerLeafColors(), functions.leaves());
            itemColors.register(functions.registerItemColors(colors), (ItemLike[])functions.items());
        }

        @SubscribeEvent
        public static void onColorSetup(RegisterColorHandlersEvent.Block event) {
            event.register(functions.registerLeafColors(), functions.leaves());
        }
    }
}

