/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.sound.context;

import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.context.DynamicSoundContext;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.mixin.accessors.BlockAccessor;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class ItemStackSoundContext
implements DynamicSoundContext<ItemStack> {
    private final DynamicSoundHelper.BlockSoundType blockSoundType;

    public ItemStackSoundContext() {
        this(DynamicSoundHelper.BlockSoundType.FALL);
    }

    public ItemStackSoundContext(DynamicSoundHelper.BlockSoundType blockSoundType) {
        this.blockSoundType = blockSoundType;
    }

    public static ItemStackSoundContext of(DynamicSoundHelper.BlockSoundType blockSoundType) {
        return new ItemStackSoundContext(blockSoundType);
    }

    @Override
    public SoundInstance handleContext(ItemStack context, ResourceLocation fallback, float pitch, float volume) {
        Item item = context.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            fallback = this.blockSoundType.getTransformer().apply(((BlockAccessor)block).invokeGetSoundType(block.defaultBlockState()));
        }
        for (SoundDefinition definition : DynamicSoundHelper.getDefinitions("items")) {
            if (!definition.getKeys().isValid(item)) continue;
            fallback = definition.getSoundEvent();
            if (definition.getPitch().isPresent()) {
                pitch = definition.getPitch().get().floatValue();
            }
            if (!definition.getVolume().isPresent()) break;
            volume = definition.getVolume().get().floatValue();
            break;
        }
        return this.createSoundInstance(fallback, pitch, volume);
    }
}

