/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.mixin;

import dev.imb11.mru.LoaderUtils;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.config.TagPair;
import dev.imb11.sounds.api.event.SoundDefinitionReplacementEvent;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.imb11.sounds.dynamic.TagPairHelper;
import dev.imb11.sounds.util.BlockAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public abstract class BlockSoundMixin
implements BlockAccessor {
    @Unique
    @Nullable
    private TagPair sounds$associatedTagPair = null;
    @Unique
    private boolean sounds$hasFetched = false;

    @Override
    public void sounds$prepareTagPair(ResourceLocation value) {
        block5: {
            try {
                TagPair pair;
                if (Minecraft.getInstance() == null) {
                    return;
                }
                if (this instanceof LiquidBlock) {
                    this.sounds$hasFetched = true;
                    return;
                }
                if (SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely || SoundsConfig.get(WorldSoundsConfig.class).ignoredBlocks.contains(value.toString())) {
                    return;
                }
                this.sounds$associatedTagPair = pair = TagPairHelper.get(value);
                this.sounds$hasFetched = true;
            }
            catch (Exception ignored) {
                if (!LoaderUtils.isDevelopmentEnvironment()) break block5;
                SoundsClient.LOGGER.warn("Early-load attempt at getting custom sound block group failed. Ignoring for now. {}", (Object)value.toString());
            }
        }
    }

    @Inject(method={"getSoundType"}, at={@At(value="HEAD")}, cancellable=true)
    public void $manageCustomSounds(BlockState state, CallbackInfoReturnable<SoundType> cir) {
        SoundType replacement;
        SoundDefinitionReplacementEvent.Response eventResponse;
        block8: {
            try {
                ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                if (!this.sounds$hasFetched) {
                    this.sounds$prepareTagPair(id);
                }
                if (SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely || SoundsConfig.get(WorldSoundsConfig.class).ignoredBlocks.contains(id.toString())) {
                    return;
                }
            }
            catch (Exception ignored) {
                if (!LoaderUtils.isDevelopmentEnvironment()) break block8;
                SoundsClient.LOGGER.warn("Failed initial block fetch for blockstate {}", (Object)state.toString());
            }
        }
        SoundType group = null;
        if (this.sounds$associatedTagPair != null) {
            group = this.sounds$associatedTagPair.getGroup();
        }
        if ((eventResponse = SoundDefinitionReplacementEvent.fire(group)).response() == SoundDefinitionReplacementEvent.ResponseType.OVERRIDE && (replacement = eventResponse.override()) != null) {
            cir.setReturnValue((Object)replacement);
        }
        if (eventResponse.response() == SoundDefinitionReplacementEvent.ResponseType.CANCEL) {
            return;
        }
        if (group != null) {
            cir.setReturnValue((Object)group);
        }
    }
}

