/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class TagList<T> {
    private final List<Either<ResourceKey<T>, TagKey<T>>> _list;

    public TagList(List<Either<ResourceKey<T>, TagKey<T>>> list) {
        this._list = list;
    }

    public static <T> Codec<TagList<T>> getCodec(ResourceKey<? extends Registry<T>> registryKey) {
        return Codec.list((Codec)Codec.either((Codec)ResourceKey.codec(registryKey), (Codec)TagKey.hashedCodec(registryKey))).xmap(TagList::new, TagList::getInternalList);
    }

    public List<Either<ResourceKey<T>, TagKey<T>>> getInternalList() {
        return this._list;
    }

    public void add(Either<ResourceKey<T>, TagKey<T>> either) {
        this._list.add(either);
        this._list.sort((o1, o2) -> {
            if (o1.left().isPresent() && o2.right().isPresent()) {
                return -1;
            }
            if (o1.right().isPresent() && o2.left().isPresent()) {
                return 1;
            }
            if (o1.left().isPresent() && o2.left().isPresent()) {
                return ((ResourceKey)o1.left().get()).location().compareTo(((ResourceKey)o2.left().get()).location());
            }
            return ((TagKey)o1.right().get()).location().compareTo(((TagKey)o2.right().get()).location());
        });
    }

    public boolean isValid(T value) {
        for (Either<ResourceKey<T>, TagKey<T>> either : this._list) {
            ResourceLocation entry;
            Registry registry;
            if (either.left().isPresent()) {
                ResourceKey key = (ResourceKey)either.left().get();
                registry = (Registry)BuiltInRegistries.REGISTRY.get(key.registry());
                assert (registry != null);
                entry = registry.getKey(value);
                if (!((ResourceKey)either.left().get()).location().equals((Object)entry)) continue;
                return true;
            }
            if (!either.right().isPresent()) continue;
            TagKey tagKey = (TagKey)either.right().get();
            registry = (Registry)BuiltInRegistries.REGISTRY.get(tagKey.registry().location());
            assert (registry != null);
            entry = registry.wrapAsHolder(value);
            if (!entry.is(tagKey)) continue;
            return true;
        }
        return false;
    }
}

