/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.recipe;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.embeddedt.modernfix.common.mixin.perf.ingredient_item_deduplication.PatchedDataComponentMapAccessor;

public class IngredientValueDeduplicator {
    private static final ObjectOpenCustomHashSet<Ingredient.ItemValue> VALUES = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<Ingredient.ItemValue>(){

        public int hashCode(Ingredient.ItemValue o) {
            if (o == null) {
                return 0;
            }
            ItemStack stack = o.item();
            int hash = 31 * stack.getItem().hashCode();
            DataComponentMap dataComponentMap = stack.getComponents();
            if (dataComponentMap instanceof PatchedDataComponentMapAccessor) {
                PatchedDataComponentMapAccessor comps = (PatchedDataComponentMapAccessor)dataComponentMap;
                Reference2ObjectMap<DataComponentType<?>, Optional<?>> patch = comps.mfix$getPatch();
                for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(patch)) {
                    int keyHash = System.identityHashCode(entry.getKey()) & 0xFF;
                    Optional value = (Optional)entry.getValue();
                    int valueHash = value.isPresent() ? System.identityHashCode(value.get()) : 0;
                    hash += IntMath.pow((int)31, (int)keyHash) * valueHash;
                }
            } else {
                hash += System.identityHashCode(stack.getComponents());
            }
            return hash;
        }

        private boolean areComponentsSame(ItemStack a, ItemStack b) {
            DataComponentMap dataComponentMap = a.getComponents();
            if (dataComponentMap instanceof PatchedDataComponentMapAccessor) {
                PatchedDataComponentMapAccessor aComps = (PatchedDataComponentMapAccessor)dataComponentMap;
                dataComponentMap = b.getComponents();
                if (dataComponentMap instanceof PatchedDataComponentMapAccessor) {
                    Reference2ObjectMap<DataComponentType<?>, Optional<?>> bPatch;
                    PatchedDataComponentMapAccessor bComps = (PatchedDataComponentMapAccessor)dataComponentMap;
                    if (!aComps.mfix$getPrototype().equals((Object)bComps.mfix$getPrototype())) {
                        return false;
                    }
                    Reference2ObjectMap<DataComponentType<?>, Optional<?>> aPatch = aComps.mfix$getPatch();
                    if (aPatch != (bPatch = bComps.mfix$getPatch())) {
                        if (aPatch.size() != bPatch.size()) {
                            return false;
                        }
                        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(aPatch)) {
                            Optional value = (Optional)bPatch.get(entry.getKey());
                            if (value == null) {
                                return false;
                            }
                            if (value.isPresent() != ((Optional)entry.getValue()).isPresent()) {
                                return false;
                            }
                            if (!value.isPresent() || value.get() == ((Optional)entry.getValue()).get()) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }
            return a.getComponents() == b.getComponents();
        }

        private boolean areStacksSame(ItemStack a, ItemStack b) {
            if (!a.is(b.getItem())) {
                return false;
            }
            if (a.isEmpty() != b.isEmpty()) {
                return false;
            }
            if (!this.areComponentsSame(a, b)) {
                return false;
            }
            return a.getCount() == b.getCount();
        }

        public boolean equals(Ingredient.ItemValue a, Ingredient.ItemValue b) {
            return a == b || a != null && b != null && this.areStacksSame(a.item(), b.item());
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ingredient.Value deduplicate(Ingredient.Value value) {
        if (value != null && value.getClass() == Ingredient.ItemValue.class) {
            ObjectOpenCustomHashSet<Ingredient.ItemValue> objectOpenCustomHashSet = VALUES;
            synchronized (objectOpenCustomHashSet) {
                return (Ingredient.Value)VALUES.addOrGet((Object)((Ingredient.ItemValue)value));
            }
        }
        return value;
    }
}

