/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.monitoring.ShaderpacksWatcher;
import com.euphoriapatches.euphoria_patcher.util.ModLoaderSpecifics;
import com.euphoriapatches.euphoria_patcher.util.ShaderVersionComparator;
import com.euphoriapatches.euphoria_patcher.util.UpdateChecker;
import java.nio.file.Path;

public class UserInstallErrorMessages {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderMessageErrorHandler] " + message);
    }

    public static void handleShaderNotFound(ShaderVersionComparator versionComparator) {
        UserInstallErrorMessages.debugLog("Handling shader not found scenario");
        if (UpdateChecker.isNewerCompVersionAvailable()) {
            EuphoriaPatcher.log(3, 8, "=== SHADER NOT FOUND ===");
            EuphoriaPatcher.log(3, 8, "Required: ComplementaryShaders " + "_r5.7.1".replace("_", ""));
            EuphoriaPatcher.log(3, 8, "");
            EuphoriaPatcher.log(3, 8, "A newer version of EuphoriaPatches is available!");
            EuphoriaPatcher.log(3, 8, "SOLUTION: Update to version " + UpdateChecker.getNewModVersion() + " along with the compatible shader version: Complementary_r" + UpdateChecker.getComplementaryVersion());
            EuphoriaPatcher.log(3, 8, "Download from: https://euphoriapatches.com/download");
            UserInstallErrorMessages.copyLinkMessage();
        } else {
            Path newerVersion = versionComparator.findNewerComplementaryVersion();
            if (newerVersion != null) {
                UserInstallErrorMessages.debugLog("Found newer shader version: " + newerVersion.getFileName());
                String fileName = newerVersion.getFileName().toString();
                String detectedVersion = versionComparator.getComplementaryVersionFromFileName(fileName);
                EuphoriaPatcher.log(3, 8, "=== VERSION MISMATCH ===");
                EuphoriaPatcher.log(3, 8, "Found shader: " + fileName + " (version " + detectedVersion + ")");
                EuphoriaPatcher.log(3, 8, "Required shader: ComplementaryShaders _r5.7.1");
                EuphoriaPatcher.log(3, 8, "You have a NEWER shader version than what this mod version supports.");
                EuphoriaPatcher.log(3, 8, "");
                EuphoriaPatcher.log(3, 8, "SOLUTION 1: Wait for a EuphoriaPatches update that supports version " + detectedVersion);
                EuphoriaPatcher.log(3, 8, "SOLUTION 2: Manually check if a newer EuphoriaPatches version is available.");
                EuphoriaPatcher.log(3, 8, "SOLUTION 3: Download the compatible shader version _r5.7.1");
            } else {
                Path highestOlderVersion = versionComparator.findHighestOlderComplementaryVersion();
                EuphoriaPatcher.log(3, 8, "=== SHADER NOT FOUND ===");
                EuphoriaPatcher.log(3, 8, "Required: ComplementaryShaders " + "_r5.7.1".replace("_", ""));
                if (highestOlderVersion != null) {
                    EuphoriaPatcher.log(3, 8, "Found: " + highestOlderVersion.getFileName().toString());
                    EuphoriaPatcher.log(3, 8, "You have an older version installed.");
                    EuphoriaPatcher.log(3, 8, "");
                    EuphoriaPatcher.log(3, 8, "SOLUTION: Download and install ComplementaryShaders " + "_r5.7.1".replace("_", ""));
                } else {
                    EuphoriaPatcher.log(3, 8, "");
                    EuphoriaPatcher.log(3, 8, "No Complementary shader found in your shaderpacks folder.");
                    EuphoriaPatcher.log(3, 8, "");
                    EuphoriaPatcher.log(3, 8, "SOLUTION: Download ComplementaryShaders " + "_r5.7.1".replace("_", ""));
                }
            }
            EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
            UserInstallErrorMessages.copyLinkMessage();
        }
        EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
        if (instance != null) {
            instance.startShaderpacksWatcher();
        }
    }

    public static void handleSizeMismatch(String fileName, String originalFileName, ShaderVersionComparator versionComparator) {
        UserInstallErrorMessages.debugLog("Handling size mismatch for file: " + fileName);
        if (versionComparator != null && versionComparator.isNewerShaderVersion(fileName)) {
            UserInstallErrorMessages.debugLog("Detected newer shader version");
            UserInstallErrorMessages.handleNewerVersionDetected(fileName, originalFileName, versionComparator);
        } else if (fileName.matches("Complementary.*_r5.7.1.*")) {
            UserInstallErrorMessages.debugLog("Detected incomplete file with matching version");
            UserInstallErrorMessages.handleIncompleteFile(originalFileName);
        } else {
            UserInstallErrorMessages.debugLog("Detected wrong version");
            UserInstallErrorMessages.handleWrongVersion(originalFileName);
        }
        UserInstallErrorMessages.startWatcherAndTrackFile(fileName);
    }

    private static void handleNewerVersionDetected(String fileName, String originalFileName, ShaderVersionComparator versionComparator) {
        String detectedVersion = versionComparator.getComplementaryVersionFromFileName(fileName);
        EuphoriaPatcher.log(3, 8, "=== VERSION MISMATCH ===");
        EuphoriaPatcher.log(3, 8, "Found shader: " + originalFileName + " (version " + detectedVersion + ")");
        EuphoriaPatcher.log(3, 8, "Required shader: ComplementaryShaders _r5.7.1");
        EuphoriaPatcher.log(3, 8, "You have a NEWER shader version than what this mod version supports.");
        if (UpdateChecker.isNewerCompVersionAvailable()) {
            EuphoriaPatcher.log(3, 8, "");
            EuphoriaPatcher.log(3, 8, "SOLUTION: Update EuphoriaPatches to the latest version: " + UpdateChecker.getNewModVersion());
            EuphoriaPatcher.log(3, 8, "Download from: https://euphoriapatches.com/download");
            UserInstallErrorMessages.copyLinkMessage();
        } else {
            EuphoriaPatcher.log(3, 8, "");
            EuphoriaPatcher.log(3, 8, "SOLUTION 1: Wait for a EuphoriaPatches update that supports version " + detectedVersion);
            EuphoriaPatcher.log(3, 8, "SOLUTION 2: Download the compatible shader version _r5.7.1");
            EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
            UserInstallErrorMessages.copyLinkMessage();
        }
    }

    private static void handleIncompleteFile(String originalFileName) {
        EuphoriaPatcher.log(3, 8, "=== FILE VERIFICATION FAILED ===");
        EuphoriaPatcher.log(3, 8, "Shader file: " + originalFileName);
        EuphoriaPatcher.log(3, 8, "This file appears to be incomplete or has been modified.");
        EuphoriaPatcher.log(3, 8, "This can happen if the shader was manually edited or if it's from an unofficial source.");
        EuphoriaPatcher.log(3, 8, "");
        EuphoriaPatcher.log(3, 8, "SOLUTION: Re-download ComplementaryShaders _r5.7.1");
        EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
        UserInstallErrorMessages.copyLinkMessage();
    }

    private static void handleWrongVersion(String originalFileName) {
        EuphoriaPatcher.log(3, 8, "=== WRONG SHADER VERSION ===");
        EuphoriaPatcher.log(3, 8, "Found: " + originalFileName);
        EuphoriaPatcher.log(3, 8, "Required: ComplementaryShaders _r5.7.1");
        EuphoriaPatcher.log(3, 8, "");
        EuphoriaPatcher.log(3, 8, "SOLUTION: Download the correct shader version _r5.7.1");
        EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
        UserInstallErrorMessages.copyLinkMessage();
    }

    public static void handleDevVersion(String fileName, String originalFileName) {
        EuphoriaPatcher.log(3, 8, "=== DEV VERSION DETECTED ===");
        EuphoriaPatcher.log(3, 8, "Found: " + originalFileName);
        EuphoriaPatcher.log(3, 8, "This appears to be a test, dev, or pre-release version.");
        EuphoriaPatcher.log(3, 8, "");
        EuphoriaPatcher.log(3, 8, "SOLUTION: Download the official Complementary release version: _r5.7.1");
        EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
        UserInstallErrorMessages.copyLinkMessage();
        UserInstallErrorMessages.startWatcherAndTrackFile(fileName);
    }

    public static void handleHashMismatch(String fileName, String originalFileName) {
        EuphoriaPatcher.log(3, 8, "=== FILE VERIFICATION FAILED ===");
        EuphoriaPatcher.log(3, 8, "Shader file: " + originalFileName);
        EuphoriaPatcher.log(3, 8, "This file appears to have been modified.");
        EuphoriaPatcher.log(3, 8, "This can happen if the shader was manually edited or if it's from an unofficial source.");
        EuphoriaPatcher.log(3, 8, "File size matches but content hash does not.");
        EuphoriaPatcher.log(3, 8, "");
        EuphoriaPatcher.log(3, 8, "SOLUTION: Download the original unmodified Complementary shader");
        EuphoriaPatcher.log(3, 8, "Download from: https://www.complementary.dev/");
        UserInstallErrorMessages.copyLinkMessage();
        UserInstallErrorMessages.startWatcherAndTrackFile(fileName);
    }

    public static void copyLinkMessage() {
        if (ModLoaderSpecifics.isInstance("Forge1.7.10") || ModLoaderSpecifics.isInstance("ForgeLegacy")) {
            EuphoriaPatcher.log(3, 8, "Copy the download link from _0EUPHORIA_PATCHES_ERROR_LOGS.txt in your shaderpacks folder.");
        } else if (ShaderLoader.getShaderLoader().equals("optifine")) {
            EuphoriaPatcher.log(3, 8, "The download link has been copied to your clipboard. Paste it in your browser.");
        }
    }

    private static void startWatcherAndTrackFile(String fileName) {
        EuphoriaPatcher.log(0, "Watching for the correct shader to be added...");
        EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
        if (instance != null) {
            instance.startWatcherAfterByteSizeFailure();
            ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
            if (watcher != null) {
                watcher.trackInvalidByteSizeFile(fileName);
            }
        }
    }
}

