/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.ArchiveOperations;
import com.euphoriapatches.shadow.org.apache.commons.io.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class ShaderPropertyReader {
    private static final Map<String, String> styleCache = new HashMap<String, String>();

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderPropertyReader] " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectStyleFromCommonFile(Path shaderPath, String commonLocation) {
        String cacheKey = shaderPath.toString();
        if (styleCache.containsKey(cacheKey)) {
            ShaderPropertyReader.debugLog("Returning cached style for: " + shaderPath.getFileName());
            return styleCache.get(cacheKey);
        }
        Path tempDir = null;
        String detectedStyle = "Reimagined";
        try {
            Path commonFile;
            Path extractedPath;
            tempDir = ArchiveOperations.createTempDirectory();
            if (tempDir == null) {
                ShaderPropertyReader.debugLog("Could not create temp directory, returning default style");
                styleCache.put(cacheKey, detectedStyle);
                String string = detectedStyle;
                return string;
            }
            String baseName = shaderPath.getFileName().toString().replace(".zip", "");
            if (shaderPath.toString().endsWith(".zip")) {
                extractedPath = ArchiveOperations.extract(shaderPath, tempDir.resolve(baseName), "extracting archive");
                if (extractedPath == null) {
                    ShaderPropertyReader.debugLog("Failed to extract shader, returning default style");
                    styleCache.put(cacheKey, detectedStyle);
                    String string = detectedStyle;
                    return string;
                }
            } else {
                extractedPath = shaderPath;
            }
            if (Files.exists(commonFile = extractedPath.resolve(commonLocation), new LinkOption[0])) {
                String content = FileUtils.readFileToString(commonFile.toFile(), "UTF-8");
                if (content.contains("SHADER_STYLE 4")) {
                    ShaderPropertyReader.debugLog("Detected Unbound style from common.glsl");
                    detectedStyle = "Unbound";
                } else if (content.contains("SHADER_STYLE 1") || content.contains("SHADER_STYLE")) {
                    ShaderPropertyReader.debugLog("Detected Reimagined style from common.glsl");
                    detectedStyle = "Reimagined";
                }
            } else {
                ShaderPropertyReader.debugLog("common.glsl file not found at: " + commonFile);
            }
        }
        catch (IOException e) {
            ShaderPropertyReader.debugLog("Error reading common.glsl: " + e.getMessage());
        }
        finally {
            ArchiveOperations.deleteTempDirectory(tempDir);
        }
        ShaderPropertyReader.debugLog("Caching and returning " + detectedStyle + " style");
        styleCache.put(cacheKey, detectedStyle);
        return detectedStyle;
    }

    public static void clearCache() {
        styleCache.clear();
        ShaderPropertyReader.debugLog("Style cache cleared");
    }
}

