/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.shadow.com.google.gson.JsonArray;
import com.euphoriapatches.shadow.com.google.gson.JsonElement;
import com.euphoriapatches.shadow.com.google.gson.JsonObject;
import com.euphoriapatches.shadow.com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class JsonUtilReader {
    private static final String JSON_FILE_PATH = "/randomUtil.json";
    private static final Map<String, List<String>> messageCategories = new HashMap<String, List<String>>();
    private static final Random random = new Random();

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[JsonUtilReader] " + message);
    }

    private static void loadMessages() {
        JsonUtilReader.debugLog("Loading messages from /randomUtil.json");
        try (InputStream inputStream = JsonUtilReader.class.getResourceAsStream(JSON_FILE_PATH);){
            assert (inputStream != null);
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                JsonElement jsonElement = new JsonParser().parse(reader);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                    String categoryName = entry.getKey();
                    List<String> messages = JsonUtilReader.getStrings(entry);
                    if (messages.isEmpty()) continue;
                    messageCategories.put(categoryName, messages);
                }
            }
        }
        catch (Exception e) {
            EuphoriaPatcher.log(3, 0, "Error loading messages: " + e.getMessage());
        }
    }

    private static List<String> getStrings(Map.Entry<String, JsonElement> entry) {
        JsonElement value = entry.getValue();
        ArrayList<String> messages = new ArrayList<String>();
        if (value.isJsonArray()) {
            JsonArray messagesArray = value.getAsJsonArray();
            for (JsonElement message : messagesArray) {
                messages.add(message.getAsString());
            }
        } else if (value.isJsonPrimitive()) {
            messages.add(value.getAsString());
        }
        return messages;
    }

    public static String getRandomMessage(String category) {
        List<String> messages = messageCategories.get(category);
        if (messages != null && !messages.isEmpty()) {
            int randomIndex = random.nextInt(messages.size());
            return messages.get(randomIndex);
        }
        return "No messages available for category: " + category;
    }

    public static Set<String> getAllCategories() {
        return messageCategories.keySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(String key) {
        JsonUtilReader.debugLog("Getting string value for key: " + key);
        try (InputStream inputStream = JsonUtilReader.class.getResourceAsStream(JSON_FILE_PATH);){
            assert (inputStream != null);
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                JsonElement jsonElement = new JsonParser().parse(reader);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (!jsonObject.has(key)) return null;
                JsonElement element = jsonObject.get(key);
                if (!element.isJsonPrimitive()) return null;
                String string = element.getAsString();
                return string;
            }
        }
        catch (Exception e) {
            JsonUtilReader.debugLog("Error getting string value for key " + key + ": " + e.getMessage());
        }
        return null;
    }

    static {
        JsonUtilReader.loadMessages();
    }
}

