/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[HashUtils] " + message);
    }

    public static String calculateSHA256(Path filePath) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] fileBytes = Files.readAllBytes(filePath);
            byte[] hashBytes = digest.digest(fileBytes);
            return HashUtils.bytesToHex(hashBytes);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            HashUtils.debugLog("Error calculating SHA-256: " + e.getMessage());
            return null;
        }
    }

    public static String calculateSHA256(String input) {
        if (input == null) {
            HashUtils.debugLog("Cannot calculate SHA-256 of null string");
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return HashUtils.bytesToHex(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            HashUtils.debugLog("Error calculating SHA-256: " + e.getMessage());
            return null;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static boolean verifyHash(Path filePath, String expectedHash) {
        String actualHash = HashUtils.calculateSHA256(filePath);
        if (actualHash == null) {
            return false;
        }
        boolean hashMatches = expectedHash.equals(actualHash);
        HashUtils.debugLog("Hash verification for " + filePath.getFileName());
        HashUtils.debugLog("  Expected: " + expectedHash);
        HashUtils.debugLog("  Actual:   " + actualHash);
        HashUtils.debugLog("  Match:    " + hashMatches);
        return hashMatches;
    }

    public static boolean hasIncorrectHash(Path filePath, String expectedHash) {
        return !HashUtils.verifyHash(filePath, expectedHash);
    }
}

