/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Dimensions {
    public static final String SHADER_DIMENSION_PROPERTIES_LOCATION = "shaders/dimension.properties";
    private static final Map<String, String> dimensionCache = new HashMap<String, String>();
    private static final Map<String, Boolean> dimensionInMappingsCache = new HashMap<String, Boolean>();

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[Dimensions] " + message);
    }

    public static String getCurrentDimension(String currentDimensionId) {
        String vanillaCategory;
        if (currentDimensionId == null) {
            Dimensions.debugLog("Dimension ID is null, defaulting to 'overworld'");
            return "overworld";
        }
        if (dimensionCache.containsKey(currentDimensionId)) {
            String cached = dimensionCache.get(currentDimensionId);
            Dimensions.debugLog("Found dimension in cache: " + cached);
            return cached;
        }
        Path shaderpackPath = ShaderLoader.getCurrentShaderpackPath();
        if (shaderpackPath == null) {
            Dimensions.debugLog("No active shaderpack found");
        } else {
            Dimensions.debugLog("Active shaderpack: " + shaderpackPath.getFileName());
        }
        if (shaderpackPath != null) {
            Map<String, String> dimensionMappings = Dimensions.parseDimensionProperties(shaderpackPath);
            Dimensions.debugLog("Parsed " + dimensionMappings.size() + " dimension mappings from properties file");
            if (dimensionMappings.containsKey(currentDimensionId)) {
                String result = dimensionMappings.get(currentDimensionId);
                Dimensions.debugLog("Found mapping for current dimension: " + result);
                dimensionCache.put(currentDimensionId, result);
                return result;
            }
            Dimensions.debugLog("No specific mapping found for dimension: " + currentDimensionId);
        }
        if ((vanillaCategory = Dimensions.getVanillaDimensionCategory(currentDimensionId)) != null) {
            Dimensions.debugLog("Identified as vanilla " + vanillaCategory);
            dimensionCache.put(currentDimensionId, vanillaCategory);
            return vanillaCategory;
        }
        String result = Dimensions.sanitizeDimensionId(currentDimensionId);
        Dimensions.debugLog("No mapping found, returning sanitized dimension ID: " + result);
        dimensionCache.put(currentDimensionId, result);
        return result;
    }

    public static boolean isCurrentDimensionInMappings(String currentDimensionId) {
        boolean isInMappings;
        if (currentDimensionId == null) {
            return false;
        }
        if (dimensionInMappingsCache.containsKey(currentDimensionId)) {
            Dimensions.debugLog("Dimension in mappings cache hit for: " + currentDimensionId);
            return dimensionInMappingsCache.get(currentDimensionId);
        }
        if (Dimensions.getVanillaDimensionCategory(currentDimensionId) != null) {
            dimensionInMappingsCache.put(currentDimensionId, true);
            return true;
        }
        Path shaderpackPath = ShaderLoader.getCurrentShaderpackPath();
        if (shaderpackPath != null) {
            Map<String, String> dimensionMappings = Dimensions.parseDimensionProperties(shaderpackPath);
            isInMappings = dimensionMappings.containsKey(currentDimensionId);
        } else {
            isInMappings = false;
        }
        dimensionInMappingsCache.put(currentDimensionId, isInMappings);
        return isInMappings;
    }

    private static String sanitizeDimensionId(String dimensionId) {
        return dimensionId.replaceAll("[^a-zA-Z0-9_]", "_");
    }

    private static String getVanillaDimensionCategory(String dimensionId) {
        if (dimensionId == null) {
            return null;
        }
        switch (dimensionId) {
            case "minecraft:overworld": {
                return "overworld";
            }
            case "minecraft:the_nether": {
                return "nether";
            }
            case "minecraft:the_end": {
                return "end";
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> parseDimensionProperties(Path shaderPackPath) {
        HashMap<String, String> dimensionMap = new HashMap<String, String>();
        if (shaderPackPath == null) {
            Dimensions.debugLog("Shader pack path is null");
            return dimensionMap;
        }
        if (shaderPackPath.toString().endsWith(".zip")) {
            Dimensions.debugLog("Reading from ZIP file: " + shaderPackPath.getFileName());
            try (ZipFile zipFile = new ZipFile(shaderPackPath.toFile());){
                Map<String, String> map;
                ZipEntry entry = zipFile.getEntry(SHADER_DIMENSION_PROPERTIES_LOCATION);
                if (entry == null) {
                    Dimensions.debugLog("dimension.properties not found in ZIP");
                    HashMap<String, String> hashMap = dimensionMap;
                    return hashMap;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8));){
                    map = Dimensions.parseDimensionPropertiesFromReader(reader);
                }
                return map;
            }
            catch (IOException e) {
                Dimensions.debugLog("Error reading dimension.properties from ZIP: " + e.getMessage());
            }
        } else {
            Path propertiesFile = shaderPackPath.resolve(SHADER_DIMENSION_PROPERTIES_LOCATION);
            if (Files.exists(propertiesFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(propertiesFile, StandardCharsets.UTF_8);){
                    Map<String, String> map = Dimensions.parseDimensionPropertiesFromReader(reader);
                    return map;
                }
                catch (IOException e) {
                    Dimensions.debugLog("Error reading dimension.properties from directory: " + e.getMessage());
                }
            } else {
                Dimensions.debugLog("dimension.properties file not found at path: " + propertiesFile);
            }
        }
        return dimensionMap;
    }

    private static Map<String, String> parseDimensionPropertiesFromReader(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, String> dimensionMap = new HashMap<String, String>();
        StringBuilder currentLine = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
            if (line.endsWith("\\")) {
                currentLine.append(line, 0, line.length() - 1).append(" ");
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(line);
                line = currentLine.toString();
                currentLine.setLength(0);
            }
            if (line.startsWith("dimension.world0=")) {
                Dimensions.addDimensionsToMap(line.substring("dimension.world0=".length()), "overworld", dimensionMap);
                continue;
            }
            if (line.startsWith("dimension.world-1=")) {
                Dimensions.addDimensionsToMap(line.substring("dimension.world-1=".length()), "nether", dimensionMap);
                continue;
            }
            if (!line.startsWith("dimension.world1=")) continue;
            Dimensions.addDimensionsToMap(line.substring("dimension.world1=".length()), "end", dimensionMap);
        }
        return dimensionMap;
    }

    private static void addDimensionsToMap(String dimensionsLine, String targetCategory, Map<String, String> dimensionMap) {
        String[] parts;
        for (String part : parts = dimensionsLine.split("\\s+")) {
            if (part.trim().isEmpty() || part.equals("\\") || part.equals("*")) continue;
            dimensionMap.put(part, targetCategory);
        }
    }
}

