/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.neoforge;

import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.Dimensions;
import com.euphoriapatches.euphoria_patcher.util.ModLoaderSpecifics;
import com.mojang.blaze3d.platform.Window;
import java.lang.reflect.Method;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import org.lwjgl.glfw.GLFW;

public class NeoforgeModLoaderSpecifics
extends ModLoaderSpecifics {
    private final Path shaderpacksPath = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
    private final Path configDirectory = FMLPaths.CONFIGDIR.get();

    @Override
    public Path getShaderpacksPath() {
        return this.shaderpacksPath;
    }

    @Override
    public String getInstanceName() {
        return "NeoForge";
    }

    @Override
    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    @Override
    public boolean serverCheck() {
        try {
            Method getDistMethod = FMLEnvironment.class.getMethod("getDist", new Class[0]);
            Object dist = getDistMethod.invoke(null, new Object[0]);
            if (dist == Dist.DEDICATED_SERVER) {
                System.err.println("[EuphoriaPatcher] Server Detected! The Euphoria Patcher Mod disables itself gracefully on a server. Disabling...");
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                System.err.println("[EuphoriaPatcher] Server Detected! The Euphoria Patcher Mod disables itself gracefully on a server. Disabling...");
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getCurrentDimension() {
        return Dimensions.getCurrentDimension(this.getCurrentDimensionID());
    }

    @Override
    public boolean isCurrentDimensionInMappings() {
        return Dimensions.isCurrentDimensionInMappings(this.getCurrentDimensionID());
    }

    @Override
    public boolean setClipboard(String str) {
        try {
            long windowHandle;
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            Class<?> windowClass = window.getClass();
            try {
                windowHandle = (Long)windowClass.getMethod("handle", new Class[0]).invoke((Object)window, new Object[0]);
                this.debugLog("Using handle() method to get window handle");
            }
            catch (NoSuchMethodException e1) {
                windowHandle = (Long)windowClass.getMethod("getWindow", new Class[0]).invoke((Object)window, new Object[0]);
                this.debugLog("Using getWindow() method to get window handle");
            }
            GLFW.glfwSetClipboardString((long)windowHandle, (CharSequence)str);
            return true;
        }
        catch (Exception e) {
            this.debugLog("Error setting clipboard: " + e.getMessage());
            return false;
        }
    }

    private String getCurrentDimensionID() {
        try {
            this.debugLog("Getting current dimension ID");
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.level == null) {
                this.debugLog("Minecraft or level is null, defaulting to 'minecraft:overworld'");
                return "minecraft:overworld";
            }
            String dimensionString = minecraft.level.dimension().toString();
            this.debugLog("Dimension toString(): " + dimensionString);
            String currentDimensionId = dimensionString.contains("/") ? dimensionString.substring(dimensionString.indexOf("/") + 1).replace("]", "").trim() : "minecraft:overworld";
            this.debugLog("Current dimension ID: " + currentDimensionId);
            return currentDimensionId;
        }
        catch (Throwable t) {
            this.debugLog("Unexpected error getting current dimension ID: " + t.getMessage());
            return "minecraft:overworld";
        }
    }

    private void debugLog(String message) {
        EuphoriaLogger.debugLog("[NeoforgeModLoaderSpecifics] " + message);
    }
}

