/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.monitoring;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.iris.IrisReloadManager;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.services.ShaderDetector;
import com.euphoriapatches.euphoria_patcher.util.ArchiveOperations;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PotatoFileMonitor {
    private static final Map<String, Boolean> shaderpackStates = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> shaderpackInitialStates = new HashMap<String, Boolean>();
    private static volatile String currentShaderpackPath = null;
    private static Thread potatoMonitorThread = null;
    private static volatile boolean running = false;
    private static WatchService watchService = null;
    private static WatchKey watchKey = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[PotatoFileMonitor] " + message);
    }

    public static boolean checkPotatoExists(Path shaderpackPath) {
        if (shaderpackPath == null) {
            PotatoFileMonitor.debugLog("Shaderpack path is null");
            return false;
        }
        String pathKey = shaderpackPath.toString();
        Boolean initialState = shaderpackInitialStates.get(pathKey);
        if (initialState != null && !initialState.booleanValue()) {
            PotatoFileMonitor.debugLog("Using cached result for shaderpack that never had potato.png");
            return false;
        }
        boolean exists = PotatoFileMonitor.performPotatoCheck(shaderpackPath);
        PotatoFileMonitor.debugLog("Fresh check for potato.png: " + exists);
        return exists;
    }

    public static void setCurrentShaderpack(Path shaderpackPath) {
        if (shaderpackPath == null) {
            PotatoFileMonitor.stopMonitoring();
            currentShaderpackPath = null;
            return;
        }
        String pathKey = shaderpackPath.toString();
        if (!pathKey.equals(currentShaderpackPath)) {
            PotatoFileMonitor.debugLog("Shaderpack changed from " + currentShaderpackPath + " to " + pathKey);
            if (running) {
                PotatoFileMonitor.debugLog("Stopping monitoring for previous shaderpack");
                PotatoFileMonitor.stopMonitoring();
            }
            currentShaderpackPath = pathKey;
            boolean currentState = PotatoFileMonitor.checkPotatoExists(shaderpackPath);
            Boolean lastKnownState = shaderpackStates.get(pathKey);
            if (!shaderpackInitialStates.containsKey(pathKey)) {
                shaderpackInitialStates.put(pathKey, currentState);
                PotatoFileMonitor.debugLog("Recording initial potato.png state for " + pathKey + ": " + currentState);
            }
            if (!shaderpackInitialStates.get(pathKey).booleanValue()) {
                return;
            }
            if (lastKnownState != null && lastKnownState != currentState) {
                PotatoFileMonitor.debugLog("State changed for " + pathKey + " while it was not active: " + lastKnownState + " -> " + currentState);
                if (currentState) {
                    PotatoFileMonitor.debugLog("potato.png has been added - triggering shader reload");
                } else {
                    PotatoFileMonitor.debugLog("potato.png has been removed - triggering shader reload");
                }
                IrisReloadManager.findAndScheduleReload();
            } else if (lastKnownState == null) {
                PotatoFileMonitor.debugLog("First time loading this shaderpack, potato.png state: " + currentState);
            } else {
                PotatoFileMonitor.debugLog("No state change detected, potato.png state: " + currentState);
            }
            shaderpackStates.put(pathKey, currentState);
            if (Files.isDirectory(shaderpackPath, new LinkOption[0]) && currentState) {
                PotatoFileMonitor.debugLog("Directory shaderpack with potato.png detected - starting continuous monitoring");
                PotatoFileMonitor.startMonitoring();
            } else if (Files.isDirectory(shaderpackPath, new LinkOption[0])) {
                PotatoFileMonitor.debugLog("Directory shaderpack without potato.png - no monitoring needed");
            } else {
                PotatoFileMonitor.debugLog("ZIP shaderpack detected - no continuous monitoring needed");
            }
        }
    }

    public static void startMonitoring() {
        if (running) {
            PotatoFileMonitor.debugLog("Monitoring already running - stopping old thread first");
            PotatoFileMonitor.stopMonitoring();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (currentShaderpackPath == null) {
            PotatoFileMonitor.debugLog("No shaderpack path set, skipping monitoring");
            return;
        }
        Path shaderpackPath = new File(currentShaderpackPath).toPath();
        if (!Files.isDirectory(shaderpackPath, new LinkOption[0])) {
            PotatoFileMonitor.debugLog("Shaderpack is not a directory, skipping continuous monitoring");
            return;
        }
        Boolean currentState = shaderpackStates.get(currentShaderpackPath);
        if (currentState == null || !currentState.booleanValue()) {
            PotatoFileMonitor.debugLog("Shaderpack doesn't have potato.png currently, skipping monitoring");
            return;
        }
        running = true;
        String monitoringPath = currentShaderpackPath;
        potatoMonitorThread = new Thread(() -> {
            PotatoFileMonitor.debugLog("Started potato.png monitoring thread for: " + monitoringPath);
            try {
                PotatoFileMonitor.monitorDirectoryShaderpack(shaderpackPath);
            }
            catch (Exception e) {
                PotatoFileMonitor.debugLog("Error in monitoring thread: " + e.getMessage());
            }
            PotatoFileMonitor.debugLog("Stopped potato.png monitoring thread for: " + monitoringPath);
        }, "PotatoFileMonitor");
        potatoMonitorThread.setDaemon(true);
        potatoMonitorThread.start();
    }

    public static void stopMonitoring() {
        if (!running) {
            return;
        }
        PotatoFileMonitor.debugLog("Stopping monitoring thread");
        running = false;
        if (potatoMonitorThread != null) {
            potatoMonitorThread.interrupt();
            try {
                potatoMonitorThread.join(2000L);
            }
            catch (InterruptedException e) {
                PotatoFileMonitor.debugLog("Interrupted while waiting for monitor thread to stop");
            }
            potatoMonitorThread = null;
        }
        watchKey = null;
        watchService = null;
    }

    private static boolean performPotatoCheck(Path shaderpackPath) {
        String potatoRelativePath = "shaders/lib/textures/potato.png";
        EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
        ShaderDetector shaderDetector = instance.getShaderDetector();
        if (!shaderDetector.isEuphoriaPatchesShader(shaderpackPath)) {
            PotatoFileMonitor.debugLog("Shaderpack is not recognized as Euphoria Patches shader");
            return false;
        }
        try {
            if (Files.isDirectory(shaderpackPath, new LinkOption[0])) {
                Path potatoPath = shaderpackPath.resolve(potatoRelativePath);
                return Files.exists(potatoPath, new LinkOption[0]);
            }
            if (Files.isRegularFile(shaderpackPath, new LinkOption[0]) && shaderpackPath.toString().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                boolean exists = ArchiveOperations.fileExistsInZip(shaderpackPath, potatoRelativePath);
                PotatoFileMonitor.debugLog("ZIP shaderpack: potato.png " + (exists ? "exists" : "does not exist"));
                return exists;
            }
            PotatoFileMonitor.debugLog("Shaderpack is neither a directory nor a ZIP file");
            return false;
        }
        catch (Exception e) {
            PotatoFileMonitor.debugLog("Exception checking for potato.png: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void monitorDirectoryShaderpack(Path shaderpackPath) {
        PotatoFileMonitor.debugLog("Using WatchService for directory monitoring");
        String monitoredPath = shaderpackPath.toString();
        try {
            watchService = FileSystems.getDefault().newWatchService();
            Path texturesDir = shaderpackPath.resolve("shaders/lib/textures");
            if (!Files.exists(texturesDir, new LinkOption[0])) {
                PotatoFileMonitor.debugLog("Textures directory doesn't exist, cannot monitor");
                return;
            }
            watchKey = texturesDir.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            PotatoFileMonitor.debugLog("Registered WatchService on: " + texturesDir);
            while (running) {
                try {
                    if (!monitoredPath.equals(currentShaderpackPath)) {
                        PotatoFileMonitor.debugLog("Shaderpack changed during monitoring, stopping old monitor");
                    } else {
                        WatchKey key = watchService.poll(1L, TimeUnit.SECONDS);
                        if (key == null) continue;
                        for (WatchEvent<?> event : key.pollEvents()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW) {
                                PotatoFileMonitor.debugLog("WatchService overflow event");
                                continue;
                            }
                            WatchEvent<?> ev = event;
                            Path filename = (Path)ev.context();
                            if (!filename.toString().equals("potato.png") || !monitoredPath.equals(currentShaderpackPath)) continue;
                            PotatoFileMonitor.debugLog("Detected potato.png change: " + kind.name());
                            PotatoFileMonitor.handlePotatoStateChange(shaderpackPath);
                        }
                        boolean valid = key.reset();
                        if (valid) continue;
                        PotatoFileMonitor.debugLog("WatchKey no longer valid");
                    }
                    break;
                }
                catch (InterruptedException e) {
                    PotatoFileMonitor.debugLog("WatchService interrupted");
                    break;
                }
                catch (Exception e) {
                    PotatoFileMonitor.debugLog("Error in WatchService loop: " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            PotatoFileMonitor.debugLog("Failed to create WatchService: " + e.getMessage());
        }
        finally {
            if (watchKey != null) {
                watchKey.cancel();
            }
            if (watchService != null) {
                try {
                    watchService.close();
                }
                catch (IOException e) {
                    PotatoFileMonitor.debugLog("Error closing WatchService: " + e.getMessage());
                }
            }
        }
    }

    private static void handlePotatoStateChange(Path shaderpackPath) {
        boolean currentState = PotatoFileMonitor.performPotatoCheck(shaderpackPath);
        String pathKey = shaderpackPath.toString();
        Boolean previousState = shaderpackStates.get(pathKey);
        PotatoFileMonitor.debugLog("Potato.png state changed from " + previousState + " to " + currentState);
        shaderpackStates.put(pathKey, currentState);
        if (currentState) {
            PotatoFileMonitor.debugLog("potato.png has returned - triggering shader reload");
        } else {
            PotatoFileMonitor.debugLog("potato.png has been removed - triggering shader reload");
        }
        IrisReloadManager.findAndScheduleReload();
    }

    public static boolean shouldAddPotatoRemovedDefine(Path shaderpackPath) {
        if (shaderpackPath == null) {
            return false;
        }
        PotatoFileMonitor.setCurrentShaderpack(shaderpackPath);
        boolean potatoExists = PotatoFileMonitor.checkPotatoExists(shaderpackPath);
        return !potatoExists;
    }
}

