/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.integration.iris;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;

public class IrisReloadManager {
    private static volatile boolean pendingReload = false;
    private static volatile Class<?> pendingIrisClass = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[IrisReloadManager] " + message);
    }

    public static void scheduleReload(Class<?> irisClass) {
        if (irisClass != null) {
            IrisReloadManager.debugLog("Scheduling shader reload");
            pendingIrisClass = irisClass;
            pendingReload = true;
        } else {
            IrisReloadManager.debugLog("Cannot schedule reload - Iris class is null");
        }
    }

    public static void findAndScheduleReload() {
        Class<?> irisClass = ShaderLoader.findIrisClass();
        if (irisClass != null) {
            IrisReloadManager.scheduleReload(irisClass);
        }
    }

    public static void checkPendingReload() {
        if (pendingReload && pendingIrisClass != null) {
            try {
                IrisReloadManager.debugLog("Processing pending shader reload on main thread");
                pendingIrisClass.getMethod("reload", new Class[0]).invoke(null, new Object[0]);
                IrisReloadManager.debugLog("Successfully reloaded shaders");
            }
            catch (Exception e) {
                EuphoriaPatcher.log(2, 0, "Error reloading Iris shaders: " + e.getMessage());
            }
            finally {
                pendingReload = false;
                pendingIrisClass = null;
            }
        }
    }
}

