/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.createores.util.FluidIngredient;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public abstract class ExcavatingRecipe
implements Recipe<RecipeWrapper> {
    public ResourceLocation veinId;
    public Ingredient drill;
    public int priority;
    public int ticks;
    public int stressMul;
    public Optional<FluidIngredient> drillingFluid;
    protected boolean isNet;

    protected void setFromCommon(ExcavatingRecipeCommon c) {
        this.veinId = c.veinId();
        this.drill = c.drill();
        this.priority = c.priority();
        this.ticks = c.ticks();
        this.stressMul = c.stressMul();
        this.drillingFluid = c.drillingFluid();
    }

    protected ExcavatingRecipeCommon getCommon() {
        return new ExcavatingRecipeCommon(this.veinId, this.drill, this.priority, this.ticks, this.stressMul, this.drillingFluid);
    }

    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper p_44001_, HolderLookup.Provider p_267165_) {
        return this.getResultItem(p_267165_);
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_267052_) {
        return ItemStack.EMPTY;
    }

    public Ingredient getDrill() {
        return this.drill;
    }

    public int getTicks() {
        return this.ticks;
    }

    public abstract String getGroup();

    public int getStress() {
        return this.stressMul;
    }

    public Optional<FluidIngredient> getDrillingFluid() {
        return this.drillingFluid;
    }

    protected abstract void fromNetwork(RegistryFriendlyByteBuf var1);

    protected abstract void toNetwork(RegistryFriendlyByteBuf var1);

    public record ExcavatingRecipeCommon(ResourceLocation veinId, Ingredient drill, int priority, int ticks, int stressMul, Optional<FluidIngredient> drillingFluid) {
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends ExcavatingRecipe> {
        public T create(RecipeType<?> var1, RecipeSerializer<?> var2);
    }

    public static abstract class Serializer<T extends ExcavatingRecipe>
    implements RecipeSerializer<T> {
        private final Supplier<T> create;
        public static final MapCodec<ExcavatingRecipeCommon> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ResourceLocation.CODEC.fieldOf("veinId").forGetter(ExcavatingRecipeCommon::veinId), (App)Ingredient.CODEC.optionalFieldOf("drill", (Object)Ingredient.EMPTY).forGetter(ExcavatingRecipeCommon::drill), (App)Codec.INT.fieldOf("priority").forGetter(ExcavatingRecipeCommon::priority), (App)Codec.INT.fieldOf("ticks").forGetter(ExcavatingRecipeCommon::ticks), (App)Codec.INT.fieldOf("stress").forGetter(ExcavatingRecipeCommon::stressMul), (App)FluidIngredient.CODEC.optionalFieldOf("fluid").forGetter(ExcavatingRecipeCommon::drillingFluid)).apply((Applicative)b, ExcavatingRecipeCommon::new));
        public final StreamCodec<RegistryFriendlyByteBuf, T> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);

        public Serializer(Supplier<T> create) {
            this.create = create;
        }

        private T fromNetwork(RegistryFriendlyByteBuf buffer) {
            ExcavatingRecipe r = (ExcavatingRecipe)this.create.get();
            r.drill = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            r.ticks = buffer.readVarInt();
            r.stressMul = buffer.readVarInt();
            r.priority = buffer.readVarInt();
            r.veinId = buffer.readResourceLocation();
            r.fromNetwork(buffer);
            r.drillingFluid = FluidIngredient.read(buffer);
            r.isNet = true;
            return (T)r;
        }

        private void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((ExcavatingRecipe)recipe).drill);
            buffer.writeVarInt(((ExcavatingRecipe)recipe).ticks);
            buffer.writeVarInt(((ExcavatingRecipe)recipe).stressMul);
            buffer.writeVarInt(((ExcavatingRecipe)recipe).priority);
            buffer.writeResourceLocation(((ExcavatingRecipe)recipe).veinId);
            ((ExcavatingRecipe)recipe).toNetwork(buffer);
            FluidIngredient.write(buffer, ((ExcavatingRecipe)recipe).drillingFluid);
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.STREAM_CODEC;
        }
    }
}

