/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.components.OreVeinAtlasDataComponent;
import com.tom.createores.menu.OreVeinAtlasMenu;
import com.tom.createores.menu.PagedListWidget;
import com.tom.createores.network.NetworkHandler;
import com.tom.createores.network.OreVeinAtlasClickPacket;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.NumberFormatter;
import com.tom.createores.util.ThreeState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class OreVeinAtlasScreen
extends AbstractContainerScreen<OreVeinAtlasMenu> {
    private static final ResourceLocation GUI_TEXTURES = ResourceLocation.tryBuild((String)"createoreexcavation", (String)"textures/gui/atlas.png");
    private static final ResourceLocation EXCLUDE = ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_exclude");
    private static final ResourceLocation TARGET = ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_target");
    private static final ResourceLocation SHOW = ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_show");
    private static final ResourceLocation HIDE = ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_hidden");
    protected static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_button"), ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_button_disabled"), ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_button_hovered"));
    protected static final WidgetSprites ACTION_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_action_button"), ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_action_button_disabled"), ResourceLocation.tryBuild((String)"createoreexcavation", (String)"atlas_action_button_hovered"));
    private static final Button.OnPress NULL_PRESS = b -> {};
    private List<Vein> veinsList = new ArrayList<Vein>();
    private List<RecipeHolder<VeinRecipe>> veinTypesList = new ArrayList<RecipeHolder<VeinRecipe>>();
    private List<Vein> veinsListSorted = new ArrayList<Vein>();
    private List<RecipeHolder<VeinRecipe>> veinTypesListSorted = new ArrayList<RecipeHolder<VeinRecipe>>();
    private Set<ResourceLocation> excluded = new HashSet<ResourceLocation>();
    private String target;
    private VeinsListWidget discovered;
    private VeinTypesListWidget veinTypes;
    private Component veinTypesTitle = Component.translatable((String)"info.coe.atlas.vein_types");
    private PageButton backButton;
    private Vein selected;
    private boolean showHidden;
    private ToggleHideButton toggleHideButton;

    public OreVeinAtlasScreen(OreVeinAtlasMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super((AbstractContainerMenu)p_97741_, p_97742_, p_97743_);
    }

    protected void renderBg(GuiGraphics gr, float partial, int mx, int my) {
        gr.blit(GUI_TEXTURES, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
    }

    protected void init() {
        this.imageWidth = 282;
        this.imageHeight = 182;
        super.init();
        int i = this.leftPos;
        int j = this.topPos;
        this.discovered = (VeinsListWidget)this.addRenderableWidget((GuiEventListener)new VeinsListWidget(i + 20, j + 24, 110, 140));
        this.veinTypes = (VeinTypesListWidget)this.addRenderableWidget((GuiEventListener)new VeinTypesListWidget(i + 150, j + 24, 110, 140));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(i + 20 + 4, j + 24 + 140 - 12, false, p_98287_ -> this.pageBack(), true));
        this.toggleHideButton = (ToggleHideButton)this.addRenderableWidget((GuiEventListener)new ToggleHideButton(this, i + 118, j + 9, b -> this.toggleHide()));
        this.toggleHideButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.show_hide")));
        this.backButton.active = false;
        this.discovered.list = () -> this.veinsListSorted;
        this.veinTypes.list = () -> this.veinTypesListSorted;
        this.fillLists();
        this.updateVeinsList();
        this.updateVeinTypesList();
        this.discovered.updateContent();
        this.veinTypes.updateContent();
    }

    private void toggleHide() {
        if (this.selected != null) {
            this.selected.hidden = !this.selected.hidden;
            this.toggleHideButton.hideMode = this.selected.hidden;
            this.send2(OreVeinAtlasClickPacket.Option.TOGGLE_HIDE, this.veinsList.indexOf(this.selected));
            this.updateVeinsList();
        } else {
            this.showHidden = !this.showHidden;
            this.toggleHideButton.hideMode = this.showHidden;
            this.updateVeinsList();
        }
    }

    private void pageBack() {
        this.backButton.active = false;
        this.discovered.setVisible(true);
        this.selected = null;
        this.toggleHideButton.hideMode = this.showHidden;
        this.toggleHideButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.show_hide")));
        this.toggleHideButton.setX(this.leftPos + 118);
        this.toggleHideButton.setY(this.topPos + 9);
    }

    public void setSelected(Vein selected) {
        this.selected = selected;
        this.toggleHideButton.hideMode = selected.hidden;
        this.toggleHideButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.hide_vein")));
        this.toggleHideButton.setX(this.leftPos + 18);
        this.toggleHideButton.setY(this.topPos + 24);
    }

    private void updateVeinTypesList() {
        this.veinTypesListSorted.clear();
        this.veinTypesListSorted.addAll(this.veinTypesList);
        this.veinTypes.updateContent();
    }

    private void updateVeinsList() {
        this.veinsListSorted.clear();
        this.veinsList.stream().filter(e -> e.hidden == this.showHidden).forEach(this.veinsListSorted::add);
        this.discovered.updateContent();
    }

    private void fillLists() {
        this.veinsList.clear();
        this.veinTypesList.clear();
        this.excluded.clear();
        ItemStack is = ((OreVeinAtlasMenu)this.menu).getHeldItem();
        OreVeinAtlasDataComponent tag = (OreVeinAtlasDataComponent)is.get(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT);
        if (tag == null) {
            return;
        }
        this.target = tag.target().map(ResourceLocation::toString).orElse(null);
        for (ResourceLocation resourceLocation : tag.discovered()) {
            Minecraft.getInstance().level.getRecipeManager().byKey(resourceLocation).ifPresent(vr -> {
                if (vr.value() instanceof VeinRecipe) {
                    this.veinTypesList.add((RecipeHolder<VeinRecipe>)vr);
                }
            });
        }
        for (Pair pair : tag.veins()) {
            ResourceLocation vid = ((OreVeinAtlasDataComponent.OreVeinData)pair.getSecond()).id();
            DimChunkPos pos = (DimChunkPos)pair.getFirst();
            float size = ((OreVeinAtlasDataComponent.OreVeinData)pair.getSecond()).size();
            boolean hide = ((OreVeinAtlasDataComponent.OreVeinData)pair.getSecond()).hide();
            Minecraft.getInstance().level.getRecipeManager().byKey(vid).ifPresent(vr -> {
                if (vr.value() instanceof VeinRecipe) {
                    this.veinsList.add(new Vein(pos, (RecipeHolder<VeinRecipe>)vr, size, hide));
                }
            });
        }
        for (ResourceLocation resourceLocation : tag.exclude()) {
            this.excluded.add(resourceLocation);
        }
    }

    public void render(GuiGraphics st, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(st);
        super.render(st, mouseX, mouseY, partialTicks);
        if (this.selected != null) {
            st.pose().pushPose();
            st.pose().translate((float)(this.leftPos + 60), (float)(this.topPos + 40), 0.0f);
            float f = 2.0f;
            st.pose().scale(f, f, f);
            st.renderItem(this.getSelectedRecipe().icon, 0, 0);
            st.pose().popPose();
            Component t = this.getSelectedRecipe().veinName;
            st.drawString(this.font, t, this.leftPos + 75 - this.font.width((FormattedText)t) / 2, this.topPos + 80, 0x404040, false);
            long size = this.getVeinSize();
            t = size == 0L ? Component.translatable((String)"info.coe.atlas.vein_size.infinite") : Component.literal((String)("~" + NumberFormatter.formatNumber(size)));
            t = Component.translatable((String)"info.coe.atlas.vein_size", (Object[])new Object[]{t});
            st.drawString(this.font, t, this.leftPos + 15, this.topPos + 100, 0x404040, false);
            t = Component.translatable((String)"info.coe.atlas.location");
            st.drawString(this.font, t, this.leftPos + 15, this.topPos + 110, 0x404040, false);
            t = Component.translatable((String)"info.coe.atlas.location2", (Object[])new Object[]{Math.round((float)(this.selected.pos.x() * 16 + 8) / 10.0f) * 10, Math.round((float)(this.selected.pos.z() * 16 + 8) / 10.0f) * 10});
            st.drawString(this.font, t, this.leftPos + 25, this.topPos + 120, 0x404040, false);
            t = Component.translatable((String)"info.coe.atlas.dimension", (Object[])new Object[]{this.selected.pos.dimension().location().toString()});
            st.drawString(this.font, t, this.leftPos + 15, this.topPos + 130, 0x404040, false);
        }
    }

    private VeinRecipe getSelectedRecipe() {
        return (VeinRecipe)this.selected.recipe.value();
    }

    private long getVeinSize() {
        if (this.getSelectedRecipe().isFinite() != ThreeState.NEVER) {
            if (this.getSelectedRecipe().isFinite() == ThreeState.DEFAULT && ((OreVeinAtlasMenu)this.menu).isDefaultInfinite()) {
                return 0L;
            }
            double mul = (this.getSelectedRecipe().getMaxAmount() - this.getSelectedRecipe().getMinAmount()) * this.selected.size + this.getSelectedRecipe().getMinAmount();
            long am = Math.round(mul * (double)((OreVeinAtlasMenu)this.menu).getFiniteBase());
            return am;
        }
        return 0L;
    }

    protected void renderLabels(GuiGraphics gr, int pMouseX, int pMouseY) {
        gr.drawString(this.font, this.title, 75 - this.font.width((FormattedText)this.title) / 2, 16, 0x404040, false);
        gr.drawString(this.font, this.veinTypesTitle, 205 - this.font.width((FormattedText)this.veinTypesTitle) / 2, 16, 0x404040, false);
    }

    public void exclude(RecipeHolder<VeinRecipe> data, boolean ex) {
        if (ex) {
            this.excluded.add(data.id());
            this.target = null;
            this.send(OreVeinAtlasClickPacket.Option.ADD_EXCLUDE, data.id());
        } else {
            this.excluded.remove(data.id());
            this.send(OreVeinAtlasClickPacket.Option.REMOVE_EXCLUDE, data.id());
        }
        this.veinTypes.updateContent();
    }

    private void send(OreVeinAtlasClickPacket.Option opt, ResourceLocation id) {
        NetworkHandler.sendDataToServer(new OreVeinAtlasClickPacket(opt, id));
    }

    private void send2(OreVeinAtlasClickPacket.Option opt, int id) {
        NetworkHandler.sendDataToServer(new OreVeinAtlasClickPacket(opt, id));
    }

    public void target(RecipeHolder<VeinRecipe> data) {
        if (data != null) {
            this.target = data.id().toString();
            this.send(OreVeinAtlasClickPacket.Option.SET_TARGET, data.id());
        } else {
            this.target = null;
            this.send(OreVeinAtlasClickPacket.Option.REMOVE_TARGET, null);
        }
        this.veinTypes.updateContent();
    }

    private class VeinsListWidget
    extends PagedListWidget<VeinWidgetHolder, Vein> {
        public VeinsListWidget(int x, int y, int w, int h) {
            super(x, y, w, h, 20);
        }

        @Override
        protected <W extends AbstractWidget> W addWidgetToGUI(W w) {
            return (W)((AbstractWidget)OreVeinAtlasScreen.this.addRenderableWidget(w));
        }

        @Override
        protected VeinWidgetHolder makeElement(int x, int y) {
            return new VeinWidgetHolder((VeinInfoButton)OreVeinAtlasScreen.this.addRenderableWidget((GuiEventListener)new VeinInfoButton(x, y, 110)));
        }

        @Override
        protected void updateElement(VeinWidgetHolder element, Vein data) {
            boolean bl = element.btn.visible = data != null;
            if (data != null) {
                element.btn.setVein(data);
            }
        }
    }

    private class VeinTypesListWidget
    extends PagedListWidget<VeinTypeWidgetHolder, RecipeHolder<VeinRecipe>> {
        public VeinTypesListWidget(int x, int y, int w, int h) {
            super(x, y, w, h, 10);
        }

        @Override
        protected <W extends AbstractWidget> W addWidgetToGUI(W w) {
            return (W)((AbstractWidget)OreVeinAtlasScreen.this.addRenderableWidget(w));
        }

        @Override
        protected VeinTypeWidgetHolder makeElement(int x, int y) {
            return new VeinTypeWidgetHolder((VeinTargetButton)OreVeinAtlasScreen.this.addRenderableWidget((GuiEventListener)new VeinTargetButton(x, y, 100)), (VeinExcludeButton)OreVeinAtlasScreen.this.addRenderableWidget((GuiEventListener)new VeinExcludeButton(x + 100, y)));
        }

        @Override
        protected void updateElement(VeinTypeWidgetHolder element, RecipeHolder<VeinRecipe> data) {
            element.btn.visible = data != null;
            boolean bl = element.trg.visible = data != null;
            if (data != null) {
                element.btn.recipe = data;
                element.btn.setMessage(((VeinRecipe)data.value()).getName());
                element.btn.updateTooltip();
                element.trg.data = data;
                element.trg.updateTooltip();
            }
        }
    }

    private class ToggleHideButton
    extends Button {
        private boolean hideMode;

        private ToggleHideButton(OreVeinAtlasScreen oreVeinAtlasScreen, int pX, int pY, Button.OnPress pOnPress) {
            super(pX, pY, 16, 16, (Component)Component.empty(), pOnPress, DEFAULT_NARRATION);
        }

        protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.blitSprite(BUTTON_SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            pGuiGraphics.blitSprite(this.hideMode ? HIDE : SHOW, this.getX(), this.getY(), 16, 16);
        }
    }

    private static class Vein {
        private final DimChunkPos pos;
        private final RecipeHolder<VeinRecipe> recipe;
        private final float size;
        private boolean hidden;

        public Vein(DimChunkPos pos, RecipeHolder<VeinRecipe> recipe, float size, boolean hidden) {
            this.pos = pos;
            this.recipe = recipe;
            this.size = size;
            this.hidden = hidden;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
            result = 31 * result + (this.recipe == null ? 0 : this.recipe.id().hashCode());
            result = 31 * result + Float.floatToIntBits(this.size);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Vein other = (Vein)obj;
            if (this.pos == null ? other.pos != null : !this.pos.equals(other.pos)) {
                return false;
            }
            if (this.recipe == null ? other.recipe != null : !this.recipe.id().equals((Object)other.recipe.id())) {
                return false;
            }
            return Float.floatToIntBits(this.size) == Float.floatToIntBits(other.size);
        }
    }

    private record VeinTypeWidgetHolder(VeinTargetButton btn, VeinExcludeButton trg) {
    }

    private class VeinExcludeButton
    extends Button {
        private RecipeHolder<VeinRecipe> data;
        private Tooltip TT_EXCLUDE;
        private Tooltip TT_INCLUDE;

        protected VeinExcludeButton(int pX, int pY) {
            super(pX, pY, 10, 10, (Component)Component.empty(), NULL_PRESS, DEFAULT_NARRATION);
            this.TT_EXCLUDE = Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.exclude"));
            this.TT_INCLUDE = Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.include"));
        }

        protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.blitSprite(ACTION_BUTTON_SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (OreVeinAtlasScreen.this.excluded.contains(this.data.id())) {
                pGuiGraphics.blitSprite(EXCLUDE, this.getX() + 1, this.getY() + 1, 8, 8);
            }
        }

        public void onPress() {
            if (OreVeinAtlasScreen.this.excluded.contains(this.data.id())) {
                OreVeinAtlasScreen.this.exclude(this.data, false);
            } else {
                OreVeinAtlasScreen.this.exclude(this.data, true);
            }
        }

        public Tooltip createTooltip() {
            if (OreVeinAtlasScreen.this.excluded.contains(this.data.id())) {
                return this.TT_EXCLUDE;
            }
            return this.TT_INCLUDE;
        }

        public void updateTooltip() {
            this.setTooltip(this.createTooltip());
        }
    }

    private class VeinTargetButton
    extends VeinTypeButton {
        private Tooltip TT_TARGET;
        private Tooltip TT_SWITCH_TARGET;
        private Tooltip TT_SET_TARGET;

        private VeinTargetButton(int pX, int pY, int pWidth) {
            super(OreVeinAtlasScreen.this, pX, pY, pWidth, 10);
            this.TT_TARGET = Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.target"));
            this.TT_SWITCH_TARGET = Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.switch_target"));
            this.TT_SET_TARGET = Tooltip.create((Component)Component.translatable((String)"tooltip.coe.atlas.set_target"));
        }

        @Override
        protected void renderItem(GuiGraphics pGuiGraphics) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate((float)(this.getX() + 1), (float)(this.getY() + 1), 0.0f);
            float f = 0.5f;
            pGuiGraphics.pose().scale(f, f, f);
            pGuiGraphics.renderItem(this.getRecipe().icon, 0, 0);
            pGuiGraphics.pose().popPose();
            if (OreVeinAtlasScreen.this.target != null && !OreVeinAtlasScreen.this.target.isEmpty() && OreVeinAtlasScreen.this.target.equals(this.recipe.id().toString())) {
                pGuiGraphics.blitSprite(TARGET, this.getX() + 10, this.getY() + 1, 8, 8);
            }
        }

        @Override
        public Tooltip createTooltip() {
            if (OreVeinAtlasScreen.this.target != null && !OreVeinAtlasScreen.this.target.isEmpty()) {
                if (OreVeinAtlasScreen.this.target.equals(this.recipe.id().toString())) {
                    return this.TT_TARGET;
                }
                return this.TT_SWITCH_TARGET;
            }
            return this.TT_SET_TARGET;
        }

        @Override
        public void onPress() {
            if (OreVeinAtlasScreen.this.target != null && !OreVeinAtlasScreen.this.target.isEmpty()) {
                if (OreVeinAtlasScreen.this.target.equals(this.recipe.id().toString())) {
                    OreVeinAtlasScreen.this.target(null);
                } else {
                    OreVeinAtlasScreen.this.target((RecipeHolder<VeinRecipe>)this.recipe);
                }
            } else {
                OreVeinAtlasScreen.this.target((RecipeHolder<VeinRecipe>)this.recipe);
            }
        }
    }

    private class VeinInfoButton
    extends VeinTypeButton {
        private Vein vein;

        private VeinInfoButton(int pX, int pY, int pWidth) {
            super(OreVeinAtlasScreen.this, pX, pY, pWidth, 20);
        }

        @Override
        public void onPress() {
            OreVeinAtlasScreen.this.discovered.setVisible(false);
            OreVeinAtlasScreen.this.backButton.active = true;
            OreVeinAtlasScreen.this.setSelected(this.vein);
        }

        public void setVein(Vein vein) {
            this.vein = vein;
            this.recipe = vein.recipe;
            this.setMessage(this.getRecipe().getName());
        }
    }

    private class VeinTypeButton
    extends Button {
        protected RecipeHolder<VeinRecipe> recipe;

        private VeinTypeButton(OreVeinAtlasScreen oreVeinAtlasScreen, int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.empty(), NULL_PRESS, DEFAULT_NARRATION);
        }

        protected VeinRecipe getRecipe() {
            return (VeinRecipe)this.recipe.value();
        }

        protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            Minecraft minecraft = Minecraft.getInstance();
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.blitSprite(BUTTON_SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int i = this.isHovered ? 16579744 : 0xC0C0C0;
            this.renderScrollingText(pGuiGraphics, minecraft.font, 20, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
            this.renderItem(pGuiGraphics);
        }

        protected void renderItem(GuiGraphics pGuiGraphics) {
            pGuiGraphics.renderItem(this.getRecipe().icon, this.getX() + 1, this.getY() + 1);
        }

        protected void renderScrollingText(GuiGraphics pGuiGraphics, Font pFont, int pWidth, int pColor) {
            int i = this.getX() + pWidth;
            int j = this.getX() + this.getWidth();
            VeinTypeButton.renderScrollingString((GuiGraphics)pGuiGraphics, (Font)pFont, (Component)this.getMessage(), (int)i, (int)this.getY(), (int)j, (int)(this.getY() + this.getHeight()), (int)pColor);
        }

        public Tooltip createTooltip() {
            return null;
        }

        public void updateTooltip() {
            this.setTooltip(this.createTooltip());
        }

        public void onPress() {
        }
    }

    private record VeinWidgetHolder(VeinInfoButton btn) {
    }
}

