/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import com.tom.createores.Registration;
import com.tom.createores.block.MultiblockPart;
import com.tom.createores.block.entity.IOBlockEntity;
import com.tom.createores.util.IOBlockType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IOBlock
extends BaseEntityBlock
implements MultiblockPart.MultiblockGhostPart,
IBE<IOBlockEntity> {
    public static final EnumProperty<IOBlockType> TYPE = EnumProperty.create((String)"type", IOBlockType.class);
    public static final MapCodec<IOBlock> CODEC = IOBlock.simpleCodec(IOBlock::new);

    public IOBlock(BlockBehaviour.Properties pr) {
        super(pr);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING, TYPE});
        super.createBlockStateDefinition(builder);
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    @Override
    public Direction getParentDir(BlockState state) {
        return (Direction)state.getValue((Property)BlockStateProperties.FACING);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.hasParent(state, level, pos);
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return !this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player pPlayer) {
        BlockState st = super.playerWillDestroy(level, pos, state, pPlayer);
        this.destroyParent(level, pos, state, pPlayer);
        return st;
    }

    public Class<IOBlockEntity> getBlockEntityClass() {
        return IOBlockEntity.class;
    }

    public BlockEntityType<? extends IOBlockEntity> getBlockEntityType() {
        return (BlockEntityType)Registration.IO_TILE.get();
    }

    protected ItemInteractionResult useItemOn(ItemStack item, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.onActivate(state, level, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return this.onActivate(state, level, pos, player, hit);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.pickBlock((BlockGetter)level, pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

