/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumextras.mixins.impl.darkness;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.sodiumextras.foundation.darkness.DarknessPlus;
import toni.sodiumextras.mixins.impl.darkness.accessors.LightTextureAccessor;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private LightTexture lightTexture;

    @Shadow
    public abstract Minecraft getMinecraft();

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="HEAD")})
    private void inject$renderLevel(DeltaTracker deltaTracker, CallbackInfo ci) {
        Minecraft mc = this.getMinecraft();
        LightTextureAccessor lightTexAccessor = (LightTextureAccessor)this.lightTexture;
        if (lightTexAccessor.isDirty()) {
            mc.getProfiler().push("lightTex");
            DarknessPlus.updateLuminance(deltaTracker.getGameTimeDeltaTicks(), mc, (GameRenderer)this, lightTexAccessor.getFlicker());
            mc.getProfiler().pop();
        }
    }
}

