/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.foundation.placement;

import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tiestoettoet.create_train_parts.content.trains.crossing.ArmExtenderBlock;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public abstract class ArmHelper<T extends Comparable<T>>
implements IPlacementHelper {
    protected final Predicate<BlockState> statePredicate;
    protected final Property<T> property;
    protected final Function<BlockState, Direction.Axis> axisFunction;

    public ArmHelper(Predicate<BlockState> statePredicate, Function<BlockState, Direction.Axis> axisFunction, Property<T> property) {
        this.statePredicate = statePredicate;
        this.axisFunction = axisFunction;
        this.property = property;
    }

    public boolean matchesAxis(BlockState state, Direction.Axis axis) {
        if (!this.statePredicate.test(state)) {
            return false;
        }
        return this.axisFunction.apply(state) == axis;
    }

    public int attachedArms(Level world, BlockPos pos, Direction direction) {
        BlockPos checkPos = pos.relative(direction);
        BlockState state = world.getBlockState(checkPos);
        int count = 0;
        while (this.matchesAxis(state, direction.getClockWise().getAxis())) {
            ++count;
            checkPos = checkPos.relative(direction);
            state = world.getBlockState(checkPos);
        }
        return count;
    }

    public Predicate<BlockState> getStatePredicate() {
        return this.statePredicate;
    }

    public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
        List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.getLocation(), dir -> dir.getAxis() == this.axisFunction.apply(state));
        for (Direction dir2 : directions) {
            BlockPos newPos;
            BlockState newState;
            int arms;
            AttributeInstance reach;
            int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
            if (player != null && (reach = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE)) != null && reach.hasModifier(ExtendoGripItem.singleRangeAttributeModifier.id())) {
                range += 4;
            }
            if ((arms = this.attachedArms(world, pos, dir2)) >= range || !(newState = world.getBlockState(newPos = pos.relative(dir2, arms + 1))).canBeReplaced()) continue;
            boolean flipped = (Boolean)state.getValue((Property)ArmExtenderBlock.FLIPPED);
            return PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)((BlockState)bState.setValue(this.property, state.getValue(this.property))).setValue((Property)ArmExtenderBlock.FLIPPED, (Comparable)Boolean.valueOf(flipped)));
        }
        return PlacementOffset.fail();
    }
}

