/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.foundation.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.simibubi.create.content.contraptions.Contraption;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Contraption.class})
public abstract class ContraptionMixin {
    @Inject(method={"capture"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyCapturedState(Level world, BlockPos pos, CallbackInfoReturnable<Pair<StructureTemplate.StructureBlockInfo, BlockEntity>> cir) {
        Pair result = (Pair)cir.getReturnValue();
        if (result == null) {
            return;
        }
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)result.getLeft();
        BlockState state = info.state();
        boolean modified = false;
        if (state.hasProperty((Property)TrainStepBlock.VISIBLE)) {
            state = (BlockState)state.setValue((Property)TrainStepBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
            modified = true;
        }
        if (state.hasProperty((Property)TrainSlideBlock.VISIBLE)) {
            state = (BlockState)state.setValue((Property)TrainSlideBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
            modified = true;
        }
        if (state.hasProperty((Property)SlidingWindowBlock.VISIBLE)) {
            state = (BlockState)state.setValue((Property)SlidingWindowBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
            modified = true;
        }
        if (modified) {
            cir.setReturnValue((Object)Pair.of((Object)new StructureTemplate.StructureBlockInfo(info.pos(), state, info.nbt()), (Object)((BlockEntity)result.getRight())));
        }
    }

    @ModifyExpressionValue(method={"addBlocksToWorld"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/StructureTransform;apply(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/state/BlockState;")})
    private BlockState modifyStateOnDisassembly(BlockState state) {
        if (state.hasProperty((Property)TrainStepBlock.VISIBLE)) {
            state = (BlockState)((BlockState)state.setValue((Property)TrainStepBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)TrainStepBlock.OPEN) == false))).setValue((Property)TrainStepBlock.POWERED, (Comparable)Boolean.valueOf(false));
        }
        if (state.hasProperty((Property)TrainSlideBlock.VISIBLE)) {
            state = (BlockState)((BlockState)state.setValue((Property)TrainSlideBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)TrainSlideBlock.OPEN) == false))).setValue((Property)TrainSlideBlock.POWERED, (Comparable)Boolean.valueOf(false));
        }
        if (state.hasProperty((Property)SlidingWindowBlock.VISIBLE)) {
            state = (BlockState)((BlockState)state.setValue((Property)SlidingWindowBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SlidingWindowBlock.OPEN) == false))).setValue((Property)SlidingWindowBlock.POWERED, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Inject(method={"shouldUpdateAfterMovement"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipUpdateForTrainParts(StructureTemplate.StructureBlockInfo info, CallbackInfoReturnable<Boolean> cir) {
        if (info.state().getBlock() instanceof TrainStepBlock) {
            cir.setReturnValue((Object)false);
        }
        if (info.state().getBlock() instanceof TrainSlideBlock) {
            cir.setReturnValue((Object)false);
        }
        if (info.state().getBlock() instanceof SlidingWindowBlock) {
            cir.setReturnValue((Object)false);
        }
    }
}

