/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.trains.crossing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import com.tiestoettoet.create_train_parts.AllPartialModels;
import com.tiestoettoet.create_train_parts.content.trains.crossing.CrossingBlock;
import com.tiestoettoet.create_train_parts.content.trains.crossing.CrossingBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CrossingRenderer
extends KineticBlockEntityRenderer<CrossingBlockEntity> {
    public CrossingRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CrossingBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float relativeValue;
        BlockState blockState = be.getBlockState();
        if (!be.shouldRenderSpecial(blockState)) {
            return;
        }
        Level world = be.getLevel();
        BlockPos pos = be.getBlockPos();
        int adjustedLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)pos);
        Direction facing = (Direction)blockState.getValue(CrossingBlock.HORIZONTAL_FACING);
        float rotationAngle = switch (facing) {
            case Direction.NORTH -> 270.0f;
            case Direction.SOUTH -> 90.0f;
            case Direction.WEST -> 0.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
        float value = be.animation.getValue(partialTicks);
        float exponentialValue = value * value;
        float relativeAnimationValue = relativeValue = (Boolean)blockState.getValue((Property)CrossingBlock.OPEN) != false ? exponentialValue : 1.0f - exponentialValue;
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        if (blockState.getBlock() instanceof CrossingBlock) {
            float f = (Boolean)blockState.getValue((Property)CrossingBlock.OPEN) != false ? -1.0f : 1.0f;
            float target = be.animation.getChaseTarget();
            value = 0.5f * (1.0f - Mth.cos((float)((float)Math.PI * value)));
            float angle = value * 1.56f;
            boolean top = (double)value < 0.2;
            boolean bottom = (double)value > 0.8;
            boolean flipped = (Boolean)blockState.getValue((Property)CrossingBlock.FLIPPED);
            PartialModel arm = flipped ? AllPartialModels.ARM_FLIPPED : AllPartialModels.ARM;
            SuperByteBuffer partial_arm = CachedBuffers.partial((PartialModel)arm, (BlockState)blockState);
            int lightInFront = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos().relative(Direction.UP));
            int lightBehind = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos().relative(Direction.DOWN));
            ((SuperByteBuffer)((SuperByteBuffer)partial_arm.light(lightInFront).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).rotateCenteredDegrees(57.295776f * angle, Direction.EAST)).renderInto(ms, vb);
            SuperByteBuffer shaftHalf = CachedBuffers.partialFacing((PartialModel)com.simibubi.create.AllPartialModels.SHAFT_HALF, (BlockState)be.getBlockState(), (Direction)Direction.DOWN);
            CrossingRenderer.standardKineticRotationTransform2(shaftHalf, be, lightBehind).renderInto(ms, vb);
            ((SuperByteBuffer)CachedBuffers.partial((PartialModel)(flipped ? AllPartialModels.LIGHTS_FLIPPED : AllPartialModels.LIGHTS), (BlockState)blockState).light(lightInFront).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).renderInto(ms, buffer.getBuffer(RenderType.translucent()));
            if (value != 1.0f && be.getSpeed() != 0.0f) {
                float movementMain = 0.5f;
                float movementSecondary = 0.875f;
                long gameTime = be.getLevel().getGameTime();
                float movementUp = gameTime / 10L % 2L == 0L ? 1.1875f : 0.875f;
                Vec3 movementMainVec = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMain);
                Vec3 movementUpVec = Vec3.atLowerCornerOf((Vec3i)Direction.UP.getNormal()).scale((double)movementUp);
                Vec3 movementSecondaryVec = Vec3.atLowerCornerOf((Vec3i)facing.getCounterClockWise().getNormal()).scale((double)movementSecondary);
                Vec3 movement = movementMainVec.add(movementUpVec).add(movementSecondaryVec);
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)com.simibubi.create.AllPartialModels.SIGNAL_WHITE_CUBE, (BlockState)blockState).light(0xF000F0).translate(movement.x, movement.y, movement.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).disableDiffuse().scale(1.0f, 1.0f, 1.0f)).renderInto(ms, buffer.getBuffer(RenderType.translucent()));
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)com.simibubi.create.AllPartialModels.SIGNAL_RED_GLOW, (BlockState)blockState).light(0xF000F0).translate(movement.x, movement.y, movement.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).disableDiffuse().scale(1.5f, 2.0f, 2.0f)).renderInto(ms, buffer.getBuffer(RenderTypes.additive()));
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.CROSSING_LAMP, (BlockState)blockState).light(0xF000F0).translate(movement.x, movement.y, movement.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).disableDiffuse().scale(1.0625f)).renderInto(ms, buffer.getBuffer(RenderTypes.additive()));
            }
        }
    }

    public static SuperByteBuffer standardKineticRotationTransform2(SuperByteBuffer buffer, KineticBlockEntity be, int light) {
        BlockPos pos = be.getBlockPos();
        Direction.Axis axis = Direction.Axis.Y;
        return CrossingRenderer.kineticRotationTransform((SuperByteBuffer)buffer, (KineticBlockEntity)be, (Direction.Axis)axis, (float)CrossingRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)axis), (int)light);
    }
}

