/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.trains.crossing;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.tiestoettoet.create_train_parts.content.trains.crossing.CrossingBlock;
import com.tiestoettoet.create_train_parts.content.trains.crossing.CrossingContraption;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CrossingBlockEntity
extends KineticBlockEntity
implements IControlContraption {
    LerpedFloat animation = LerpedFloat.linear().startWithValue(CrossingBlockEntity.isOpen(this.getBlockState()) ? 1.0 : 0.0);
    int bridgeTicks;
    public boolean running;
    protected float angle;
    protected double sequencedAngleLimit = -1.0;
    protected boolean assembleNextTick;
    public ControlledContraptionEntity movedContraption;
    protected AssemblyException lastException;
    Object openObj = null;

    public CrossingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.lastException = AssemblyException.read((CompoundTag)tag, (HolderLookup.Provider)registries);
        super.read(tag, registries, clientPacket);
        this.invalidateRenderBoundingBox();
        if (tag.contains("ForceOpen")) {
            this.openObj = tag.getBoolean("ForceOpen");
        }
    }

    public void assemble() {
        System.out.println("CrossingBlockEntity.assemble() called");
        if (!(this.level.getBlockState(this.worldPosition).getBlock() instanceof CrossingBlock)) {
            return;
        }
        Direction direction = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        CrossingContraption contraption = new CrossingContraption(direction);
        System.out.println("Created CrossingContraption with direction: " + String.valueOf(direction));
        try {
            boolean assembleResult = contraption.assemble(this.level, this.worldPosition);
            System.out.println("Contraption assemble result: " + assembleResult);
            if (!assembleResult) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            System.out.println("Assembly exception: " + e.getMessage());
            this.lastException = e;
            this.sendData();
            return;
        }
        contraption.removeBlocksFromWorld(this.level, BlockPos.ZERO);
        this.movedContraption = ControlledContraptionEntity.create((Level)this.level, (IControlContraption)this, (Contraption)contraption);
        BlockPos anchor = this.worldPosition;
        this.movedContraption.setPos((double)anchor.getX(), (double)anchor.getY(), (double)anchor.getZ());
        this.movedContraption.setRotationAxis(direction.getAxis());
        this.level.addFreshEntity((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        this.running = true;
        this.angle = 90.0f;
        this.sendData();
    }

    public void disassemble() {
        System.out.println("Disassemble called - running: " + this.running + ", movedContraption: " + (this.movedContraption != null));
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.angle = 0.0f;
        this.sequencedAngleLimit = -1.0;
        if (this.movedContraption != null) {
            System.out.println("Disassembling contraption");
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
        }
        this.movedContraption = null;
        this.running = false;
        this.assembleNextTick = false;
        this.sendData();
    }

    public void tick() {
        boolean shouldOpen;
        super.tick();
        BlockState block = this.getBlockState();
        boolean open = CrossingBlockEntity.isOpen(this.getBlockState());
        float speed = Math.abs(this.getSpeed());
        boolean bl = shouldOpen = this.getSpeed() < 0.0f;
        if (speed < 0.0f) {
            speed = -speed;
        }
        speed = speed / 50.0f * 0.05f * 0.25f;
        float targetValue = shouldOpen ? 0.0f : 1.0f;
        this.animation.chase((double)targetValue, (double)speed, LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        if (this.level.isClientSide()) {
            if (this.bridgeTicks < 2 && open) {
                ++this.bridgeTicks;
            } else if (this.bridgeTicks > 0 && !open) {
                --this.bridgeTicks;
            }
        }
        if (this.animation.settled() && open == (this.animation.getValue() != 0.0f)) {
            return;
        }
        block = (BlockState)block.setValue((Property)CrossingBlock.OPEN, (Comparable)Boolean.valueOf(this.animation.getValue() != 0.0f));
        this.level.setBlock(this.worldPosition, block, 10);
        if (!this.level.isClientSide) {
            this.assembleNextTick = false;
            if (this.running) {
                if (this.animation.getValue() == 0.0f) {
                    System.out.println("Disassembling: speed=" + speed + ", shouldOpen=" + shouldOpen + ", animValue=" + this.animation.getValue() + ", settled=" + this.animation.settled());
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.level);
                    }
                    this.disassemble();
                    return;
                }
            } else {
                boolean isInClosedState;
                if (speed == 0.0f) {
                    return;
                }
                boolean bl2 = shouldOpen ? this.animation.settled() && this.animation.getValue() < 0.1f : (isInClosedState = this.animation.settled() && this.animation.getValue() > 0.9f);
                if (!isInClosedState) {
                    System.out.println("Assembling: speed=" + speed + ", shouldOpen=" + shouldOpen + ", animValue=" + this.animation.getValue() + ", settled=" + this.animation.settled());
                    this.assemble();
                }
            }
        }
        if (this.movedContraption == null) {
            return;
        }
        float rawValue = this.animation.getValue();
        float smoothValue = 0.5f * (1.0f - Mth.cos((float)((float)Math.PI * rawValue)));
        float angleInRadians = (float)(1.56 * (double)smoothValue);
        float angleInDegrees = (float)Math.toDegrees(angleInRadians);
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        this.movedContraption.setAngle(switch (facing) {
            case Direction.EAST, Direction.SOUTH -> -angleInDegrees;
            case Direction.NORTH, Direction.WEST -> angleInDegrees;
            default -> -angleInDegrees;
        });
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(1.0);
    }

    protected boolean shouldRenderSpecial(BlockState state) {
        return true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public static boolean isOpen(BlockState state) {
        return state.getOptionalValue((Property)CrossingBlock.OPEN).orElse(false);
    }

    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public void attach(ControlledContraptionEntity contraption) {
        this.movedContraption = contraption;
        if (!this.level.isClientSide) {
            this.running = true;
            this.sendData();
        }
    }

    public void onStall() {
        if (!this.level.isClientSide) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.isRemoved();
    }

    public BlockPos getBlockPosition() {
        return this.worldPosition;
    }
}

