/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainStep;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.tiestoettoet.create_train_parts.AllPartialModels;
import com.tiestoettoet.create_train_parts.AllSpriteShifts;
import com.tiestoettoet.create_train_parts.CreateTrainParts;
import com.tiestoettoet.create_train_parts.content.decoration.encasing.EncasedCTBehaviour;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrainStepRenderer
extends SafeBlockEntityRenderer<TrainStepBlockEntity> {
    protected void renderSafe(TrainStepBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        if (!be.shouldRenderSpecial(blockState)) {
            return;
        }
        if (be.getLevel() instanceof VirtualRenderWorld) {
            return;
        }
        TrainStepRenderer.renderTrainStep(blockState, be.getBlockPos(), be.getLevel(), be.animation.getValue(partialTicks), ms, light, buffer, null);
    }

    static void renderTrainStep(BlockState state, BlockPos pos, Level world, float animValue, PoseStack ms, int light, MultiBufferSource buffer, ContraptionMatrices matrices) {
        float relativeValue;
        EncasedCTBehaviour behaviour = new EncasedCTBehaviour(com.simibubi.create.AllSpriteShifts.ANDESITE_CASING);
        Direction facing = (Direction)state.getValue((Property)TrainStepBlock.FACING);
        CTType dataType = behaviour.getDataType((BlockAndTintGetter)world, pos, state, facing);
        if (dataType == null) {
            return;
        }
        float rotationAngle = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        float exponentialValue = animValue * animValue;
        float relativeAnimationValue = relativeValue = (Boolean)state.getValue((Property)TrainStepBlock.OPEN) != false ? exponentialValue : 1.0f - exponentialValue;
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        if (state.getBlock() instanceof TrainStepBlock) {
            Vec3 movementM;
            Vec3 movementF;
            float rotation;
            ResourceLocation blockTexture = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            String blockTexturePath = blockTexture.getPath();
            TrainStepBlock.ConnectedState connectedState = (TrainStepBlock.ConnectedState)((Object)state.getValue(TrainStepBlock.CONNECTED));
            float f = (Boolean)state.getValue((Property)TrainStepBlock.OPEN) != false ? -1.0f : 1.0f;
            float movement = 0.3125f * exponentialValue * f;
            Direction movementDirection = (Boolean)state.getValue((Property)TrainStepBlock.OPEN) != false ? facing.getOpposite() : facing;
            Vec3 moveOffset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movement);
            float movementP = 0.65625f;
            Vec3 moveOffsetP = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementP);
            float rotationPivot = (Boolean)state.getValue((Property)TrainStepBlock.OPEN) != false ? 90.0f * f * exponentialValue : 90.0f * f * (1.0f - exponentialValue) - 90.0f;
            float animFirstHalf = Mth.clamp((float)(exponentialValue / 0.5f), (float)0.0f, (float)1.0f);
            float animSecondHalf = Mth.clamp((float)((exponentialValue - 0.5f) / 0.5f), (float)0.0f, (float)1.0f);
            if ((double)relativeValue <= 0.5) {
                relativeAnimationValue = (float)((double)relativeValue / 0.5);
                rotation = 82.5f * f * relativeAnimationValue - (float)((Boolean)state.getValue((Property)TrainStepBlock.OPEN) != false ? 0 : 90);
            } else {
                float startRotation = 82.5f;
                float endRotation = 90.0f;
                float interpolatedRotation = Mth.lerp((float)relativeAnimationValue, (float)startRotation, (float)endRotation);
                rotation = interpolatedRotation * f - (float)((Boolean)state.getValue((Property)TrainStepBlock.OPEN) != false ? 0 : 90);
            }
            if ((double)exponentialValue <= 0.5) {
                float movement2Main = (float)(0.03125 + 0.078125 * (double)animFirstHalf);
                float movement2Up = (float)(0.65625 - 0.21875 * (double)animFirstHalf);
                Vec3 moveOffset2 = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movement2Main);
                movementF = new Vec3(moveOffset2.x, (double)movement2Up, moveOffset2.z);
            } else {
                float movement3Main = (float)(0.109375 + 0.234375 * (double)animSecondHalf);
                float movement3Up = (float)(0.4375 - 0.09375 * (double)animSecondHalf);
                Vec3 moveOffset3 = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movement3Main);
                movementF = new Vec3(moveOffset3.x, (double)movement3Up, moveOffset3.z);
            }
            float animFirstQuarter = Mth.clamp((float)(exponentialValue / 0.25f), (float)0.0f, (float)1.0f);
            float animSecondQuarter = Mth.clamp((float)((exponentialValue - 0.25f) / 0.25f), (float)0.0f, (float)1.0f);
            float animThirdQuarter = Mth.clamp((float)((exponentialValue - 0.5f) / 0.25f), (float)0.0f, (float)1.0f);
            float animFourthQuarter = Mth.clamp((float)((exponentialValue - 0.75f) / 0.25f), (float)0.0f, (float)1.0f);
            if ((double)exponentialValue <= 0.25) {
                movementMMain = (float)(0.0 + 0.015625 * (double)animFirstQuarter);
                movementMUp = 0.0f - 0.125f * animFirstQuarter;
                moveOffsetM = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMMain);
                movementM = new Vec3(moveOffsetM.x, (double)movementMUp, moveOffsetM.z);
            } else if ((double)exponentialValue > 0.25 && (double)exponentialValue <= 0.5) {
                movementMMain = (float)(0.015625 + 0.046875 * (double)animSecondQuarter);
                movementMUp = (float)(-0.125 - 0.09375 * (double)animSecondQuarter);
                moveOffsetM = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMMain);
                movementM = new Vec3(moveOffsetM.x, (double)movementMUp, moveOffsetM.z);
            } else if ((double)exponentialValue > 0.5 && (double)exponentialValue <= 0.75) {
                movementMMain = (float)(0.0625 + 0.078125 * (double)animThirdQuarter);
                movementMUp = (float)(-0.21875 - (double)(0.0625f * animThirdQuarter));
                moveOffsetM = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMMain);
                movementM = new Vec3(moveOffsetM.x, (double)movementMUp, moveOffsetM.z);
            } else {
                movementMMain = (float)(0.140625 + 0.171875 * (double)animFourthQuarter);
                movementMUp = (float)(-0.28125 - 0.03125 * (double)animFourthQuarter);
                moveOffsetM = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMMain);
                movementM = new Vec3(moveOffsetM.x, (double)movementMUp, moveOffsetM.z);
            }
            for (Direction face : Iterate.directions) {
                TrainStepBlockEntity ts;
                TrainStepBlockEntity.SlideMode mode;
                ConnectedTextureBehaviour.CTContext context = behaviour.buildContext((BlockAndTintGetter)world, pos, state, face, dataType.getContextRequirement());
                int textureIndex = dataType.getTextureIndex(context);
                if (facing == Direction.EAST && face != Direction.UP && face != Direction.DOWN) {
                    face = face.getCounterClockWise();
                }
                if (facing == Direction.SOUTH && face != Direction.UP && face != Direction.DOWN) {
                    face = face.getOpposite();
                }
                if (facing == Direction.WEST && face != Direction.UP && face != Direction.DOWN) {
                    face = face.getClockWise();
                }
                ResourceLocation resourceLocation = CreateTrainParts.asResource(blockTexturePath + "/" + facing.getSerializedName() + "_" + connectedState.getSerializedName() + "_" + face.getSerializedName());
                PartialModel move = AllPartialModels.TRAIN_STEP_MOVE.get(resourceLocation);
                PartialModel flap = AllPartialModels.TRAIN_STEP_FLAP.get(resourceLocation);
                PartialModel block = AllPartialModels.TRAIN_STEP.get(resourceLocation);
                PartialModel slide = AllPartialModels.TRAIN_STEP_SLIDE.get(resourceLocation);
                PartialModel pivot = AllPartialModels.TRAIN_STEP_PIVOT.get(resourceLocation);
                SuperByteBuffer partial_block = CachedBuffers.partial((PartialModel)block, (BlockState)state);
                CTSpriteShiftEntry spriteShift = null;
                if (blockTexturePath.equals("train_step_andesite")) {
                    spriteShift = com.simibubi.create.AllSpriteShifts.ANDESITE_CASING;
                } else if (blockTexturePath.equals("train_step_brass")) {
                    spriteShift = com.simibubi.create.AllSpriteShifts.BRASS_CASING;
                } else if (blockTexturePath.equals("train_step_copper")) {
                    spriteShift = com.simibubi.create.AllSpriteShifts.COPPER_CASING;
                } else if (blockTexturePath.equals("train_step_train")) {
                    spriteShift = face == Direction.UP || face == Direction.DOWN ? AllSpriteShifts.TRAIN_STEP_TRAIN : AllSpriteShifts.TRAIN_STEP_SIDE;
                } else {
                    return;
                }
                if (spriteShift == null) {
                    return;
                }
                SuperByteBuffer partial_slide = CachedBuffers.partial((PartialModel)slide, (BlockState)state);
                SuperByteBuffer partial_pivot = CachedBuffers.partial((PartialModel)pivot, (BlockState)state);
                SuperByteBuffer partial_move = CachedBuffers.partial((PartialModel)move, (BlockState)state);
                SuperByteBuffer partial_flap = CachedBuffers.partial((PartialModel)flap, (BlockState)state);
                float row = Math.floorDiv(textureIndex, 8);
                float column = textureIndex % 8;
                float u = column / 8.0f;
                float v = row / 8.0f;
                BlockPos blockPos = pos;
                int blockLight = TrainStepRenderer.getSafeLight((BlockAndTintGetter)world, blockPos, light);
                if (world instanceof ContraptionWorld) {
                    ((SuperByteBuffer)((SuperByteBuffer)partial_block.transform(ms)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(blockLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
                } else {
                    ((SuperByteBuffer)partial_block.rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(blockLight).renderInto(ms, vb);
                }
                BlockPos flapPos = pos.offset((int)Math.round(movementF.x), (int)Math.round(movementF.y), (int)Math.round(movementF.z));
                int flapLight = TrainStepRenderer.getSafeLight((BlockAndTintGetter)world, flapPos, light);
                if (world instanceof ContraptionWorld) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_flap.transform(ms)).translate(movementF.x, movementF.y, movementF.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateXDegrees(rotation)).light(flapLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
                } else {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_flap.translate(movementF.x, movementF.y, movementF.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateXDegrees(rotation)).light(flapLight).renderInto(ms, vb);
                }
                BlockPos movePos = pos.offset((int)Math.round(movementM.x), (int)Math.round(movementM.y), (int)Math.round(movementM.z));
                int moveLight = TrainStepRenderer.getSafeLight((BlockAndTintGetter)world, movePos, light);
                if (world instanceof ContraptionWorld) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_move.transform(ms)).translate(movementM.x, movementM.y, movementM.z)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(moveLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
                } else {
                    ((SuperByteBuffer)((SuperByteBuffer)partial_move.translate(movementM.x, movementM.y, movementM.z)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(moveLight).renderInto(ms, vb);
                }
                BlockEntity be = world.getBlockEntity(pos);
                if (be instanceof TrainStepBlockEntity && (mode = (ts = (TrainStepBlockEntity)be).getMode()) == TrainStepBlockEntity.SlideMode.NO_SLIDE) {
                    moveOffset = Vec3.ZERO;
                }
                BlockPos slidePos = pos.offset((int)Math.round(moveOffset.x), (int)Math.round(moveOffset.y), (int)Math.round(moveOffset.z));
                int slideLight = TrainStepRenderer.getSafeLight((BlockAndTintGetter)world, slidePos, light);
                if (world instanceof ContraptionWorld) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_slide.transform(ms)).translate(moveOffset.x, moveOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(slideLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
                } else {
                    ((SuperByteBuffer)((SuperByteBuffer)partial_slide.translate(moveOffset.x, moveOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(slideLight).renderInto(ms, vb);
                }
                BlockPos pivotPos = pos.offset((int)Math.round(moveOffsetP.x), (int)Math.round(0.96875), (int)Math.round(moveOffsetP.z));
                int pivotLight = TrainStepRenderer.getSafeLight((BlockAndTintGetter)world, pivotPos, light);
                if (world instanceof ContraptionWorld) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_pivot.transform(ms)).translate(moveOffsetP.x, 0.96875, moveOffsetP.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateXDegrees(rotationPivot)).light(pivotLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
                    continue;
                }
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_pivot.translate(moveOffsetP.x, 0.96875, moveOffsetP.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateXDegrees(rotationPivot)).light(pivotLight).renderInto(ms, vb);
            }
        }
    }

    static int getSafeLight(BlockAndTintGetter world, BlockPos targetPos, int fallbackLight) {
        if (targetPos.getY() < world.getMinBuildHeight() || targetPos.getY() > world.getMaxBuildHeight()) {
            return fallbackLight;
        }
        int calculatedLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)targetPos);
        if (calculatedLight == 0) {
            BlockPos abovePos = targetPos.above();
            int aboveLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)abovePos);
            if (aboveLight > 0) {
                return aboveLight;
            }
            return fallbackLight;
        }
        return calculatedLight;
    }
}

