/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainStep;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import com.tiestoettoet.create_train_parts.AllBlockEntityTypes;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlockEntity;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepType;
import com.tiestoettoet.create_train_parts.foundation.block.WrenchableHorizontalDirectionalBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrainStepBlock
extends WrenchableHorizontalDirectionalBlock
implements IBE<TrainStepBlockEntity>,
IHaveBigOutline {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final BooleanProperty VISIBLE = BooleanProperty.create((String)"visible");
    public static final EnumProperty<ConnectedState> CONNECTED = EnumProperty.create((String)"connected", ConnectedState.class);
    protected static final VoxelShape NORTH_OPEN_NONE;
    protected static final VoxelShape NORTH_OPEN_NONE_NOSLIDE;
    protected static final VoxelShape NORTH_OPEN_RIGHT;
    protected static final VoxelShape NORTH_OPEN_RIGHT_NOSLIDE;
    protected static final VoxelShape NORTH_OPEN_LEFT;
    protected static final VoxelShape NORTH_OPEN_LEFT_NOSLIDE;
    protected static final VoxelShape NORTH_OPEN_BOTH;
    protected static final VoxelShape NORTH_OPEN_BOTH_NOSLIDE;
    protected static final VoxelShape SOUTH_OPEN_NONE;
    protected static final VoxelShape SOUTH_OPEN_NONE_NOSLIDE;
    protected static final VoxelShape SOUTH_OPEN_RIGHT;
    protected static final VoxelShape SOUTH_OPEN_RIGHT_NOSLIDE;
    protected static final VoxelShape SOUTH_OPEN_LEFT;
    protected static final VoxelShape SOUTH_OPEN_LEFT_NOSLIDE;
    protected static final VoxelShape SOUTH_OPEN_BOTH;
    protected static final VoxelShape SOUTH_OPEN_BOTH_NOSLIDE;
    protected static final VoxelShape WEST_OPEN_NONE;
    protected static final VoxelShape WEST_OPEN_NONE_NOSLIDE;
    protected static final VoxelShape WEST_OPEN_RIGHT;
    protected static final VoxelShape WEST_OPEN_RIGHT_NOSLIDE;
    protected static final VoxelShape WEST_OPEN_LEFT;
    protected static final VoxelShape WEST_OPEN_LEFT_NOSLIDE;
    protected static final VoxelShape WEST_OPEN_BOTH;
    protected static final VoxelShape WEST_OPEN_BOTH_NOSLIDE;
    protected static final VoxelShape EAST_OPEN_NONE;
    protected static final VoxelShape EAST_OPEN_NONE_NOSLIDE;
    protected static final VoxelShape EAST_OPEN_RIGHT;
    protected static final VoxelShape EAST_OPEN_RIGHT_NOSLIDE;
    protected static final VoxelShape EAST_OPEN_LEFT;
    protected static final VoxelShape EAST_OPEN_LEFT_NOSLIDE;
    protected static final VoxelShape EAST_OPEN_BOTH;
    protected static final VoxelShape EAST_OPEN_BOTH_NOSLIDE;
    protected static final VoxelShape CLOSED;
    private final BlockSetType type = BlockSetType.OAK;
    public static final EnumProperty<TrainStepType> TYPE;

    @Override
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public TrainStepBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        TrainStepBlockEntity.SlideMode mode;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        TrainStepBlockEntity.SlideMode slideMode = mode = blockEntity instanceof TrainStepBlockEntity ? ((TrainStepBlockEntity)blockEntity).getMode() : TrainStepBlockEntity.SlideMode.SLIDE;
        if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return CLOSED;
        }
        if (mode == TrainStepBlockEntity.SlideMode.SLIDE) {
            switch (((ConnectedState)((Object)state.getValue(CONNECTED))).ordinal()) {
                case 0: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_NONE;
                        case Direction.SOUTH -> SOUTH_OPEN_NONE;
                        case Direction.WEST -> WEST_OPEN_NONE;
                        case Direction.EAST -> EAST_OPEN_NONE;
                    };
                }
                case 2: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_LEFT;
                        case Direction.SOUTH -> SOUTH_OPEN_LEFT;
                        case Direction.WEST -> WEST_OPEN_LEFT;
                        case Direction.EAST -> EAST_OPEN_LEFT;
                    };
                }
                case 1: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_RIGHT;
                        case Direction.SOUTH -> SOUTH_OPEN_RIGHT;
                        case Direction.WEST -> WEST_OPEN_RIGHT;
                        case Direction.EAST -> EAST_OPEN_RIGHT;
                    };
                }
                case 3: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_BOTH;
                        case Direction.SOUTH -> SOUTH_OPEN_BOTH;
                        case Direction.WEST -> WEST_OPEN_BOTH;
                        case Direction.EAST -> EAST_OPEN_BOTH;
                    };
                }
            }
        } else {
            switch (((ConnectedState)((Object)state.getValue(CONNECTED))).ordinal()) {
                case 0: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_NONE_NOSLIDE;
                        case Direction.SOUTH -> SOUTH_OPEN_NONE_NOSLIDE;
                        case Direction.WEST -> WEST_OPEN_NONE_NOSLIDE;
                        case Direction.EAST -> EAST_OPEN_NONE_NOSLIDE;
                    };
                }
                case 2: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_LEFT_NOSLIDE;
                        case Direction.SOUTH -> SOUTH_OPEN_LEFT_NOSLIDE;
                        case Direction.WEST -> WEST_OPEN_LEFT_NOSLIDE;
                        case Direction.EAST -> EAST_OPEN_LEFT_NOSLIDE;
                    };
                }
                case 1: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_RIGHT_NOSLIDE;
                        case Direction.SOUTH -> SOUTH_OPEN_RIGHT_NOSLIDE;
                        case Direction.WEST -> WEST_OPEN_RIGHT_NOSLIDE;
                        case Direction.EAST -> EAST_OPEN_RIGHT_NOSLIDE;
                    };
                }
                case 3: {
                    return switch ((Direction)state.getValue((Property)FACING)) {
                        default -> NORTH_OPEN_BOTH_NOSLIDE;
                        case Direction.SOUTH -> SOUTH_OPEN_BOTH_NOSLIDE;
                        case Direction.WEST -> WEST_OPEN_BOTH_NOSLIDE;
                        case Direction.EAST -> EAST_OPEN_BOTH_NOSLIDE;
                    };
                }
            }
        }
        return CLOSED;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TrainStepBlockEntity) {
            TrainStepBlockEntity trainStepBlockEntity = (TrainStepBlockEntity)blockEntity;
            trainStepBlockEntity.setNeighborState(state);
        }
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, CollisionContext.empty());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelForPlacement;
        BlockEntity blockEntity;
        BlockPos pos = pContext.getClickedPos();
        BlockState state = pContext.getLevel().getBlockState(pos);
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        Level level = pContext.getLevel();
        String function = "getStateForPlacement";
        TrainStepType type = this.determineType(pContext.getItemInHand());
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        boolean open = false;
        BlockState leftState = level.getBlockState(pos.relative(facing.getCounterClockWise()));
        BlockState rightState = level.getBlockState(pos.relative(facing.getClockWise()));
        if (leftState.getBlock() instanceof TrainStepBlock && leftState.hasProperty((Property)OPEN) && ((Boolean)leftState.getValue((Property)OPEN)).booleanValue()) {
            open = true;
        }
        if (rightState.getBlock() instanceof TrainStepBlock && rightState.hasProperty((Property)OPEN) && ((Boolean)rightState.getValue((Property)OPEN)).booleanValue()) {
            open = true;
        }
        if ((blockEntity = (levelForPlacement = pContext.getLevel()).getBlockEntity(pos)) instanceof TrainStepBlockEntity) {
            TrainStepBlockEntity trainStepBlockEntity = (TrainStepBlockEntity)blockEntity;
            trainStepBlockEntity.setTrainStepType(type);
        }
        if (stateForPlacement != null && ((Boolean)stateForPlacement.getValue((Property)OPEN)).booleanValue()) {
            stateForPlacement = (BlockState)stateForPlacement.setValue(TYPE, (Comparable)((Object)type));
            state = TrainStepBlock.getState(stateForPlacement, pos, level, facing, function);
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateForPlacement.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(!open))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(open))).setValue((Property)FACING, (Comparable)facing)).setValue(CONNECTED, (Comparable)((Object)((ConnectedState)((Object)state.getValue(CONNECTED)))))).setValue(TYPE, (Comparable)((Object)type));
        }
        return stateForPlacement;
    }

    private TrainStepType determineType(ItemStack item) {
        if (item.getItem() == AllBlocks.TRAIN_STEP_ANDESITE.asItem()) {
            return TrainStepType.ANDESITE;
        }
        if (item.getItem() == AllBlocks.TRAIN_STEP_BRASS.asItem()) {
            return TrainStepType.BRASS;
        }
        if (item.getItem() == AllBlocks.TRAIN_STEP_COPPER.asItem()) {
            return TrainStepType.COPPER;
        }
        if (item.getItem() == AllBlocks.TRAIN_STEP_TRAIN.asItem()) {
            return TrainStepType.TRAIN;
        }
        return TrainStepType.ANDESITE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return switch (pathComputationType) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            default -> false;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.toggle(state, level, pos, player, null, null);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() == AllItems.WRENCH.asItem()) {
            System.out.println("Wrench");
            this.rotate(state, Rotation.CLOCKWISE_90);
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void toggle(BlockState state, Level level, BlockPos pos, @Nullable Player player, String ignore, Boolean open) {
        this.toggle(state, level, pos, player, ignore, open, 10);
    }

    public void toggle(BlockState state, Level level, BlockPos pos, @Nullable Player player, String ignore, Boolean open, int flags) {
        state = (BlockState)state.cycle((Property)OPEN);
        if (ignore == null) {
            ignore = "";
        }
        if (open == null) {
            open = (Boolean)((BlockState)state.cycle((Property)OPEN)).getValue((Property)OPEN);
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState otherStepLeftState = null;
        BlockState otherStepRightState = null;
        BlockPos otherStepLeft = null;
        BlockPos otherStepRight = null;
        if (state.getValue(CONNECTED) == ConnectedState.BOTH) {
            otherStepLeftState = (BlockState)TrainStepBlock.getNeighbors(level, pos).get("left").get("state");
            otherStepRightState = (BlockState)TrainStepBlock.getNeighbors(level, pos).get("right").get("state");
            if (otherStepLeftState.getBlock() instanceof TrainStepBlock && otherStepLeftState.getValue((Property)FACING) == facing && !ignore.equals("left")) {
                otherStepLeftState = (BlockState)((BlockState)otherStepLeftState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                otherStepLeft = (BlockPos)TrainStepBlock.getNeighbors(level, pos).get("left").get("pos");
                this.toggle(otherStepLeftState, level, otherStepLeft, player, "right", open, flags);
            }
            if (otherStepRightState.getBlock() instanceof TrainStepBlock && otherStepRightState.getValue((Property)FACING) == facing && !ignore.equals("right")) {
                otherStepRightState = (BlockState)((BlockState)otherStepRightState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                otherStepRight = (BlockPos)TrainStepBlock.getNeighbors(level, pos).get("right").get("pos");
                this.toggle(otherStepRightState, level, otherStepRight, player, "left", open, flags);
            }
        } else if (state.getValue(CONNECTED) == ConnectedState.LEFT) {
            otherStepLeftState = (BlockState)TrainStepBlock.getNeighbors(level, pos).get("left").get("state");
            if (otherStepLeftState.getBlock() instanceof TrainStepBlock && otherStepLeftState.getValue((Property)FACING) == facing && !ignore.equals("left")) {
                otherStepLeftState = (BlockState)((BlockState)otherStepLeftState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                otherStepLeft = (BlockPos)TrainStepBlock.getNeighbors(level, pos).get("left").get("pos");
                this.toggle(otherStepLeftState, level, otherStepLeft, player, "right", open, flags);
            }
        } else if (state.getValue(CONNECTED) == ConnectedState.RIGHT && (otherStepRightState = (BlockState)TrainStepBlock.getNeighbors(level, pos).get("right").get("state")).getBlock() instanceof TrainStepBlock && otherStepRightState.getValue((Property)FACING) == facing && !ignore.equals("right")) {
            otherStepRightState = (BlockState)((BlockState)otherStepRightState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
            otherStepRight = (BlockPos)TrainStepBlock.getNeighbors(level, pos).get("right").get("pos");
            this.toggle(otherStepRightState, level, otherStepRight, player, "left", open, flags);
        }
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            state = (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, state, flags);
        level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        level.sendBlockUpdated(pos, state, state, 3);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (!state.is((Block)this)) {
            return;
        }
        if ((Boolean)state.getValue((Property)OPEN) == open) {
            return;
        }
        BlockState changedState = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
        if (open) {
            changedState = (BlockState)changedState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, changedState, 10);
        level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TrainStepBlockEntity trainStepBlockEntity;
        if (!(state.getBlock() instanceof TrainStepBlock)) {
            return;
        }
        boolean isPowered = TrainStepBlock.isStepPowered(level, pos, state);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        boolean open = (Boolean)state.getValue((Property)OPEN);
        TrainStepType type = (TrainStepType)((Object)state.getValue(TYPE));
        BlockState leftState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getCounterClockWise()));
        BlockState rightState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise()));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrainStepBlockEntity) {
            trainStepBlockEntity = (TrainStepBlockEntity)blockEntity;
            Map<String, BlockState> neighborStates = trainStepBlockEntity.getNeighborStates();
            BlockState oldLeftState = neighborStates.get("left");
            BlockState oldRightState = neighborStates.get("right");
            if (oldLeftState != null && leftState.getBlock() != oldLeftState.getBlock() || oldRightState != null && rightState.getBlock() != oldRightState.getBlock()) {
                state = TrainStepBlock.getState(state, pos, level, (Direction)state.getValue((Property)FACING), "neighborChanged");
                state = (BlockState)((BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue(TYPE, (Comparable)((Object)type));
                level.setBlock(pos, state, 2);
            } else {
                level.setBlock(pos, state, 2);
            }
        } else {
            level.setBlock(pos, state, 2);
        }
        if (isPowered != powered) {
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
            state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!isPowered));
            this.toggle(state, level, pos, null, null, !isPowered, 2);
        } else {
            level.setBlock(pos, state, 2);
        }
        if (blockEntity instanceof TrainStepBlockEntity) {
            trainStepBlockEntity = (TrainStepBlockEntity)blockEntity;
            trainStepBlockEntity.setNeighborState(state);
        }
    }

    public static Map<String, Map<String, Object>> getNeighbors(Level level, BlockPos pos) {
        BlockState rightState;
        BlockState leftState;
        BlockPos right;
        BlockPos left;
        HashMap<String, Map<String, Object>> neighbors = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> leftData = new HashMap<String, Object>();
        HashMap<String, Object> rightData = new HashMap<String, Object>();
        Direction facing = (Direction)level.getBlockState(pos).getValue((Property)FACING);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int x = pos.getX();
            left = new BlockPos(facing == Direction.NORTH ? x + 1 : x - 1, pos.getY(), pos.getZ());
            right = new BlockPos(facing == Direction.NORTH ? x - 1 : x + 1, pos.getY(), pos.getZ());
            leftState = level.getBlockState(left);
            rightState = level.getBlockState(right);
        } else {
            int z = pos.getZ();
            left = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z + 1 : z - 1);
            right = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z - 1 : z + 1);
            leftState = level.getBlockState(left);
            rightState = level.getBlockState(right);
        }
        leftData.put("state", leftState);
        leftData.put("pos", left);
        rightData.put("state", rightState);
        rightData.put("pos", right);
        neighbors.put("left", leftData);
        neighbors.put("right", rightData);
        return neighbors;
    }

    public static BlockState getState(BlockState state, BlockPos pos, Level level, Direction facing, String function) {
        BlockState finalState;
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int x = pos.getX();
            BlockPos nextLeftPos = new BlockPos(facing == Direction.NORTH ? x + 1 : x - 1, pos.getY(), pos.getZ());
            BlockPos nextRightPos = new BlockPos(facing == Direction.NORTH ? x - 1 : x + 1, pos.getY(), pos.getZ());
            BlockState nextLeftState = level.getBlockState(nextLeftPos);
            BlockState nextRightState = level.getBlockState(nextRightPos);
            boolean blockLeft = false;
            boolean blockRight = false;
            if (nextLeftState.getBlock() instanceof TrainStepBlock && nextLeftState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextLeftState.getValue(TYPE)) {
                blockLeft = true;
            }
            if (nextRightState.getBlock() instanceof TrainStepBlock && nextRightState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextRightState.getValue(TYPE)) {
                blockRight = true;
            }
            finalState = blockLeft && blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.BOTH)) : (blockLeft ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.LEFT)) : (blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.RIGHT)) : (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.NONE))));
        } else {
            int z = pos.getZ();
            BlockPos nextLeftPos = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z + 1 : z - 1);
            BlockPos nextRightPos = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z - 1 : z + 1);
            BlockState nextLeftState = level.getBlockState(nextLeftPos);
            BlockState nextRightState = level.getBlockState(nextRightPos);
            boolean blockLeft = false;
            boolean blockRight = false;
            if (nextLeftState.getBlock() instanceof TrainStepBlock && nextLeftState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextLeftState.getValue(TYPE)) {
                blockLeft = true;
            }
            if (nextRightState.getBlock() instanceof TrainStepBlock && nextRightState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextRightState.getValue(TYPE)) {
                blockRight = true;
            }
            finalState = blockLeft && blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.BOTH)) : (blockLeft ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.LEFT)) : (blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.RIGHT)) : (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.NONE))));
        }
        if (((Boolean)finalState.getValue((Property)OPEN)).booleanValue()) {
            finalState = (BlockState)finalState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        return finalState;
    }

    public static boolean sameKind(BlockState state1, BlockState state2) {
        return state1.getValue((Property)FACING) == state2.getValue((Property)FACING) && state1.getValue((Property)OPEN) == state2.getValue((Property)OPEN) && state1.getValue((Property)POWERED) == state2.getValue((Property)POWERED) && state1.getValue((Property)VISIBLE) == state2.getValue((Property)VISIBLE) && state1.getValue(TYPE) == state2.getValue(TYPE);
    }

    public static boolean isStepPowered(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        return level.hasNeighborSignal(pos) || level.hasNeighborSignal(leftPos) || level.hasNeighborSignal(rightPos);
    }

    public static boolean isStepOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, POWERED, CONNECTED, VISIBLE, TYPE});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected BlockSetType getType() {
        return this.type;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return super.newBlockEntity(pos, state);
    }

    public Class<TrainStepBlockEntity> getBlockEntityClass() {
        return TrainStepBlockEntity.class;
    }

    public BlockEntityType<? extends TrainStepBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.TRAIN_STEP.get();
    }

    static {
        TYPE = EnumProperty.create((String)"type", TrainStepType.class);
        CLOSED = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_OPEN_NONE = Stream.of(Stream.of(Block.box((double)1.0, (double)11.0, (double)11.0, (double)15.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)1.0, (double)11.0, (double)10.0, (double)15.0, (double)16.0, (double)11.0), Block.box((double)1.0, (double)6.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), Block.box((double)1.0, (double)5.0, (double)5.0, (double)15.0, (double)6.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)6.0, (double)5.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)-5.0, (double)15.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.OR), Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_NONE_NOSLIDE = Stream.of(Shapes.join((VoxelShape)NORTH_OPEN_NONE, (VoxelShape)Block.box((double)1.0, (double)0.0, (double)-5.0, (double)15.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)0.0, (double)11.0, (double)11.0, (double)15.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)0.0, (double)11.0, (double)10.0, (double)15.0, (double)16.0, (double)11.0), Block.box((double)0.0, (double)6.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), Block.box((double)0.0, (double)5.0, (double)5.0, (double)15.0, (double)6.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)0.0, (double)15.0, (double)6.0, (double)5.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)-5.0, (double)15.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)5.0, (double)15.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_RIGHT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)NORTH_OPEN_RIGHT, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)-5.0, (double)15.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)1.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)1.0, (double)11.0, (double)10.0, (double)16.0, (double)16.0, (double)11.0), Block.box((double)1.0, (double)6.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)1.0, (double)5.0, (double)5.0, (double)16.0, (double)6.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)1.0, (double)1.0, (double)0.0, (double)16.0, (double)6.0, (double)5.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)-5.0, (double)16.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.OR), Block.box((double)1.0, (double)0.0, (double)5.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_LEFT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)NORTH_OPEN_LEFT, (VoxelShape)Block.box((double)1.0, (double)0.0, (double)-5.0, (double)16.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_BOTH = Stream.of(Block.box((double)0.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)0.0, (double)11.0, (double)10.0, (double)16.0, (double)16.0, (double)11.0), Block.box((double)0.0, (double)6.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)6.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)6.0, (double)5.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)-5.0, (double)16.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_BOTH_NOSLIDE = Stream.of(Shapes.join((VoxelShape)NORTH_OPEN_BOTH, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)-5.0, (double)16.0, (double)1.0, (double)0.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_NONE = Stream.of(Stream.of(Block.box((double)0.0, (double)11.0, (double)1.0, (double)5.0, (double)16.0, (double)15.0), Stream.of(Block.box((double)5.0, (double)11.0, (double)1.0, (double)6.0, (double)16.0, (double)15.0), Block.box((double)5.0, (double)6.0, (double)1.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)6.0, (double)5.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)11.0, (double)1.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0), (VoxelShape)Block.box((double)16.0, (double)0.0, (double)1.0, (double)21.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)1.0, (double)11.0, (double)1.0, (double)15.0), Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)11.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_NONE_NOSLIDE = Stream.of(Shapes.join((VoxelShape)EAST_OPEN_NONE, (VoxelShape)Block.box((double)16.0, (double)0.0, (double)1.0, (double)21.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)11.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)0.0, (double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)15.0), Stream.of(Block.box((double)5.0, (double)11.0, (double)0.0, (double)6.0, (double)16.0, (double)15.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)6.0, (double)5.0, (double)0.0, (double)11.0, (double)6.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)11.0, (double)1.0, (double)0.0, (double)16.0, (double)6.0, (double)15.0), (VoxelShape)Block.box((double)16.0, (double)0.0, (double)0.0, (double)21.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)15.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)11.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_RIGHT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)EAST_OPEN_RIGHT, (VoxelShape)Block.box((double)16.0, (double)0.0, (double)0.0, (double)21.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)0.0, (double)11.0, (double)1.0, (double)5.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)5.0, (double)11.0, (double)1.0, (double)6.0, (double)16.0, (double)16.0), Block.box((double)5.0, (double)6.0, (double)1.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)1.0, (double)11.0, (double)6.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)11.0, (double)1.0, (double)1.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)16.0, (double)0.0, (double)1.0, (double)21.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)1.0, (double)11.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_LEFT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)EAST_OPEN_LEFT, (VoxelShape)Block.box((double)16.0, (double)0.0, (double)1.0, (double)21.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)11.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_BOTH = Stream.of(Block.box((double)0.0, (double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)5.0, (double)11.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)0.0, (double)11.0, (double)6.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)11.0, (double)1.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)16.0, (double)0.0, (double)0.0, (double)21.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_BOTH_NOSLIDE = Stream.of(Shapes.join((VoxelShape)EAST_OPEN_BOTH, (VoxelShape)Block.box((double)16.0, (double)0.0, (double)0.0, (double)21.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_NONE = Stream.of(Stream.of(Block.box((double)1.0, (double)11.0, (double)0.0, (double)15.0, (double)16.0, (double)5.0), Stream.of(Block.box((double)1.0, (double)11.0, (double)5.0, (double)15.0, (double)16.0, (double)6.0), Block.box((double)1.0, (double)6.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), Block.box((double)1.0, (double)5.0, (double)6.0, (double)15.0, (double)6.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)1.0, (double)1.0, (double)11.0, (double)15.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.OR), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)11.0), Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)11.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_NONE_NOSLIDE = Stream.of(Shapes.join((VoxelShape)SOUTH_OPEN_NONE, (VoxelShape)Block.box((double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)1.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0), Stream.of(Block.box((double)1.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0, (double)6.0), Block.box((double)1.0, (double)6.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)1.0, (double)5.0, (double)6.0, (double)16.0, (double)6.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)1.0, (double)1.0, (double)11.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.OR), Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)11.0), Block.box((double)1.0, (double)1.0, (double)0.0, (double)16.0, (double)11.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_RIGHT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)SOUTH_OPEN_RIGHT, (VoxelShape)Block.box((double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)1.0, (double)0.0, (double)11.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)0.0, (double)11.0, (double)0.0, (double)15.0, (double)16.0, (double)5.0), Stream.of(Block.box((double)0.0, (double)11.0, (double)5.0, (double)15.0, (double)16.0, (double)6.0), Block.box((double)0.0, (double)6.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), Block.box((double)0.0, (double)5.0, (double)6.0, (double)15.0, (double)6.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)11.0, (double)15.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)11.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)15.0, (double)11.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_LEFT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)SOUTH_OPEN_LEFT, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)11.0, (double)15.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_BOTH = Stream.of(Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0), Stream.of(Block.box((double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0, (double)6.0), Block.box((double)0.0, (double)6.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)0.0, (double)5.0, (double)6.0, (double)16.0, (double)6.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)11.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)11.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)11.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_BOTH_NOSLIDE = Stream.of(Shapes.join((VoxelShape)SOUTH_OPEN_BOTH, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0, (double)21.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_NONE = Stream.of(Stream.of(Block.box((double)11.0, (double)11.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Stream.of(Block.box((double)10.0, (double)11.0, (double)1.0, (double)11.0, (double)16.0, (double)15.0), Block.box((double)5.0, (double)6.0, (double)1.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)5.0, (double)5.0, (double)1.0, (double)10.0, (double)6.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)1.0, (double)5.0, (double)6.0, (double)15.0), (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.OR), Block.box((double)5.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_NONE_NOSLIDE = Stream.of(Shapes.join((VoxelShape)WEST_OPEN_NONE, (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)1.0, (double)5.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)11.0, (double)11.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)10.0, (double)11.0, (double)1.0, (double)11.0, (double)16.0, (double)16.0), Block.box((double)5.0, (double)6.0, (double)1.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)5.0, (double)5.0, (double)1.0, (double)10.0, (double)6.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)1.0, (double)5.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.OR), Block.box((double)5.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_RIGHT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)WEST_OPEN_RIGHT, (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)1.0, (double)5.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)11.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), Stream.of(Block.box((double)10.0, (double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)15.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)5.0, (double)5.0, (double)0.0, (double)10.0, (double)6.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)0.0, (double)5.0, (double)6.0, (double)15.0), (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.OR), Block.box((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)15.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)11.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_LEFT_NOSLIDE = Stream.of(Shapes.join((VoxelShape)WEST_OPEN_LEFT, (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_BOTH = Stream.of(Block.box((double)11.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Stream.of(Block.box((double)10.0, (double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)5.0, (double)5.0, (double)0.0, (double)10.0, (double)6.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)0.0, (double)5.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.OR), Block.box((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_BOTH_NOSLIDE = Stream.of(Shapes.join((VoxelShape)WEST_OPEN_BOTH, (VoxelShape)Block.box((double)-5.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST), Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public static enum ConnectedState implements StringRepresentable
    {
        NONE,
        RIGHT,
        LEFT,
        BOTH;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

