/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainSlide;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.tiestoettoet.create_train_parts.AllPartialModels;
import com.tiestoettoet.create_train_parts.AllSpriteShifts;
import com.tiestoettoet.create_train_parts.CreateTrainParts;
import com.tiestoettoet.create_train_parts.content.decoration.encasing.EncasedCTBehaviour;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrainSlideRenderer
extends SafeBlockEntityRenderer<TrainSlideBlockEntity> {
    protected void renderSafe(TrainSlideBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Level world = be.getLevel();
        if (world instanceof VirtualRenderWorld) {
            return;
        }
        if (!be.shouldRenderSpecial(be.getBlockState())) {
            return;
        }
        TrainSlideRenderer.renderTrainSlide(be.getBlockState(), be.getBlockPos(), world, be.animation.getValue(partialTicks), ms, buffer, light, null);
    }

    public static void renderTrainSlide(BlockState state, BlockPos pos, Level world, float animValue, PoseStack ms, MultiBufferSource buffer, int light, ContraptionMatrices matrices) {
        if (!(state.getBlock() instanceof TrainSlideBlock)) {
            return;
        }
        EncasedCTBehaviour behaviour = new EncasedCTBehaviour(com.simibubi.create.AllSpriteShifts.ANDESITE_CASING);
        Direction facing = (Direction)state.getValue((Property)TrainSlideBlock.FACING);
        CTType dataType = behaviour.getDataType((BlockAndTintGetter)world, pos, state, facing);
        if (dataType == null) {
            return;
        }
        float rotationAngle = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        float exponentialValue = animValue * animValue;
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        ResourceLocation blockTexture = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        String blockTexturePath = blockTexture.getPath();
        TrainSlideBlock.ConnectedState connectedState = (TrainSlideBlock.ConnectedState)((Object)state.getValue(TrainSlideBlock.CONNECTED));
        float f = (Boolean)state.getValue((Property)TrainSlideBlock.OPEN) != false ? -1.0f : 1.0f;
        float movement = 0.3125f * exponentialValue * f;
        Direction movementDirection = (Boolean)state.getValue((Property)TrainSlideBlock.OPEN) != false ? facing.getOpposite() : facing;
        Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movement);
        float movementP = 0.65625f;
        Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementP);
        float valueFromThirdTenth = Mth.clamp((float)((exponentialValue - 0.3f) / 0.7f), (float)0.0f, (float)1.0f);
        float valueFromSeventhTenth = Mth.clamp((float)((exponentialValue - 0.7f) / 0.3f), (float)0.0f, (float)1.0f);
        float movementB = 0.8125f * exponentialValue * f;
        float movementC = 0.5625f * valueFromThirdTenth * f;
        float movementT = 0.25f * valueFromSeventhTenth * f;
        Vec3 moveOffsetB = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementB);
        Vec3 moveOffsetC = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementC);
        Vec3 moveOffsetT = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementT);
        for (Direction face : Iterate.directions) {
            CTSpriteShiftEntry spriteShift;
            ConnectedTextureBehaviour.CTContext context = behaviour.buildContext((BlockAndTintGetter)world, pos, state, face, dataType.getContextRequirement());
            int textureIndex = dataType.getTextureIndex(context);
            if (facing == Direction.EAST && face != Direction.UP && face != Direction.DOWN) {
                face = face.getCounterClockWise();
            }
            if (facing == Direction.SOUTH && face != Direction.UP && face != Direction.DOWN) {
                face = face.getOpposite();
            }
            if (facing == Direction.WEST && face != Direction.UP && face != Direction.DOWN) {
                face = face.getClockWise();
            }
            ResourceLocation resourceLocation = CreateTrainParts.asResource(blockTexturePath + "/" + facing.getSerializedName() + "_" + connectedState.getSerializedName() + "_" + face.getSerializedName());
            PartialModel top = AllPartialModels.TRAIN_SLIDE_TOP.get(resourceLocation);
            PartialModel centre = AllPartialModels.TRAIN_SLIDE_CENTRE.get(resourceLocation);
            PartialModel block = AllPartialModels.TRAIN_SLIDE.get(resourceLocation);
            PartialModel bottom = AllPartialModels.TRAIN_SLIDE_BOTTOM.get(resourceLocation);
            SuperByteBuffer partial_block = CachedBuffers.partial((PartialModel)block, (BlockState)state);
            switch (blockTexturePath) {
                case "train_slide_andesite": {
                    spriteShift = com.simibubi.create.AllSpriteShifts.ANDESITE_CASING;
                    break;
                }
                case "train_slide_brass": {
                    spriteShift = com.simibubi.create.AllSpriteShifts.BRASS_CASING;
                    break;
                }
                case "train_slide_copper": {
                    spriteShift = com.simibubi.create.AllSpriteShifts.COPPER_CASING;
                    break;
                }
                case "train_slide_train": {
                    if (face == Direction.UP || face == Direction.DOWN) {
                        spriteShift = AllSpriteShifts.TRAIN_STEP_TRAIN;
                        break;
                    }
                    spriteShift = AllSpriteShifts.TRAIN_STEP_SIDE;
                    break;
                }
                default: {
                    return;
                }
            }
            if (spriteShift == null) {
                return;
            }
            SuperByteBuffer partial_bottom = CachedBuffers.partial((PartialModel)bottom, (BlockState)state);
            SuperByteBuffer partial_top = CachedBuffers.partial((PartialModel)top, (BlockState)state);
            SuperByteBuffer partial_centre = CachedBuffers.partial((PartialModel)centre, (BlockState)state);
            float row = Math.floorDiv(textureIndex, 8);
            float column = textureIndex % 8;
            float u = column / 8.0f;
            float v = row / 8.0f;
            int blockLight = TrainSlideRenderer.getSafeLight((BlockAndTintGetter)world, pos, light);
            if (world instanceof ContraptionWorld) {
                ((SuperByteBuffer)((SuperByteBuffer)partial_block.transform(ms)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(blockLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
            } else {
                ((SuperByteBuffer)partial_block.rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(blockLight).renderInto(ms, vb);
            }
            BlockPos centrePos = pos.offset((int)Math.round(moveOffsetC.x), (int)Math.round(moveOffsetC.y), (int)Math.round(moveOffsetC.z));
            int centreLight = TrainSlideRenderer.getSafeLight((BlockAndTintGetter)world, centrePos, light);
            if (world instanceof ContraptionWorld) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_centre.transform(ms)).translate(moveOffsetC.x, moveOffsetC.y, moveOffsetC.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(centreLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
            } else {
                ((SuperByteBuffer)((SuperByteBuffer)partial_centre.translate(moveOffsetC.x, moveOffsetC.y, moveOffsetC.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(centreLight).renderInto(ms, vb);
            }
            BlockPos topPos = pos.offset((int)Math.round(moveOffsetT.x), (int)Math.round(moveOffsetT.y), (int)Math.round(moveOffsetT.z));
            int topLight = TrainSlideRenderer.getSafeLight((BlockAndTintGetter)world, topPos, light);
            if (world instanceof ContraptionWorld) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_top.transform(ms)).translate(moveOffsetT.x, moveOffsetT.y, moveOffsetT.z)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(topLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
            } else {
                ((SuperByteBuffer)((SuperByteBuffer)partial_top.translate(moveOffsetT.x, moveOffsetT.y, moveOffsetT.z)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(topLight).renderInto(ms, vb);
            }
            BlockPos bottomPos = pos.offset((int)Math.round(moveOffsetB.x), (int)Math.round(moveOffsetB.y), (int)Math.round(moveOffsetB.z));
            int bottomLight = TrainSlideRenderer.getSafeLight((BlockAndTintGetter)world, bottomPos, light);
            if (world instanceof ContraptionWorld) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial_bottom.transform(ms)).translate(moveOffsetB.x, moveOffsetB.y, moveOffsetB.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(bottomLight).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
                continue;
            }
            ((SuperByteBuffer)((SuperByteBuffer)partial_bottom.translate(moveOffsetB.x, moveOffsetB.y, moveOffsetB.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(bottomLight).renderInto(ms, vb);
        }
    }

    public static int getSafeLight(BlockAndTintGetter world, BlockPos targetPos, int fallbackLight) {
        if (targetPos.getY() < world.getMinBuildHeight() || targetPos.getY() > world.getMaxBuildHeight()) {
            return fallbackLight;
        }
        int calculatedLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)targetPos);
        if (calculatedLight == 0) {
            BlockPos abovePos = targetPos.above();
            int aboveLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)abovePos);
            if (aboveLight > 0) {
                return aboveLight;
            }
            return fallbackLight;
        }
        return calculatedLight;
    }
}

