/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainSlide;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.decoration.slidingDoor.DoorControl;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlockEntity;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideMovementBehaviourRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TrainSlideMovementBehaviour
implements MovementBehaviour {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public boolean mustTickWhileDisabled() {
        return true;
    }

    public void tick(MovementContext context) {
        TrainSlideAnimationData ae;
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = TrainSlideBlockEntity.isOpen(structureBlockInfo.state());
        if (!context.world.isClientSide()) {
            this.tickOpen(context, open);
        }
        if (!(context.temporaryData instanceof TrainSlideAnimationData)) {
            ae = new TrainSlideAnimationData();
            context.temporaryData = ae;
        } else {
            ae = (TrainSlideAnimationData)context.temporaryData;
        }
        boolean wasSettled = ae.animation.settled();
        ae.animation.chase(open ? 1.0 : 0.0, (double)0.15f, LerpedFloat.Chaser.LINEAR);
        ae.animation.tickChaser();
        if (!wasSettled && ae.animation.settled() && !open) {
            context.world.playLocalSound(context.position.x, context.position.y, context.position.z, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.125f, 1.0f, false);
        }
    }

    protected void tickOpen(MovementContext context, boolean currentlyOpen) {
        boolean shouldOpen = this.shouldOpen(context);
        if (!this.shouldUpdate(context, shouldOpen)) {
            return;
        }
        if (currentlyOpen == shouldOpen) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.state().hasProperty((Property)TrainSlideBlock.OPEN)) {
            return;
        }
        this.toggleSlide(pos, contraption, info);
        Direction facing = this.getSlideFacing(context);
        BlockPos inWorldSlide = BlockPos.containing((Position)context.position).relative(facing);
        BlockState inWorldSlideState = context.world.getBlockState(inWorldSlide);
        Block block = inWorldSlideState.getBlock();
        if (block instanceof TrainSlideBlock) {
            TrainSlideBlock sb = (TrainSlideBlock)block;
            if (inWorldSlideState.hasProperty((Property)TrainSlideBlock.OPEN) && inWorldSlideState.hasProperty((Property)HorizontalDirectionalBlock.FACING) && inWorldSlideState.getOptionalValue((Property)HorizontalDirectionalBlock.FACING).orElse(Direction.UP).getAxis() == facing.getAxis()) {
                sb.setOpen(null, context.world, inWorldSlideState, inWorldSlide, shouldOpen);
            }
        }
        if (shouldOpen) {
            context.world.playSound(null, BlockPos.containing((Position)context.position), SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, 0.125f, 1.0f);
        }
    }

    private void toggleSlide(BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState = (BlockState)info.state().cycle((Property)TrainSlideBlock.OPEN);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
        info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos.relative((Direction)info.state().getValue((Property)HorizontalDirectionalBlock.FACING)));
        if (info != null && info.state().hasProperty((Property)TrainSlideBlock.OPEN)) {
            newState = (BlockState)info.state().cycle((Property)TrainSlideBlock.OPEN);
            contraption.entity.setBlock(pos.relative((Direction)info.state().getValue((Property)HorizontalDirectionalBlock.FACING)), new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
            contraption.invalidateColliders();
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldOpen) {
        if (context.firstMovement && shouldOpen) {
            return false;
        }
        if (!context.data.contains("Open")) {
            context.data.putBoolean("Open", shouldOpen);
            return true;
        }
        boolean wasOpen = context.data.getBoolean("Open");
        context.data.putBoolean("Open", shouldOpen);
        return wasOpen != shouldOpen;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean shouldOpen(MovementContext context) {
        if (context.disabled) {
            return false;
        }
        contraption = context.contraption;
        if (context.motion.length() < 0.0078125 && !contraption.entity.isStalled()) ** GOTO lbl-1000
        if (contraption instanceof ElevatorContraption) {
            ec = (ElevatorContraption)contraption;
            ** if (!ec.arrived) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl12
        }
lbl-1000:
        // 2 sources

        {
            v0 = canOpen = false;
        }
lbl12:
        // 2 sources

        if (!canOpen) {
            context.temporaryData = null;
            return false;
        }
        if (context.temporaryData instanceof TrainSlideAnimationData && (var5_5 = ((TrainSlideAnimationData)context.temporaryData).doorControl) instanceof DoorControlBehaviour) {
            dcb = var5_5;
            if (dcb.blockEntity != null && !dcb.blockEntity.isRemoved()) {
                return this.shouldOpenAt(dcb, context);
            }
        }
        doorControls = null;
        var6_6 = context.contraption.entity;
        if (var6_6 instanceof CarriageContraptionEntity) {
            cce = (CarriageContraptionEntity)var6_6;
            doorControls = this.getTrainStationSlideControl(cce, context);
        }
        if (contraption instanceof ElevatorContraption) {
            ec = (ElevatorContraption)contraption;
            doorControls = this.getElevatorDoorControl(ec, context);
        }
        if (doorControls == null) {
            return false;
        }
        if (!(context.temporaryData instanceof TrainSlideAnimationData)) {
            ae = new TrainSlideAnimationData();
            context.temporaryData = ae;
        } else {
            ae = (TrainSlideAnimationData)context.temporaryData;
        }
        ae.doorControl = doorControls;
        return this.shouldOpenAt(doorControls, context);
    }

    protected boolean shouldOpenAt(DoorControlBehaviour controller, MovementContext context) {
        if (controller.mode == DoorControl.ALL) {
            return true;
        }
        if (controller.mode == DoorControl.NONE) {
            return false;
        }
        return controller.mode.matches(this.getSlideFacing(context));
    }

    protected DoorControlBehaviour getElevatorDoorControl(ElevatorContraption ec, MovementContext context) {
        Integer currentTargetY = ec.getCurrentTargetY(context.world);
        if (currentTargetY == null) {
            return null;
        }
        ElevatorColumn.ColumnCoords ColumnCoords2 = ec.getGlobalColumn();
        if (ColumnCoords2 == null) {
            return null;
        }
        ElevatorColumn elevatorColumn = ElevatorColumn.get((LevelAccessor)context.world, (ElevatorColumn.ColumnCoords)ColumnCoords2);
        if (elevatorColumn == null) {
            return null;
        }
        return (DoorControlBehaviour)BlockEntityBehaviour.get((BlockGetter)context.world, (BlockPos)elevatorColumn.contactAt(currentTargetY.intValue()), (BehaviourType)DoorControlBehaviour.TYPE);
    }

    protected DoorControlBehaviour getTrainStationSlideControl(CarriageContraptionEntity cce, MovementContext context) {
        Carriage carriage = cce.getCarriage();
        if (carriage == null || carriage.train == null) {
            return null;
        }
        GlobalStation currentStation = carriage.train.getCurrentStation();
        if (currentStation == null) {
            return null;
        }
        BlockPos stationPos = currentStation.getBlockEntityPos();
        ResourceKey stationDim = currentStation.getBlockEntityDimension();
        MinecraftServer server = context.world.getServer();
        if (server == null) {
            return null;
        }
        ServerLevel stationLevel = server.getLevel(stationDim);
        if (stationLevel == null || !stationLevel.isLoaded(stationPos)) {
            return null;
        }
        return (DoorControlBehaviour)BlockEntityBehaviour.get((BlockGetter)stationLevel, (BlockPos)stationPos, (BehaviourType)DoorControlBehaviour.TYPE);
    }

    protected Direction getSlideFacing(MovementContext context) {
        Direction stateFacing = (Direction)context.state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Direction originalFacing = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)stateFacing.getAxis());
        Vec3 centerOfContraption = context.contraption.bounds.getCenter();
        Vec3 diff = Vec3.atCenterOf((Vec3i)context.localPos).add(Vec3.atLowerCornerOf((Vec3i)stateFacing.getNormal()).scale((double)-0.45f)).subtract(centerOfContraption);
        if (originalFacing.getAxis().choose(diff.x, diff.y, diff.z) < 0.0) {
            originalFacing = originalFacing.getOpposite();
        }
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)originalFacing.getNormal());
        directionVec = (Vec3)context.rotation.apply(directionVec);
        return Direction.getNearest((double)directionVec.x, (double)directionVec.y, (double)directionVec.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        Object object = context.temporaryData;
        if (!(object instanceof TrainSlideAnimationData)) {
            return;
        }
        TrainSlideAnimationData ae = (TrainSlideAnimationData)object;
        TrainSlideMovementBehaviourRenderer.renderInContraption(context, renderWorld, matrices, buffer, ae.animation);
    }

    static class TrainSlideAnimationData {
        LerpedFloat animation = LerpedFloat.linear();
        DoorControlBehaviour doorControl;

        TrainSlideAnimationData() {
        }
    }
}

