/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainSlide;

import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TrainSlideBlockEntity
extends SmartBlockEntity {
    LerpedFloat animation;
    int bridgeTicks;
    boolean deferUpdate;
    Map<String, BlockState> neighborStates = new HashMap<String, BlockState>();
    TrainSlideType trainSlideType;
    protected AssemblyException lastException;
    Object openObj = null;

    public TrainSlideBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.animation = LerpedFloat.linear().startWithValue(TrainSlideBlockEntity.isOpen(this.getBlockState()) ? 1.0 : 0.0);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.lastException = AssemblyException.read((CompoundTag)tag, (HolderLookup.Provider)registries);
        super.read(tag, registries, clientPacket);
        this.invalidateRenderBoundingBox();
        if (tag.contains("ForceOpen")) {
            this.openObj = tag.getBoolean("ForceOpen");
        }
    }

    public void tick() {
        boolean open;
        if (this.deferUpdate && !this.level.isClientSide()) {
            this.deferUpdate = false;
            BlockState blockState = this.getBlockState();
            blockState.handleNeighborChanged(this.level, this.worldPosition, Blocks.AIR, this.worldPosition, false);
        }
        super.tick();
        BlockState block = this.getBlockState();
        TrainSlideBlock trainSlideBlock = (TrainSlideBlock)block.getBlock();
        boolean bl = open = this.openObj instanceof Boolean ? (Boolean)this.openObj : TrainSlideBlockEntity.isOpen(this.getBlockState());
        if (open != TrainSlideBlockEntity.isOpen(this.getBlockState())) {
            trainSlideBlock.toggle(block, this.level, this.worldPosition, null, null, open);
        }
        boolean wasSettled = this.animation.settled();
        this.animation.chase(open ? 1.0 : 0.0, (double)0.15f, LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        if (this.level.isClientSide()) {
            if (this.bridgeTicks < 2 && open) {
                ++this.bridgeTicks;
            } else if (this.bridgeTicks > 0 && !open && this.isVisible(this.getBlockState())) {
                --this.bridgeTicks;
            }
            return;
        }
        if (!open && !wasSettled && this.animation.settled() && !this.isVisible(this.getBlockState())) {
            this.showBlockModel();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(1.0);
    }

    protected boolean isVisible(BlockState state) {
        return state.getOptionalValue((Property)TrainSlideBlock.VISIBLE).orElse(true);
    }

    public void setNeighborState(BlockState state) {
        if (this.level == null) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)TrainSlideBlock.FACING);
        BlockPos leftPos = this.worldPosition.relative(facing.getCounterClockWise());
        BlockPos rightPos = this.worldPosition.relative(facing.getClockWise());
        BlockState leftState = this.level.getBlockState(leftPos);
        BlockState rightState = this.level.getBlockState(rightPos);
        this.neighborStates.put("left", leftState);
        this.neighborStates.put("right", rightState);
    }

    public Map<String, BlockState> getNeighborStates() {
        return this.neighborStates;
    }

    public void setTrainSlideType(TrainSlideType trainSlideType) {
        this.trainSlideType = trainSlideType;
    }

    public TrainSlideType getTrainSlideType() {
        return this.trainSlideType;
    }

    protected boolean shouldRenderSpecial(BlockState state) {
        return !this.isVisible(state) || this.bridgeTicks != 0;
    }

    protected void showBlockModel() {
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TrainSlideBlock.VISIBLE, (Comparable)Boolean.valueOf(true)), 3);
        this.level.playSound(null, this.worldPosition, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public static boolean isOpen(BlockState state) {
        return state.getOptionalValue((Property)TrainSlideBlock.OPEN).orElse(false);
    }
}

