/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainSlide;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import com.tiestoettoet.create_train_parts.AllBlockEntityTypes;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlockEntity;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrainSlideBlock
extends HorizontalDirectionalBlock
implements IBE<TrainSlideBlockEntity>,
IHaveBigOutline,
IWrenchable {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final BooleanProperty VISIBLE = BooleanProperty.create((String)"visible");
    public static final EnumProperty<ConnectedState> CONNECTED = EnumProperty.create((String)"connected", ConnectedState.class);
    protected static final VoxelShape NORTH_OPEN_NONE;
    protected static final VoxelShape NORTH_OPEN_RIGHT;
    protected static final VoxelShape NORTH_OPEN_LEFT;
    protected static final VoxelShape NORTH_OPEN_BOTH;
    protected static final VoxelShape SOUTH_OPEN_NONE;
    protected static final VoxelShape SOUTH_OPEN_RIGHT;
    protected static final VoxelShape SOUTH_OPEN_LEFT;
    protected static final VoxelShape SOUTH_OPEN_BOTH;
    protected static final VoxelShape WEST_OPEN_NONE;
    protected static final VoxelShape WEST_OPEN_RIGHT;
    protected static final VoxelShape WEST_OPEN_LEFT;
    protected static final VoxelShape WEST_OPEN_BOTH;
    protected static final VoxelShape EAST_OPEN_NONE;
    protected static final VoxelShape EAST_OPEN_RIGHT;
    protected static final VoxelShape EAST_OPEN_LEFT;
    protected static final VoxelShape EAST_OPEN_BOTH;
    protected static final VoxelShape CLOSED;
    private final BlockSetType type = BlockSetType.OAK;
    public static final EnumProperty<TrainSlideType> TYPE;

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public TrainSlideBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        TrainSlideBlockEntity trainSlideBlockEntity = (TrainSlideBlockEntity)level.getBlockEntity(pos);
        if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return CLOSED;
        }
        return switch (((ConnectedState)((Object)state.getValue(CONNECTED))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    default: {
                        yield NORTH_OPEN_NONE;
                    }
                    case SOUTH: {
                        yield SOUTH_OPEN_NONE;
                    }
                    case WEST: {
                        yield WEST_OPEN_NONE;
                    }
                    case EAST: 
                }
                yield EAST_OPEN_NONE;
            }
            case 2 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    default: {
                        yield NORTH_OPEN_LEFT;
                    }
                    case SOUTH: {
                        yield SOUTH_OPEN_LEFT;
                    }
                    case WEST: {
                        yield WEST_OPEN_LEFT;
                    }
                    case EAST: 
                }
                yield EAST_OPEN_LEFT;
            }
            case 1 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    default: {
                        yield NORTH_OPEN_RIGHT;
                    }
                    case SOUTH: {
                        yield SOUTH_OPEN_RIGHT;
                    }
                    case WEST: {
                        yield WEST_OPEN_RIGHT;
                    }
                    case EAST: 
                }
                yield EAST_OPEN_RIGHT;
            }
            case 3 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    default: {
                        yield NORTH_OPEN_BOTH;
                    }
                    case SOUTH: {
                        yield SOUTH_OPEN_BOTH;
                    }
                    case WEST: {
                        yield WEST_OPEN_BOTH;
                    }
                    case EAST: 
                }
                yield EAST_OPEN_BOTH;
            }
        };
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TrainSlideBlockEntity) {
            TrainSlideBlockEntity trainSlideBlockEntity = (TrainSlideBlockEntity)blockEntity;
            trainSlideBlockEntity.setNeighborState(state);
        }
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, CollisionContext.empty());
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelForPlacement;
        BlockEntity blockEntity;
        BlockPos pos = pContext.getClickedPos();
        BlockState state = pContext.getLevel().getBlockState(pos);
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        Level level = pContext.getLevel();
        String function = "getStateForPlacement";
        TrainSlideType type = this.determineType(pContext.getItemInHand());
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        boolean open = false;
        BlockState leftState = level.getBlockState(pos.relative(facing.getCounterClockWise()));
        BlockState rightState = level.getBlockState(pos.relative(facing.getClockWise()));
        if (leftState.getBlock() instanceof TrainSlideBlock && leftState.hasProperty((Property)OPEN) && ((Boolean)leftState.getValue((Property)OPEN)).booleanValue()) {
            open = true;
        }
        if (rightState.getBlock() instanceof TrainSlideBlock && rightState.hasProperty((Property)OPEN) && ((Boolean)rightState.getValue((Property)OPEN)).booleanValue()) {
            open = true;
        }
        if ((blockEntity = (levelForPlacement = pContext.getLevel()).getBlockEntity(pos)) instanceof TrainSlideBlockEntity) {
            TrainSlideBlockEntity trainSlideBlockEntity = (TrainSlideBlockEntity)blockEntity;
            trainSlideBlockEntity.setTrainSlideType(type);
        }
        if (stateForPlacement != null && ((Boolean)stateForPlacement.getValue((Property)OPEN)).booleanValue()) {
            stateForPlacement = (BlockState)stateForPlacement.setValue(TYPE, (Comparable)((Object)type));
            state = TrainSlideBlock.getState(stateForPlacement, pos, level, facing, function);
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateForPlacement.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(!open))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(open))).setValue((Property)FACING, (Comparable)facing)).setValue(CONNECTED, (Comparable)((Object)((ConnectedState)((Object)state.getValue(CONNECTED)))))).setValue(TYPE, (Comparable)((Object)type));
        }
        return stateForPlacement;
    }

    private TrainSlideType determineType(ItemStack item) {
        if (item.getItem() == AllBlocks.TRAIN_SLIDE_ANDESITE.asItem()) {
            return TrainSlideType.ANDESITE;
        }
        if (item.getItem() == AllBlocks.TRAIN_SLIDE_BRASS.asItem()) {
            return TrainSlideType.BRASS;
        }
        if (item.getItem() == AllBlocks.TRAIN_SLIDE_COPPER.asItem()) {
            return TrainSlideType.COPPER;
        }
        if (item.getItem() == AllBlocks.TRAIN_SLIDE_TRAIN.asItem()) {
            return TrainSlideType.TRAIN;
        }
        return TrainSlideType.ANDESITE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return switch (pathComputationType) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            default -> false;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.toggle(state, level, pos, player, null, null);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (explosion.canTriggerBlocks() && this.type.canOpenByWindCharge() && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            this.toggle(state, level, pos, null, null, null);
        }
        super.onExplosionHit(state, level, pos, explosion, dropConsumer);
    }

    public void toggle(BlockState state, Level level, BlockPos pos, @Nullable Player player, String ignore, Boolean open) {
        this.toggle(state, level, pos, player, ignore, open, 10);
    }

    public void toggle(BlockState state, Level level, BlockPos pos, @Nullable Player player, String ignore, Boolean open, int flags) {
        state = (BlockState)state.cycle((Property)OPEN);
        if (ignore == null) {
            ignore = "";
        }
        if (open == null) {
            open = (Boolean)((BlockState)state.cycle((Property)OPEN)).getValue((Property)OPEN);
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState otherSlideLeftState = null;
        BlockState otherSlideRightState = null;
        BlockPos otherSlideLeft = null;
        BlockPos otherSlideRight = null;
        if (state.getValue(CONNECTED) == ConnectedState.BOTH) {
            otherSlideLeftState = (BlockState)TrainSlideBlock.getNeighbors(level, pos).get("left").get("state");
            otherSlideRightState = (BlockState)TrainSlideBlock.getNeighbors(level, pos).get("right").get("state");
            if (otherSlideLeftState.getBlock() instanceof TrainSlideBlock && otherSlideLeftState.getValue((Property)FACING) == facing && !ignore.equals("left")) {
                otherSlideLeftState = (BlockState)((BlockState)otherSlideLeftState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                otherSlideLeft = (BlockPos)TrainSlideBlock.getNeighbors(level, pos).get("left").get("pos");
                this.toggle(otherSlideLeftState, level, otherSlideLeft, player, "right", open, flags);
            }
            if (otherSlideRightState.getBlock() instanceof TrainSlideBlock && otherSlideRightState.getValue((Property)FACING) == facing && !ignore.equals("right")) {
                otherSlideRightState = (BlockState)((BlockState)otherSlideRightState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                otherSlideRight = (BlockPos)TrainSlideBlock.getNeighbors(level, pos).get("right").get("pos");
                this.toggle(otherSlideRightState, level, otherSlideRight, player, "left", open, flags);
            }
        } else if (state.getValue(CONNECTED) == ConnectedState.LEFT) {
            otherSlideLeftState = (BlockState)TrainSlideBlock.getNeighbors(level, pos).get("left").get("state");
            if (otherSlideLeftState.getBlock() instanceof TrainSlideBlock && otherSlideLeftState.getValue((Property)FACING) == facing && !ignore.equals("left")) {
                otherSlideLeftState = (BlockState)((BlockState)otherSlideLeftState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
                otherSlideLeft = (BlockPos)TrainSlideBlock.getNeighbors(level, pos).get("left").get("pos");
                this.toggle(otherSlideLeftState, level, otherSlideLeft, player, "right", open, flags);
            }
        } else if (state.getValue(CONNECTED) == ConnectedState.RIGHT && (otherSlideRightState = (BlockState)TrainSlideBlock.getNeighbors(level, pos).get("right").get("state")).getBlock() instanceof TrainSlideBlock && otherSlideRightState.getValue((Property)FACING) == facing && !ignore.equals("right")) {
            otherSlideRightState = (BlockState)((BlockState)otherSlideRightState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
            otherSlideRight = (BlockPos)TrainSlideBlock.getNeighbors(level, pos).get("right").get("pos");
            this.toggle(otherSlideRightState, level, otherSlideRight, player, "left", open, flags);
        }
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            state = (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, state, flags);
        level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (!state.is((Block)this)) {
            return;
        }
        if ((Boolean)state.getValue((Property)OPEN) == open) {
            return;
        }
        BlockState changedState = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
        if (open) {
            changedState = (BlockState)changedState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, changedState, 10);
        level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TrainSlideBlockEntity trainSlideBlockEntity;
        if (!(state.getBlock() instanceof TrainSlideBlock)) {
            return;
        }
        boolean isPowered = TrainSlideBlock.isSlidePowered(level, pos, state);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        boolean open = (Boolean)state.getValue((Property)OPEN);
        TrainSlideType type = (TrainSlideType)((Object)state.getValue(TYPE));
        BlockState leftState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getCounterClockWise()));
        BlockState rightState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise()));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrainSlideBlockEntity) {
            trainSlideBlockEntity = (TrainSlideBlockEntity)blockEntity;
            Map<String, BlockState> neighborStates = trainSlideBlockEntity.getNeighborStates();
            BlockState oldLeftState = neighborStates.get("left");
            BlockState oldRightState = neighborStates.get("right");
            if (oldLeftState != null && leftState.getBlock() != oldLeftState.getBlock() || oldRightState != null && rightState.getBlock() != oldRightState.getBlock()) {
                state = TrainSlideBlock.getState(state, pos, level, (Direction)state.getValue((Property)FACING), "neighborChanged");
                state = (BlockState)((BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue(TYPE, (Comparable)((Object)type));
                level.setBlock(pos, state, 2);
            } else {
                level.setBlock(pos, state, 2);
            }
        } else {
            level.setBlock(pos, state, 2);
        }
        if (isPowered != powered) {
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
            state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!isPowered));
            this.toggle(state, level, pos, null, null, !isPowered, 2);
        } else {
            level.setBlock(pos, state, 2);
        }
        if (blockEntity instanceof TrainSlideBlockEntity) {
            trainSlideBlockEntity = (TrainSlideBlockEntity)blockEntity;
            trainSlideBlockEntity.setNeighborState(state);
        }
    }

    public static Map<String, Map<String, Object>> getNeighbors(Level level, BlockPos pos) {
        BlockState rightState;
        BlockState leftState;
        BlockPos right;
        BlockPos left;
        HashMap<String, Map<String, Object>> neighbors = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> leftData = new HashMap<String, Object>();
        HashMap<String, Object> rightData = new HashMap<String, Object>();
        Direction facing = (Direction)level.getBlockState(pos).getValue((Property)FACING);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int x = pos.getX();
            left = new BlockPos(facing == Direction.NORTH ? x + 1 : x - 1, pos.getY(), pos.getZ());
            right = new BlockPos(facing == Direction.NORTH ? x - 1 : x + 1, pos.getY(), pos.getZ());
            leftState = level.getBlockState(left);
            rightState = level.getBlockState(right);
        } else {
            int z = pos.getZ();
            left = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z + 1 : z - 1);
            right = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z - 1 : z + 1);
            leftState = level.getBlockState(left);
            rightState = level.getBlockState(right);
        }
        leftData.put("state", leftState);
        leftData.put("pos", left);
        rightData.put("state", rightState);
        rightData.put("pos", right);
        neighbors.put("left", leftData);
        neighbors.put("right", rightData);
        return neighbors;
    }

    public static BlockState getState(BlockState state, BlockPos pos, Level level, Direction facing, String function) {
        BlockState finalState;
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int x = pos.getX();
            BlockPos nextLeftPos = new BlockPos(facing == Direction.NORTH ? x + 1 : x - 1, pos.getY(), pos.getZ());
            BlockPos nextRightPos = new BlockPos(facing == Direction.NORTH ? x - 1 : x + 1, pos.getY(), pos.getZ());
            BlockState nextLeftState = level.getBlockState(nextLeftPos);
            BlockState nextRightState = level.getBlockState(nextRightPos);
            boolean blockLeft = false;
            boolean blockRight = false;
            if (nextLeftState.getBlock() instanceof TrainSlideBlock && nextLeftState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextLeftState.getValue(TYPE)) {
                blockLeft = true;
            }
            if (nextRightState.getBlock() instanceof TrainSlideBlock && nextRightState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextRightState.getValue(TYPE)) {
                blockRight = true;
            }
            finalState = blockLeft && blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.BOTH)) : (blockLeft ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.LEFT)) : (blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.RIGHT)) : (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.NONE))));
        } else {
            int z = pos.getZ();
            BlockPos nextLeftPos = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z + 1 : z - 1);
            BlockPos nextRightPos = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z - 1 : z + 1);
            BlockState nextLeftState = level.getBlockState(nextLeftPos);
            BlockState nextRightState = level.getBlockState(nextRightPos);
            boolean blockLeft = false;
            boolean blockRight = false;
            if (nextLeftState.getBlock() instanceof TrainSlideBlock && nextLeftState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextLeftState.getValue(TYPE)) {
                blockLeft = true;
            }
            if (nextRightState.getBlock() instanceof TrainSlideBlock && nextRightState.getValue((Property)FACING) == facing && state.getValue(TYPE) == nextRightState.getValue(TYPE)) {
                blockRight = true;
            }
            finalState = blockLeft && blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.BOTH)) : (blockLeft ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.LEFT)) : (blockRight ? (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.RIGHT)) : (BlockState)state.setValue(CONNECTED, (Comparable)((Object)ConnectedState.NONE))));
        }
        if (((Boolean)finalState.getValue((Property)OPEN)).booleanValue()) {
            finalState = (BlockState)finalState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        return finalState;
    }

    public static boolean isSlidePowered(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        return level.hasNeighborSignal(pos) || level.hasNeighborSignal(leftPos) || level.hasNeighborSignal(rightPos);
    }

    public static boolean isSlideOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, POWERED, CONNECTED, VISIBLE, TYPE});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected BlockSetType getType() {
        return this.type;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return super.newBlockEntity(pos, state);
    }

    public Class<TrainSlideBlockEntity> getBlockEntityClass() {
        return TrainSlideBlockEntity.class;
    }

    public BlockEntityType<? extends TrainSlideBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.TRAIN_SLIDE.get();
    }

    static {
        TYPE = EnumProperty.create((String)"type", TrainSlideType.class);
        CLOSED = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_OPEN_NONE = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)1.0, (double)10.0, (double)-4.0, (double)15.0, (double)15.0, (double)1.0), Block.box((double)1.0, (double)5.0, (double)-9.0, (double)15.0, (double)10.0, (double)1.0), Block.box((double)1.0, (double)0.0, (double)-13.0, (double)15.0, (double)5.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)10.0, (double)-4.0, (double)15.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)5.0, (double)-9.0, (double)15.0, (double)10.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)-13.0, (double)15.0, (double)5.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)1.0, (double)10.0, (double)-4.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)1.0, (double)5.0, (double)-9.0, (double)16.0, (double)10.0, (double)1.0), Block.box((double)1.0, (double)0.0, (double)-13.0, (double)16.0, (double)5.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        NORTH_OPEN_BOTH = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)10.0, (double)-4.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)5.0, (double)-9.0, (double)16.0, (double)10.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)-13.0, (double)16.0, (double)5.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_NONE = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)15.0, (double)10.0, (double)1.0, (double)20.0, (double)15.0, (double)15.0), Block.box((double)15.0, (double)5.0, (double)1.0, (double)25.0, (double)10.0, (double)15.0), Block.box((double)15.0, (double)0.0, (double)1.0, (double)29.0, (double)5.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)15.0, (double)10.0, (double)0.0, (double)20.0, (double)15.0, (double)15.0), Block.box((double)15.0, (double)5.0, (double)0.0, (double)25.0, (double)10.0, (double)15.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)29.0, (double)5.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)15.0, (double)10.0, (double)1.0, (double)20.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)5.0, (double)1.0, (double)25.0, (double)10.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)1.0, (double)29.0, (double)5.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_BOTH = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)15.0, (double)10.0, (double)0.0, (double)20.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)5.0, (double)0.0, (double)25.0, (double)10.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)29.0, (double)5.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_NONE = Stream.of(Stream.of(Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)1.0, (double)10.0, (double)15.0, (double)15.0, (double)15.0, (double)20.0), Block.box((double)1.0, (double)5.0, (double)15.0, (double)15.0, (double)10.0, (double)25.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)5.0, (double)29.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)1.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)1.0, (double)10.0, (double)15.0, (double)16.0, (double)15.0, (double)20.0), Block.box((double)1.0, (double)5.0, (double)15.0, (double)16.0, (double)10.0, (double)25.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)5.0, (double)29.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)10.0, (double)15.0, (double)15.0, (double)15.0, (double)20.0), Block.box((double)0.0, (double)5.0, (double)15.0, (double)15.0, (double)10.0, (double)25.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)5.0, (double)29.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_BOTH = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)0.0, (double)10.0, (double)15.0, (double)16.0, (double)15.0, (double)20.0), Block.box((double)0.0, (double)5.0, (double)15.0, (double)16.0, (double)10.0, (double)25.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)5.0, (double)29.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_NONE = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)-4.0, (double)10.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), Block.box((double)-9.0, (double)5.0, (double)1.0, (double)1.0, (double)10.0, (double)15.0), Block.box((double)-13.0, (double)0.0, (double)1.0, (double)1.0, (double)5.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_RIGHT = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)-4.0, (double)10.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)-9.0, (double)5.0, (double)1.0, (double)1.0, (double)10.0, (double)16.0), Block.box((double)-13.0, (double)0.0, (double)1.0, (double)1.0, (double)5.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_LEFT = Stream.of(Stream.of(Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)-4.0, (double)10.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0), Block.box((double)-9.0, (double)5.0, (double)0.0, (double)1.0, (double)10.0, (double)15.0), Block.box((double)-13.0, (double)0.0, (double)0.0, (double)1.0, (double)5.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_BOTH = Stream.of(Stream.of(Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)-4.0, (double)10.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)-9.0, (double)5.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0), Block.box((double)-13.0, (double)0.0, (double)0.0, (double)1.0, (double)5.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public static enum ConnectedState implements StringRepresentable
    {
        NONE,
        RIGHT,
        LEFT,
        BOTH;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

