/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.slidingWindow;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.tiestoettoet.create_train_parts.AllPartialModels;
import com.tiestoettoet.create_train_parts.CreateTrainParts;
import com.tiestoettoet.create_train_parts.content.decoration.SlidingWindowCTBehaviour;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlock;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlockEntity;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowMovementBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SlidingWindowRenderer
extends SafeBlockEntityRenderer<SlidingWindowBlockEntity> {
    protected void renderSafe(SlidingWindowBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.shouldRenderSpecial(be.getBlockState())) {
            return;
        }
        Level world = be.getLevel();
        if (world instanceof VirtualRenderWorld) {
            return;
        }
        float animValue = be.animation.getValue(partialTicks);
        BlockState blockState = be.getBlockState();
        BlockPos blockPos = be.getBlockPos();
        SlidingWindowRenderer.renderSlidingWindow(blockState, blockPos, world, world, animValue, buffer, ms, light, null);
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        Object object = context.temporaryData;
        if (!(object instanceof SlidingWindowMovementBehaviour.SlidingWindowAnimationData)) {
            return;
        }
        SlidingWindowMovementBehaviour.SlidingWindowAnimationData swad = (SlidingWindowMovementBehaviour.SlidingWindowAnimationData)object;
        float animVal = swad.animation.getValue(AnimationTickHolder.getPartialTicks((LevelAccessor)context.world));
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
        PoseStack ms = matrices.getModel();
        SlidingWindowRenderer.renderSlidingWindow(context.state, context.localPos, (Level)context.contraption.getContraptionWorld(), (Level)renderWorld, animVal, buffer, ms, light, matrices);
    }

    private static SlidingMotion computeSlidingMotion(SlidingWindowBlockEntity.SelectionMode mode, Direction facing, float exponentialValue) {
        Vec3 moveOffset;
        float movementUp;
        float movementMain;
        float animFirstQuarter = Mth.clamp((float)(exponentialValue / 0.25f), (float)0.0f, (float)1.0f);
        float animSecondQuarter = Mth.clamp((float)((exponentialValue - 0.25f) / 0.25f), (float)0.0f, (float)1.0f);
        float animThirdQuarter = Mth.clamp((float)((exponentialValue - 0.5f) / 0.25f), (float)0.0f, (float)1.0f);
        float animFourthQuarter = Mth.clamp((float)((exponentialValue - 0.75f) / 0.25f), (float)0.0f, (float)1.0f);
        if ((double)exponentialValue <= 0.25) {
            movementMain = 0.18125f * animFirstQuarter;
            movementUp = 0.1875f * animFirstQuarter;
        } else if ((double)exponentialValue <= 0.5) {
            movementMain = 0.18125f;
            movementUp = (3.0f + 4.0f * animSecondQuarter) / 16.0f;
        } else if ((double)exponentialValue <= 0.75) {
            movementMain = 0.18125f;
            movementUp = (7.0f + 4.0f * animThirdQuarter) / 16.0f;
        } else {
            movementMain = 0.18125f;
            movementUp = (11.0f + 4.0f * animFourthQuarter) / 16.0f;
        }
        Direction movementDirection = facing.getOpposite();
        return new SlidingMotion(moveOffset, switch (mode) {
            case SlidingWindowBlockEntity.SelectionMode.UP -> {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementMain);
                yield Vec3.atLowerCornerOf((Vec3i)Direction.UP.getNormal()).scale((double)movementUp);
            }
            case SlidingWindowBlockEntity.SelectionMode.DOWN -> {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementMain);
                yield Vec3.atLowerCornerOf((Vec3i)Direction.DOWN.getNormal()).scale((double)movementUp);
            }
            case SlidingWindowBlockEntity.SelectionMode.LEFT -> {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMain).add(Vec3.atLowerCornerOf((Vec3i)movementDirection.getCounterClockWise().getNormal()).scale((double)movementUp));
                yield Vec3.ZERO;
            }
            case SlidingWindowBlockEntity.SelectionMode.RIGHT -> {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMain).add(Vec3.atLowerCornerOf((Vec3i)movementDirection.getClockWise().getNormal()).scale((double)movementUp));
                yield Vec3.ZERO;
            }
            default -> {
                moveOffset = Vec3.ZERO;
                yield Vec3.ZERO;
            }
        });
    }

    private static Vec2 getCTUV(CTType dataType, ConnectedTextureBehaviour.CTContext context) {
        int textureIndex = dataType.getTextureIndex(context);
        float row = Math.floorDiv(textureIndex, 8);
        float column = textureIndex % 8;
        return new Vec2(column / 8.0f, row / 8.0f);
    }

    public static void renderSlidingWindow(BlockState state, BlockPos pos, Level world, Level renderWorld, float animValue, MultiBufferSource buffer, PoseStack ms, int light, ContraptionMatrices matrices) {
        if (!(state.getBlock() instanceof SlidingWindowBlock)) {
            return;
        }
        HashMap<Side, BlockState> blockStates = new HashMap<Side, BlockState>();
        blockStates.put(Side.RIGHT, world.getBlockState(pos.relative(((Direction)state.getValue((Property)SlidingWindowBlock.FACING)).getClockWise())));
        blockStates.put(Side.LEFT, world.getBlockState(pos.relative(((Direction)state.getValue((Property)SlidingWindowBlock.FACING)).getCounterClockWise())));
        blockStates.put(Side.UP, world.getBlockState(pos.relative(Direction.UP)));
        blockStates.put(Side.DOWN, world.getBlockState(pos.relative(Direction.DOWN)));
        SlidingWindowBlockEntity.SelectionMode mode = (SlidingWindowBlockEntity.SelectionMode)((Object)state.getValue(SlidingWindowBlock.MODE));
        HashMap<Side, Boolean> sidesActive = new HashMap<Side, Boolean>();
        for (Side side : Side.values()) {
            sidesActive.put(side, !(((BlockState)blockStates.get((Object)side)).getBlock() instanceof SlidingWindowBlock) || ((BlockState)blockStates.get((Object)side)).getValue((Property)SlidingWindowBlock.FACING) != state.getValue((Property)SlidingWindowBlock.FACING) || mode != ((BlockState)blockStates.get((Object)side)).getValue(SlidingWindowBlock.MODE));
        }
        Direction facing = (Direction)state.getValue((Property)SlidingWindowBlock.FACING);
        float rotationAngle = switch (facing) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        float exponentialValue = animValue * animValue;
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        ResourceLocation blockTexture = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        SlidingWindowTextureType textureType = SlidingWindowTextureType.fromBlockTexturePath(blockTexture.getPath());
        SlidingWindowCTBehaviour ctBehaviour = new SlidingWindowCTBehaviour(textureType.getSpriteShift());
        CTType dataType = ctBehaviour.getDataType((BlockAndTintGetter)renderWorld, pos, state, facing);
        SlidingMotion motion = SlidingWindowRenderer.computeSlidingMotion(mode, facing, exponentialValue);
        Vec3 moveOffset = motion.moveOffset();
        Vec3 upOffset = motion.upOffset();
        ResourceLocation resLocationMain = CreateTrainParts.asResource("sliding_windows/" + textureType.getType() + "_main");
        PartialModel modelMain = AllPartialModels.SLIDING_WINDOW.get(resLocationMain);
        SuperByteBuffer partialMain = CachedBuffers.partial((PartialModel)modelMain, (BlockState)state);
        ResourceLocation resLocationBack = CreateTrainParts.asResource("sliding_windows/" + textureType.getType() + "_back");
        PartialModel modelBack = AllPartialModels.SLIDING_WINDOW_BACK.get(resLocationBack);
        SuperByteBuffer particalBack = CachedBuffers.partial((PartialModel)modelBack, (BlockState)state);
        HashMap<Side, ResourceLocation> resLocations = new HashMap<Side, ResourceLocation>();
        for (Side side : Side.values()) {
            resLocations.put(side, CreateTrainParts.asResource("sliding_windows/" + textureType.getType() + "_" + side.toString()));
        }
        HashMap<Side, PartialModel> sideModels = new HashMap<Side, PartialModel>();
        sideModels.put(Side.UP, AllPartialModels.SLIDING_WINDOW_UP.get(resLocations.get((Object)Side.UP)));
        sideModels.put(Side.RIGHT, AllPartialModels.SLIDING_WINDOW_RIGHT.get(resLocations.get((Object)Side.RIGHT)));
        sideModels.put(Side.DOWN, AllPartialModels.SLIDING_WINDOW_DOWN.get(resLocations.get((Object)Side.DOWN)));
        sideModels.put(Side.LEFT, AllPartialModels.SLIDING_WINDOW_LEFT.get(resLocations.get((Object)Side.LEFT)));
        ArrayList<SuperByteBuffer> partialSides = new ArrayList<SuperByteBuffer>();
        for (Side side : Side.values()) {
            if (sidesActive.get((Object)side) == null || !((Boolean)sidesActive.get((Object)side)).booleanValue()) continue;
            partialSides.add(CachedBuffers.partial((PartialModel)((PartialModel)sideModels.get((Object)side)), (BlockState)state));
        }
        for (SuperByteBuffer partialSide : partialSides) {
            if (world instanceof ContraptionWorld) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partialSide.transform(ms)).translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(light).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
                continue;
            }
            ((SuperByteBuffer)((SuperByteBuffer)partialSide.translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(light).renderInto(ms, vb);
        }
        assert (dataType != null);
        ConnectedTextureBehaviour.CTContext ctContext = ctBehaviour.buildContext((BlockAndTintGetter)renderWorld, pos, state, facing.getOpposite(), dataType.getContextRequirement());
        Vec2 uv = SlidingWindowRenderer.getCTUV(dataType, ctContext);
        if (world instanceof ContraptionWorld) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partialMain.transform(ms)).translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)textureType.getSpriteShift(), uv.x, uv.y, 8).light(light).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
        } else {
            ((SuperByteBuffer)((SuperByteBuffer)partialMain.translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)textureType.getSpriteShift(), uv.x, uv.y, 8).light(light).renderInto(ms, vb);
        }
        ctContext = ctBehaviour.buildContext((BlockAndTintGetter)renderWorld, pos, state, facing, dataType.getContextRequirement());
        uv = SlidingWindowRenderer.getCTUV(dataType, ctContext);
        if (world instanceof ContraptionWorld) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)particalBack.transform(ms)).translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)textureType.getSpriteShift(), uv.x, uv.y, 8).light(light).useLevelLight((BlockAndTintGetter)world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb);
        } else {
            ((SuperByteBuffer)((SuperByteBuffer)particalBack.translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)textureType.getSpriteShift(), uv.x, uv.y, 8).light(light).renderInto(ms, vb);
        }
    }

    public record SlidingMotion(Vec3 moveOffset, Vec3 upOffset) {
    }

    static enum Side {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down");

        private final String name;

        private Side(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static enum SlidingWindowTextureType {
        GLASS("glass_sliding_window", () -> AllSpriteShifts.FRAMED_GLASS, "glass"),
        ANDESITE("andesite_sliding_window", () -> AllSpriteShifts.ANDESITE_CASING, "andesite"),
        BRASS("brass_sliding_window", () -> AllSpriteShifts.BRASS_CASING, "brass"),
        COPPER("copper_sliding_window", () -> AllSpriteShifts.COPPER_CASING, "copper"),
        TRAIN("train_sliding_window", () -> AllSpriteShifts.RAILWAY_CASING, "train");

        private final String textureKey;
        private final Supplier<CTSpriteShiftEntry> spriteShiftEntrySupplier;
        private final String type;
        private CTSpriteShiftEntry spriteShift;

        private SlidingWindowTextureType(String textureKey, Supplier<CTSpriteShiftEntry> spriteShiftSupplier, String type) {
            this.textureKey = textureKey;
            this.spriteShiftEntrySupplier = spriteShiftSupplier;
            this.type = type;
        }

        public CTSpriteShiftEntry getSpriteShift() {
            if (this.spriteShift == null) {
                this.spriteShift = this.spriteShiftEntrySupplier.get();
            }
            return this.spriteShift;
        }

        public String getType() {
            return this.type;
        }

        public static SlidingWindowTextureType fromBlockTexturePath(String path) {
            for (SlidingWindowTextureType slidingWindowTextureType : SlidingWindowTextureType.values()) {
                if (!path.contains(slidingWindowTextureType.textureKey)) continue;
                return slidingWindowTextureType;
            }
            return GLASS;
        }
    }
}

