/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.slidingWindow;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.decoration.slidingDoor.DoorControl;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlock;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlockEntity;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowMovementBehaviourRenderer;
import java.lang.ref.WeakReference;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SlidingWindowMovementBehaviour
implements MovementBehaviour {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public boolean mustTickWhileDisabled() {
        return true;
    }

    public void tick(MovementContext context) {
        SlidingWindowAnimationData swad;
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = SlidingWindowBlockEntity.isOpen(structureBlockInfo.state());
        if (!context.world.isClientSide()) {
            this.tickOpen(context, open);
        }
        if (!(context.temporaryData instanceof SlidingWindowAnimationData)) {
            swad = new SlidingWindowAnimationData();
            context.temporaryData = swad;
        } else {
            swad = (SlidingWindowAnimationData)context.temporaryData;
        }
        boolean wasSettled = swad.animation.settled();
        swad.animation.chase(open ? 1.0 : 0.0, (double)0.15f, LerpedFloat.Chaser.LINEAR);
        swad.animation.tickChaser();
        if (!wasSettled && swad.animation.settled() && !open) {
            context.world.playLocalSound(context.position.x, context.position.y, context.position.z, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.125f, 1.0f, false);
        }
    }

    protected void tickOpen(MovementContext context, boolean currentlyOpen) {
        boolean shouldOpen = this.shouldOpen(context);
        if (!this.shouldUpdate(context, shouldOpen)) {
            return;
        }
        if (currentlyOpen == shouldOpen) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.state().hasProperty((Property)SlidingWindowBlock.OPEN)) {
            return;
        }
        this.toggleWindow(pos, contraption, info);
        Direction facing = this.getWindowFacing(context);
        BlockPos inWorldWindow = BlockPos.containing((Position)context.position).relative(facing);
        BlockState inWorldWindowState = context.world.getBlockState(inWorldWindow);
        Block block = inWorldWindowState.getBlock();
        if (block instanceof SlidingWindowBlock) {
            SlidingWindowBlock sb = (SlidingWindowBlock)block;
            if (inWorldWindowState.hasProperty((Property)SlidingWindowBlock.OPEN) && inWorldWindowState.hasProperty((Property)HorizontalDirectionalBlock.FACING) && inWorldWindowState.getOptionalValue((Property)HorizontalDirectionalBlock.FACING).orElse(Direction.UP).getAxis() == facing.getAxis()) {
                sb.setOpen(null, context.world, inWorldWindowState, inWorldWindow, false);
            }
        }
    }

    private void toggleWindow(BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState = (BlockState)info.state().cycle((Property)SlidingWindowBlock.OPEN);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
        info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos.relative((Direction)info.state().getValue((Property)HorizontalDirectionalBlock.FACING)));
        if (info != null && info.state().hasProperty((Property)SlidingWindowBlock.OPEN)) {
            newState = (BlockState)info.state().cycle((Property)SlidingWindowBlock.OPEN);
            contraption.entity.setBlock(pos.relative((Direction)info.state().getValue((Property)HorizontalDirectionalBlock.FACING)), new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
        }
        contraption.invalidateColliders();
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldOpen) {
        if (context.firstMovement && shouldOpen) {
            return false;
        }
        if (!context.data.contains("Open")) {
            context.data.putBoolean("Open", shouldOpen);
            return true;
        }
        boolean wasOpen = context.data.getBoolean("Open");
        context.data.putBoolean("Open", shouldOpen);
        return wasOpen != shouldOpen;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean shouldOpen(MovementContext context) {
        if (context.disabled) {
            return false;
        }
        state = context.state;
        mode = (SlidingWindowBlockEntity.SelectionMode)state.getValue(SlidingWindowBlock.MODE);
        if (mode == SlidingWindowBlockEntity.SelectionMode.DOWN || mode == SlidingWindowBlockEntity.SelectionMode.UP) {
            return false;
        }
        contraption = context.contraption;
        if (context.motion.length() < 0.0078125 && !contraption.entity.isStalled()) ** GOTO lbl-1000
        if (contraption instanceof ElevatorContraption) {
            ec = (ElevatorContraption)contraption;
            ** if (!ec.arrived) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl16
        }
lbl-1000:
        // 2 sources

        {
            v0 = canOpen = false;
        }
lbl16:
        // 2 sources

        if (!canOpen) {
            context.temporaryData = null;
            return false;
        }
        var8_7 = context.temporaryData;
        if (var8_7 instanceof WeakReference && (var8_7 = (wr = (WeakReference)var8_7).get()) instanceof DoorControlBehaviour) {
            dcb = (DoorControlBehaviour)var8_7;
            if (dcb.blockEntity != null && !dcb.blockEntity.isRemoved()) {
                return this.shouldOpenAt(dcb, context);
            }
        }
        context.temporaryData = null;
        doorControls = null;
        var8_7 = context.contraption.entity;
        if (var8_7 instanceof CarriageContraptionEntity) {
            cce = (CarriageContraptionEntity)var8_7;
            doorControls = this.getTrainStationSlideControl(cce, context);
        }
        if (contraption instanceof ElevatorContraption) {
            ec = (ElevatorContraption)contraption;
            doorControls = this.getElevatorDoorControl(ec, context);
        }
        if (doorControls == null) {
            return false;
        }
        context.temporaryData = new WeakReference<DoorControlBehaviour>(doorControls);
        return this.shouldOpenAt(doorControls, context);
    }

    protected boolean shouldOpenAt(DoorControlBehaviour controller, MovementContext context) {
        if (controller.mode == DoorControl.ALL) {
            return true;
        }
        if (controller.mode == DoorControl.NONE) {
            return false;
        }
        return controller.mode.matches(this.getWindowFacing(context));
    }

    protected DoorControlBehaviour getElevatorDoorControl(ElevatorContraption ec, MovementContext context) {
        Integer currentTargetY = ec.getCurrentTargetY(context.world);
        if (currentTargetY == null) {
            return null;
        }
        ElevatorColumn.ColumnCoords ColumnCoords2 = ec.getGlobalColumn();
        if (ColumnCoords2 == null) {
            return null;
        }
        ElevatorColumn elevatorColumn = ElevatorColumn.get((LevelAccessor)context.world, (ElevatorColumn.ColumnCoords)ColumnCoords2);
        if (elevatorColumn == null) {
            return null;
        }
        return (DoorControlBehaviour)BlockEntityBehaviour.get((BlockGetter)context.world, (BlockPos)elevatorColumn.contactAt(currentTargetY.intValue()), (BehaviourType)DoorControlBehaviour.TYPE);
    }

    protected DoorControlBehaviour getTrainStationSlideControl(CarriageContraptionEntity cce, MovementContext context) {
        Carriage carriage = cce.getCarriage();
        if (carriage == null || carriage.train == null) {
            return null;
        }
        GlobalStation currentStation = carriage.train.getCurrentStation();
        if (currentStation == null) {
            return null;
        }
        BlockPos stationPos = currentStation.getBlockEntityPos();
        ResourceKey stationDim = currentStation.getBlockEntityDimension();
        MinecraftServer server = context.world.getServer();
        if (server == null) {
            return null;
        }
        ServerLevel stationLevel = server.getLevel(stationDim);
        if (stationLevel == null || !stationLevel.isLoaded(stationPos)) {
            return null;
        }
        return (DoorControlBehaviour)BlockEntityBehaviour.get((BlockGetter)stationLevel, (BlockPos)stationPos, (BehaviourType)DoorControlBehaviour.TYPE);
    }

    protected Direction getWindowFacing(MovementContext context) {
        Direction stateFacing = (Direction)context.state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Direction originalFacing = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)stateFacing.getAxis());
        Vec3 centerOfContraption = context.contraption.bounds.getCenter();
        Vec3 diff = Vec3.atCenterOf((Vec3i)context.localPos).add(Vec3.atLowerCornerOf((Vec3i)stateFacing.getNormal()).scale((double)-0.45f)).subtract(centerOfContraption);
        if (originalFacing.getAxis().choose(diff.x, diff.y, diff.z) < 0.0) {
            originalFacing = originalFacing.getOpposite();
        }
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)originalFacing.getNormal());
        directionVec = (Vec3)context.rotation.apply(directionVec);
        return Direction.getNearest((double)directionVec.x, (double)directionVec.y, (double)directionVec.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        SlidingWindowMovementBehaviourRenderer.renderInContraption(context, renderWorld, matrices, buffer);
    }

    static class SlidingWindowAnimationData {
        LerpedFloat animation = LerpedFloat.linear();

        SlidingWindowAnimationData() {
        }
    }
}

