/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.slidingWindow;

import com.simibubi.create.AllKeys;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlock;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowModeSlot;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowRangeDisplay;
import com.tiestoettoet.create_train_parts.foundation.blockEntity.behaviour.scrollValue.BulkScrollOptionBehaviour;
import com.tiestoettoet.create_train_parts.foundation.gui.AllIcons;
import com.tiestoettoet.create_train_parts.foundation.utility.CreateTrainPartsLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SlidingWindowBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    LerpedFloat animation;
    int bridgeTicks;
    boolean deferUpdate;
    Map<String, BlockState> neighborStates = new HashMap<String, BlockState>();
    public ScrollOptionBehaviour<SelectionMode> selectionMode;
    boolean connectedLeft;
    boolean connectedRight;
    ScrollValueBehaviour range;
    public int currentlySelectedRange;
    protected AssemblyException lastException;
    Object openObj = null;
    private boolean manuallyClosed = false;

    public SlidingWindowBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.animation = LerpedFloat.linear().startWithValue(SlidingWindowBlockEntity.isOpen(this.getBlockState()) ? 1.0 : 0.0);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.lastException = AssemblyException.read((CompoundTag)tag, (HolderLookup.Provider)registries);
        super.read(tag, registries, clientPacket);
        this.invalidateRenderBoundingBox();
        if (tag.contains("ForceOpen")) {
            this.openObj = tag.getBoolean("ForceOpen");
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.selectionMode = new SlidingWindowOptionBehaviour<SelectionMode>(SelectionMode.class, (Component)CreateTrainPartsLang.translateDirect("sliding_window.mode", new Object[0]), this, (ValueBoxTransform)new SlidingWindowModeSlot(), be -> ((SlidingWindowBlockEntity)((Object)be)).collectSlidingWindowGroup());
        behaviours.add((BlockEntityBehaviour)this.selectionMode);
        this.selectionMode.onlyActiveWhen(this::isVisible);
        this.selectionMode.requiresWrench();
        this.selectionMode.withCallback(settings -> {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> SlidingWindowRangeDisplay.display(this));
            BlockState blockState = this.getBlockState();
            SelectionMode selectedMode = SelectionMode.values()[settings];
            blockState = (BlockState)blockState.setValue(SlidingWindowBlock.MODE, (Comparable)((Object)selectedMode));
            this.level.setBlock(this.worldPosition, blockState, 3);
            for (boolean side : Iterate.trueAndFalse) {
                if (this.isConnected(side)) continue;
            }
        });
    }

    public boolean isVisible() {
        return (Boolean)this.getBlockState().getValue((Property)SlidingWindowBlock.VISIBLE);
    }

    public boolean isConnected(boolean leftSide) {
        return leftSide ? this.connectedLeft : this.connectedRight;
    }

    public SelectionMode getMode() {
        return (SelectionMode)this.selectionMode.get();
    }

    public int getRange() {
        return this.range.getValue();
    }

    public List<BlockPos> getIncludedBlockPositions(Direction forcedMovement, boolean visualize) {
        if (!(this.getBlockState().getBlock() instanceof SlidingWindowBlock)) {
            return Collections.emptyList();
        }
        return this.getIncludedBlockPositionsLinear(forcedMovement, visualize);
    }

    public List<SlidingWindowBlockEntity> collectSlidingWindowGroup() {
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        ArrayList<SlidingWindowBlockEntity> collected = new ArrayList<SlidingWindowBlockEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        frontier.add(this.worldPosition);
        while (!frontier.isEmpty()) {
            BlockPos current = (BlockPos)frontier.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockEntity blockEntity = this.level.getBlockEntity(current);
            if (!(blockEntity instanceof SlidingWindowBlockEntity)) continue;
            SlidingWindowBlockEntity slidingWindow = (SlidingWindowBlockEntity)blockEntity;
            collected.add(slidingWindow);
            visited.add(current);
            slidingWindow.addAttachedSlidingWindows(frontier, visited);
        }
        return collected;
    }

    public boolean addAttachedSlidingWindows(Queue<BlockPos> frontier, Set<BlockPos> visited) {
        BlockState state = this.getBlockState();
        Direction.Axis axis = ((Direction)state.getValue((Property)SlidingWindowBlock.FACING)).getAxis();
        for (Direction direction : Iterate.directions) {
            BlockState neighbourState;
            BlockPos currentPos = this.worldPosition.relative(direction);
            if (visited.contains(currentPos) || !this.level.isLoaded(currentPos) || !AllBlocks.GLASS_SLIDING_WINDOW.has(neighbourState = this.level.getBlockState(currentPos)) && !AllBlocks.ANDESITE_SLIDING_WINDOW.has(neighbourState) && !AllBlocks.BRASS_SLIDING_WINDOW.has(neighbourState) && !AllBlocks.COPPER_SLIDING_WINDOW.has(neighbourState) && !AllBlocks.TRAIN_SLIDING_WINDOW.has(neighbourState) || !SlidingWindowBlock.sameKind(state, neighbourState)) continue;
            if (!visited.contains(currentPos)) {
                frontier.add(currentPos);
            }
            if (((Direction)neighbourState.getValue((Property)SlidingWindowBlock.FACING)).getAxis() != axis) continue;
            frontier.add(currentPos);
        }
        return true;
    }

    public void tick() {
        boolean open;
        if (this.deferUpdate && !this.level.isClientSide()) {
            this.deferUpdate = false;
            BlockState blockState = this.getBlockState();
            blockState.handleNeighborChanged(this.level, this.worldPosition, Blocks.AIR, this.worldPosition, false);
        }
        super.tick();
        BlockState block = this.getBlockState();
        SlidingWindowBlock slidingWindowBlock = (SlidingWindowBlock)block.getBlock();
        boolean bl = open = this.openObj instanceof Boolean ? (Boolean)this.openObj : SlidingWindowBlockEntity.isOpen(this.getBlockState());
        if (open != SlidingWindowBlockEntity.isOpen(this.getBlockState())) {
            slidingWindowBlock.toggle(block, this.level, this.worldPosition, null, open);
        }
        boolean wasSettled = this.animation.settled();
        this.animation.chase(open ? 1.0 : 0.0, (double)0.15f, LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        if (this.level.isClientSide()) {
            if (this.bridgeTicks < 2 && open) {
                ++this.bridgeTicks;
            } else if (this.bridgeTicks > 0 && !open && this.isVisible(this.getBlockState())) {
                --this.bridgeTicks;
            }
            return;
        }
        if (!open && !wasSettled && this.animation.settled() && !this.isVisible(this.getBlockState())) {
            this.showBlockModel();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(1.0);
    }

    protected boolean isVisible(BlockState state) {
        return state.getOptionalValue((Property)SlidingWindowBlock.VISIBLE).orElse(true);
    }

    protected boolean shouldRenderSpecial(BlockState state) {
        return !this.isVisible(state) || this.bridgeTicks != 0;
    }

    protected void showBlockModel() {
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SlidingWindowBlock.VISIBLE, (Comparable)Boolean.valueOf(true)), 3);
        this.level.playSound(null, this.worldPosition, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public void setMode(SelectionMode mode) {
        if (mode != null) {
            this.selectionMode.setValue(mode.ordinal());
        }
    }

    public boolean isManuallyClosed() {
        return this.manuallyClosed;
    }

    public void setManuallyClosed(boolean manuallyClosed) {
        this.manuallyClosed = manuallyClosed;
    }

    public static boolean isOpen(BlockState state) {
        return state.getOptionalValue((Property)SlidingWindowBlock.OPEN).orElse(false);
    }

    private List<BlockPos> getIncludedBlockPositionsLinear(Direction forcedMovement, boolean visualize) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockState state = this.getBlockState();
        SlidingWindowBlock block = (SlidingWindowBlock)state.getBlock();
        Direction.Axis axis = ((Direction)state.getValue((Property)SlidingWindowBlock.FACING)).getAxis();
        Direction facing = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        int chassisRange = visualize ? this.currentlySelectedRange : this.getRange();
        block0: for (int offset : new int[]{1, -1}) {
            BlockPos current;
            BlockState currentState;
            if (offset == -1) {
                facing = facing.getOpposite();
            }
            boolean sticky = true;
            for (int i = 1; i <= chassisRange && BlockMovementChecks.isMovementNecessary((BlockState)(currentState = this.level.getBlockState(current = this.worldPosition.relative(facing, i))), (Level)this.level, (BlockPos)current) && !BlockMovementChecks.isBrittle((BlockState)currentState); ++i) {
                positions.add(current);
                if (BlockMovementChecks.isNotSupportive((BlockState)currentState, (Direction)facing)) continue block0;
            }
        }
        return positions;
    }

    public class SlidingWindowOptionBehaviour<E extends Enum<E>>
    extends BulkScrollOptionBehaviour<E> {
        Function<SmartBlockEntity, List<? extends SmartBlockEntity>> groupGetter;
        private E[] options;

        public SlidingWindowOptionBehaviour(Class<E> enum_, Component label, SmartBlockEntity be, ValueBoxTransform slot, Function<SmartBlockEntity, List<? extends SmartBlockEntity>> groupGetter) {
            super(enum_, label, be, slot, groupGetter);
            this.groupGetter = groupGetter;
        }

        @Override
        public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlDown) {
            if (!ctrlDown) {
                super.setValueSettings(player, valueSetting, ctrlDown);
                return;
            }
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            for (SmartBlockEntity be : this.getBulk()) {
                if (!(be instanceof SlidingWindowBlockEntity)) continue;
                SlidingWindowBlockEntity cbe = (SlidingWindowBlockEntity)be;
                if (cbe.selectionMode == null) continue;
                cbe.selectionMode.setValue(valueSetting.value());
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void newSettingHovered(ValueSettingsBehaviour.ValueSettings valueSetting) {
            if (!((SlidingWindowBlockEntity)SlidingWindowBlockEntity.this).level.isClientSide) {
                return;
            }
            if (!AllKeys.ctrlDown()) {
                SlidingWindowBlockEntity.this.currentlySelectedRange = valueSetting.value() + 1;
            } else {
                for (SmartBlockEntity be : this.getBulk()) {
                    if (!(be instanceof SlidingWindowBlockEntity)) continue;
                    SlidingWindowBlockEntity cbe = (SlidingWindowBlockEntity)be;
                    cbe.currentlySelectedRange = valueSetting.value() + 1;
                }
            }
            SlidingWindowRangeDisplay.display(SlidingWindowBlockEntity.this);
        }

        @Override
        public List<? extends SmartBlockEntity> getBulk() {
            return this.groupGetter.apply(this.blockEntity);
        }
    }

    public static enum SelectionMode implements INamedIconOptions,
    StringRepresentable
    {
        UP(AllIcons.I_SLIDING_WINDOW_UP),
        RIGHT(AllIcons.I_SLIDING_WINDOW_RIGHT),
        DOWN(AllIcons.I_SLIDING_WINDOW_DOWN),
        LEFT(AllIcons.I_SLIDING_WINDOW_LEFT);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "window.mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

