/*
 * Decompiled with CFR 0.152.
 */
package com.jopgood.cfwinfo.common.data;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class TankDataManager {
    public static boolean canItemStoreFuel(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return customData.copyTag().contains("tagFuel");
    }

    public static boolean canItemStoreWater(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return customData.copyTag().contains("tagWater");
    }

    public static boolean isHoldingFuelCapableItem(Player player) {
        ItemStack tool = player.getMainHandItem();
        return TankDataManager.canItemStoreFuel(tool);
    }

    public static boolean isHoldingWaterCapableItem(Player player) {
        ItemStack tool = player.getMainHandItem();
        return TankDataManager.canItemStoreFuel(tool);
    }

    public static boolean isWearingFuelCapableItem(Player player) {
        ItemStack chestplate = player.getInventory().getArmor(2);
        return TankDataManager.canItemStoreFuel(chestplate);
    }

    public static boolean isWearingWaterCapableItem(Player player) {
        ItemStack chestplate = player.getInventory().getArmor(2);
        return TankDataManager.canItemStoreWater(chestplate);
    }

    public static double getFuelLevel(ItemStack itemStack) {
        int tagFuel = 0;
        tagFuel = (int)((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel");
        return tagFuel;
    }

    public static double getWaterLevel(ItemStack itemStack) {
        int tagFuel = 0;
        tagFuel = (int)((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater");
        return tagFuel;
    }
}

