/*
 * Decompiled with CFR 0.152.
 */
package com.jopgood.cfwinfo.client.gui;

import com.jopgood.cfwinfo.client.gui.PositionedTooltipRenderer;
import com.jopgood.cfwinfo.client.gui.TankGuiHelper;
import com.jopgood.cfwinfo.common.config.CommonConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.List;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TankTooltipOverlay
implements LayeredDraw.Layer {
    private static int hoverTicks = 0;
    private static boolean wasRenderEnabled = false;

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        boolean renderEnabled = CommonConfig.isInfoEnabled();
        boolean simpleEnabled = CommonConfig.isSimplifiedEnabled();
        boolean wearingGoggles = GogglesItem.isWearingGoggles((Player)player);
        boolean wearingTank = TankGuiHelper.canDisplayTankInfo();
        if (!renderEnabled || simpleEnabled || !wearingGoggles) {
            wasRenderEnabled = false;
            return;
        }
        if (!wearingTank) {
            wasRenderEnabled = false;
            return;
        }
        if (!wasRenderEnabled) {
            hoverTicks = 0;
        }
        wasRenderEnabled = true;
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(false);
        this.renderDetailedTooltip(graphics, partialTicks, width, height, (Player)player);
    }

    private void renderDetailedTooltip(GuiGraphics graphics, float partialTicks, int width, int height, Player player) {
        int posX;
        CClient cfg = AllConfigs.client();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        ++hoverTicks;
        List<Component> tooltip = TankGuiHelper.generateTooltipWithSpacing(player);
        Minecraft mc = Minecraft.getInstance();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        Boolean bl = (Boolean)cfg.overlayCustomColor.get();
        Color tooltipBackground = new Color(-267386864, true);
        Color colorBackground = bl != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : tooltipBackground.scaleAlpha(85.0f);
        Color colorBorderTop = bl != false ? new Color(((Integer)cfg.overlayBorderColorTop.get()).intValue()) : new Color(0x505000FF, true);
        Color colorBorderBot = bl != false ? new Color(((Integer)cfg.overlayBorderColorBot.get()).intValue()) : new Color(1344798847, true);
        float opacityMultiplier = (float)CommonConfig.getOverlayOpacity() / 100.0f;
        colorBackground.scaleAlpha(opacityMultiplier);
        colorBorderTop.scaleAlpha(opacityMultiplier);
        colorBorderBot.scaleAlpha(opacityMultiplier);
        int padding = 20;
        int posY = switch (CommonConfig.getOverlayPosition()) {
            case CommonConfig.OverlayPosition.TOP_RIGHT -> {
                posX = width - tooltipTextWidth - padding;
                yield padding;
            }
            case CommonConfig.OverlayPosition.BOTTOM_LEFT -> {
                posX = padding;
                yield height - tooltipHeight - padding;
            }
            case CommonConfig.OverlayPosition.BOTTOM_RIGHT -> {
                posX = width - tooltipTextWidth - padding;
                yield height - tooltipHeight - padding;
            }
            default -> {
                posX = padding;
                yield padding;
            }
        };
        float fadeSpeed = 24.0f;
        float fade = Mth.clamp((float)(((float)hoverTicks + partialTicks) / fadeSpeed), (float)0.0f, (float)1.0f);
        if (fade < 1.0f) {
            poseStack.translate(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        PositionedTooltipRenderer.renderTooltip(graphics, tooltip, posX, posY, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), 6, 6, 3, 12);
        ItemStack item = AllItems.GOGGLES.asStack();
        GuiGameElement.of((ItemStack)item).at((float)(posX - 2), (float)(posY - 4), 450.0f).render(graphics);
        poseStack.popPose();
    }
}

