/*
 * Decompiled with CFR 0.152.
 */
package com.jopgood.cfwinfo.client.gui;

import com.jopgood.cfwinfo.common.data.TankDataManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TankGuiHelper {
    public static List<Component> generateTankTooltip(Player player) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)(TankGuiHelper.canDisplayTankInfo() ? Component.literal((String)"Tank Monitor:").withStyle(ChatFormatting.WHITE) : Component.literal((String)"No Tank Equipment").withStyle(ChatFormatting.GRAY)));
        if (!TankGuiHelper.canDisplayTankInfo()) {
            return tooltip;
        }
        ItemStack chestItem = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack toolItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        String chestLabel = chestItem.isEmpty() ? "On Chest" : chestItem.getHoverName().getString();
        TankGuiHelper.addItemTooltip(tooltip, chestLabel, chestItem, TankDataManager.isWearingWaterCapableItem(player), TankDataManager.isWearingFuelCapableItem(player), player);
        TankGuiHelper.addItemTooltip(tooltip, toolItem.isEmpty() ? "In-Hand" : toolItem.getHoverName().getString(), player.getItemInHand(InteractionHand.MAIN_HAND), TankDataManager.isHoldingWaterCapableItem(player), TankDataManager.isHoldingFuelCapableItem(player), player);
        return tooltip;
    }

    public static List<Component> generateTooltipWithSpacing(Player player) {
        List<Component> baseTooltip = TankGuiHelper.generateTankTooltip(player);
        ArrayList<Component> spacedTooltip = new ArrayList<Component>();
        MutableComponent spacing = Component.literal((String)"    ");
        for (Component component : baseTooltip) {
            spacedTooltip.add((Component)spacing.plainCopy().append(component));
        }
        return spacedTooltip;
    }

    private static void addItemTooltip(List<Component> tooltip, String label, ItemStack item, boolean hasWater, boolean hasFuel, Player player) {
        if (item == null || !hasWater && !hasFuel) {
            return;
        }
        tooltip.add((Component)Component.literal((String)label).withStyle(ChatFormatting.WHITE));
        if (hasWater) {
            MutableComponent waterText = Component.literal((String)"  Water: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)TankGuiHelper.formatLevel(TankDataManager.getWaterLevel(item))).withStyle(ChatFormatting.AQUA));
            tooltip.add((Component)waterText);
        }
        if (hasFuel) {
            MutableComponent fuelText = Component.literal((String)"  Fuel: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)TankGuiHelper.formatLevel(TankDataManager.getFuelLevel(item))).withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)fuelText);
        }
    }

    private static String formatLevel(double level) {
        return level == (double)((int)level) ? String.valueOf((int)level) : String.format("%.1f", level);
    }

    public static boolean canDisplayTankInfo() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        return TankDataManager.isWearingFuelCapableItem((Player)player) || TankDataManager.isWearingWaterCapableItem((Player)player) || TankDataManager.isHoldingWaterCapableItem((Player)player) || TankDataManager.isHoldingFuelCapableItem((Player)player);
    }
}

