/*
 * Decompiled with CFR 0.152.
 */
package toni.distractionfreerecipes.foundation;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.FastColor;
import toni.distractionfreerecipes.foundation.config.AllConfigs;

public class GuiHelpers {
    public static Rect2i searchBounds = new Rect2i(0, 0, 0, 0);

    public static void drawShowRecipesButton(GuiGraphics guiGraphics) {
        Rect2i toggle = GuiHelpers.getShowRecipesBounds();
        Font font = Minecraft.getInstance().font;
        if (((Boolean)AllConfigs.client().showText.get()).booleanValue()) {
            Rect2i bound = searchBounds;
            String str = "Search to View Recipes";
            int fontWidth = font.width(str);
            guiGraphics.drawString(font, str, bound.getX() + (bound.getWidth() - fontWidth) / 2, toggle.getY() - 20, FastColor.ARGB32.color((int)128, (int)200, (int)200, (int)200));
        }
        if (((Boolean)AllConfigs.client().showToggleButton.get()).booleanValue()) {
            guiGraphics.fill(toggle.getX(), toggle.getY(), toggle.getX() + toggle.getWidth(), toggle.getY() + toggle.getHeight(), FastColor.ARGB32.color((int)50, (int)0, (int)0, (int)0));
            String toggleStr = "Show Recipes";
            int toggleFontWidth = font.width(toggleStr);
            guiGraphics.drawString(font, toggleStr, toggle.getX() + (toggle.getWidth() - toggleFontWidth) / 2, toggle.getY() + 4, FastColor.ARGB32.color((int)128, (int)200, (int)200, (int)200));
        }
    }

    public static Rect2i getShowRecipesBounds() {
        Rect2i bound = searchBounds;
        int x = bound.getX() + bound.getWidth() / 2;
        int y = bound.getY() + bound.getHeight() / 2;
        int width = bound.getWidth();
        return new Rect2i(x - Math.min(50, (int)((float)width * 0.25f)), Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 + 20, Math.min(100, (int)((float)width * 0.5f)), 15);
    }

    public static Rect2i getHideRecipesBounds() {
        Rect2i bound = searchBounds;
        int x = bound.getX() + bound.getWidth() / 2;
        int y = bound.getY() + bound.getHeight();
        int width = bound.getWidth();
        int offset = Math.max(0, (int)((float)width * 0.5f) - 100);
        return new Rect2i((int)((float)x - (float)width * 1.0f - 5.0f + (float)offset), 8, Math.min(100, (int)((float)width * 0.5f)), 15);
    }

    public static void drawHideRecipesButton(GuiGraphics guiGraphics) {
        Rect2i toggle = GuiHelpers.getHideRecipesBounds();
        Font font = Minecraft.getInstance().font;
        guiGraphics.fill(toggle.getX(), toggle.getY(), toggle.getX() + toggle.getWidth(), toggle.getY() + toggle.getHeight(), FastColor.ARGB32.color((int)50, (int)0, (int)0, (int)0));
        String toggleStr = "Hide Recipes";
        int toggleFontWidth = font.width(toggleStr);
        guiGraphics.drawString(font, toggleStr, toggle.getX() + (toggle.getWidth() - toggleFontWidth) / 2, toggle.getY() + 4, FastColor.ARGB32.color((int)128, (int)200, (int)200, (int)200));
    }

    public static boolean tryClickShowRecipesButton(int lastMouseX, int lastMouseY) {
        if (!((Boolean)AllConfigs.client().showToggleButton.get()).booleanValue()) {
            return false;
        }
        Rect2i bound = GuiHelpers.getShowRecipesBounds();
        if (bound.contains(lastMouseX, lastMouseY)) {
            AllConfigs.client().enabled.set((Object)false);
            return true;
        }
        return false;
    }

    public static boolean tryClickHideRecipesButton(int lastMouseX, int lastMouseY) {
        if (!((Boolean)AllConfigs.client().showToggleButton.get()).booleanValue()) {
            return false;
        }
        Rect2i bound = GuiHelpers.getHideRecipesBounds();
        if (bound.contains(lastMouseX, lastMouseY)) {
            AllConfigs.client().enabled.set((Object)true);
            return true;
        }
        return false;
    }
}

