/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.ponder;

import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;

public class CNPonderReactor {
    private static final BlockPos CONTROLLER = new BlockPos(4, 4, 6);
    private static final BlockPos OUTPUT = new BlockPos(4, 1, 6);
    private static final BlockPos INPUT = new BlockPos(4, 4, 2);

    public static void init(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("reactor", "Construction of the reactor");
        scene.configureBasePlate(0, 0, 9);
        scene.showBasePlate();
        for (int y = 1; y < 8; ++y) {
            scene.overlay().showText(10).text("Floor " + y).attachKeyFrame().placeNearTarget();
            for (int x = 1; x < 7; ++x) {
                for (int z = 1; z < 7; ++z) {
                    scene.world().showSection(util.select().position(x, y, z), Direction.NORTH);
                    scene.idle(5);
                    if (x == 5 && z == 5 && y == 1) {
                        scene.rotateCameraY(180.0f);
                    }
                    if (x == INPUT.getX() && y == INPUT.getY() && z == INPUT.getZ()) {
                        scene.rotateCameraY(180.0f);
                        scene.overlay().showText(90).text("Reactor Input: A block that stores uranium and graphite rods to operate the reactor.").pointAt(util.vector().blockSurface(INPUT, Direction.UP)).attachKeyFrame().placeNearTarget();
                        scene.idle(120);
                        scene.rotateCameraY(180.0f);
                    }
                    if (x == OUTPUT.getX() && y == OUTPUT.getY() && z == OUTPUT.getZ()) {
                        scene.overlay().showText(90).text("Reactor Output: This is the block that outputs the energy (SU) generated by the reactor.").pointAt(util.vector().blockSurface(OUTPUT, Direction.UP)).attachKeyFrame().placeNearTarget();
                        scene.idle(120);
                    }
                    if (x != CONTROLLER.getX() || y != CONTROLLER.getY() || z != CONTROLLER.getZ()) continue;
                    scene.overlay().showText(90).text("Reactor Controller: The most important block to operate the reactor; it handles all the calculations needed to generate power.").pointAt(util.vector().blockSurface(CONTROLLER, Direction.DOWN)).attachKeyFrame().placeNearTarget();
                    scene.idle(120);
                }
            }
        }
    }

    public static void enable(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("reactor_blueprint", "Controller Activation");
        scene.configureBasePlate(0, 0, 9);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.showBasePlate();
        scene.rotateCameraY(260.0f);
        for (int y = 1; y < 8; ++y) {
            for (int x = 1; x < 7; ++x) {
                for (int z = 1; z < 7; ++z) {
                    scene.world().showSection(util.select().position(x, y, z), Direction.NORTH);
                }
            }
        }
        scene.idle(30);
        scene.overlay().showText(90).text("Reactor Blueprint: the most important element; it allows the reactor to be configured according to specific models.");
        Vec3 topSide = util.vector().blockSurface(CONTROLLER, Direction.EAST);
        scene.overlay().showControls(topSide, Pointing.UP, 90).withItem(CNItems.REACTOR_BLUEPRINT.asStack()).rightClick();
        scene.world().modifyBlock(CONTROLLER, s -> (BlockState)s.setValue((Property)ReactorControllerBlock.ASSEMBLED, (Comparable)Boolean.valueOf(true)), true);
    }
}

