/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import malte0811.ferritecore.impl.Deduplicator;
import malte0811.ferritecore.util.PredicateHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class KeyValueConditionImpl {
    private static final Map<KeyValuePair, Predicate<BlockState>> STATE_HAS_PROPERTY_CACHE = new ConcurrentHashMap<KeyValuePair, Predicate<BlockState>>();

    public static Predicate<BlockState> getPredicate(StateDefinition<Block, BlockState> stateContainer, String key, String value, Splitter splitter) {
        Predicate<BlockState> isMatchedState;
        List matchedStates;
        boolean invert;
        Property property = stateContainer.getProperty(key);
        if (property == null) {
            throw new RuntimeException(String.format("Unknown property '%s' on '%s'", key, ((Block)stateContainer.getOwner()).toString()));
        }
        String valueNoInvert = value;
        boolean bl = invert = !valueNoInvert.isEmpty() && valueNoInvert.charAt(0) == '!';
        if (invert) {
            valueNoInvert = valueNoInvert.substring(1);
        }
        if ((matchedStates = splitter.splitToList((CharSequence)valueNoInvert)).isEmpty()) {
            throw new RuntimeException(String.format("Empty value '%s' for property '%s' on '%s'", value, key, ((Block)stateContainer.getOwner()).toString()));
        }
        if (matchedStates.size() == 1) {
            isMatchedState = KeyValueConditionImpl.getBlockStatePredicate(stateContainer, property, valueNoInvert, key, value);
        } else {
            List subPredicates = matchedStates.stream().map(subValue -> KeyValueConditionImpl.getBlockStatePredicate(stateContainer, property, subValue, key, value)).collect(Collectors.toCollection(ArrayList::new));
            PredicateHelper.canonize(subPredicates);
            isMatchedState = Deduplicator.or(subPredicates);
        }
        return invert ? isMatchedState.negate() : isMatchedState;
    }

    private static <T extends Comparable<T>> Predicate<BlockState> getBlockStatePredicate(StateDefinition<Block, BlockState> container, Property<T> property, String subValue, String key, String value) {
        Optional optional = property.getValue(subValue);
        if (optional.isEmpty()) {
            throw new RuntimeException(String.format("Unknown value '%s' for property '%s' on '%s' in '%s'", subValue, key, ((Block)container.getOwner()).toString(), value));
        }
        Comparable unwrapped = (Comparable)optional.get();
        return STATE_HAS_PROPERTY_CACHE.computeIfAbsent(new KeyValuePair(property, unwrapped), pair -> {
            Comparable<?> valueInt = pair.value();
            Property<?> propInt = pair.key();
            return state -> state.getValue(propInt).equals(valueInt);
        });
    }

    private record KeyValuePair(Property<?> key, Comparable<?> value) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValuePair that = (KeyValuePair)o;
            return this.key == that.key && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return 31 * System.identityHashCode(this.key) + Objects.hashCode(this.value);
        }
    }
}

