/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.tabcomplete;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.lucko.spark.common.command.tabcomplete.CompletionSupplier;

public class TabCompleter {
    private final Map<Integer, CompletionSupplier> suppliers = new HashMap<Integer, CompletionSupplier>();
    private int from = Integer.MAX_VALUE;

    public static TabCompleter create() {
        return new TabCompleter();
    }

    public static List<String> completeForOpts(List<String> args, String ... options) {
        ArrayList<String> opts = new ArrayList<String>(Arrays.asList(options));
        opts.removeAll(args);
        return TabCompleter.create().from(0, CompletionSupplier.startsWith(opts)).complete(args);
    }

    private TabCompleter() {
    }

    public TabCompleter at(int position, CompletionSupplier supplier) {
        Preconditions.checkState((position < this.from ? 1 : 0) != 0);
        this.suppliers.put(position, supplier);
        return this;
    }

    public TabCompleter from(int position, CompletionSupplier supplier) {
        Preconditions.checkState((this.from == Integer.MAX_VALUE ? 1 : 0) != 0);
        this.suppliers.put(position, supplier);
        this.from = position;
        return this;
    }

    public List<String> complete(List<String> args) {
        String partial;
        int lastIndex = 0;
        if (args.isEmpty() || (partial = args.get(lastIndex = args.size() - 1)).trim().isEmpty()) {
            return this.getCompletions(lastIndex, "");
        }
        return this.getCompletions(lastIndex, partial);
    }

    private List<String> getCompletions(int position, String partial) {
        if (position >= this.from) {
            return this.suppliers.get(this.from).supplyCompletions(partial);
        }
        return this.suppliers.getOrDefault(position, CompletionSupplier.EMPTY).supplyCompletions(partial);
    }
}

