/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.neoforge;

import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.events.ModEvents;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.neoforge.BlueprintIntegration;
import net.mehvahdjukaar.amendments.integration.neoforge.configured.ModConfigSelectScreen;
import net.mehvahdjukaar.amendments.neoforge.ClientEvents;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.neoforge.SoftFluidTankFluidHandlerWrapper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Mod(value="amendments")
public class AmendmentsForge {
    public AmendmentsForge(IEventBus bus) {
        RegHelper.startRegisteringFor((Object)bus);
        Amendments.init();
        bus.addListener(AmendmentsForge::registerCapabilities);
        NeoForge.EVENT_BUS.register((Object)this);
        if (PlatHelper.getPhysicalSide().isClient()) {
            NeoForge.EVENT_BUS.register(ClientEvents.class);
            if (CompatHandler.CONFIGURED && ClientConfigs.CUSTOM_CONFIGURED_SCREEN.get().booleanValue()) {
                ModConfigSelectScreen.registerConfigScreen((String)"amendments", ModConfigSelectScreen::new);
            }
        }
        if (CompatHandler.BLUEPRINT) {
            BlueprintIntegration.init();
        }
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ModRegistry.LIQUID_CAULDRON_TILE.get(), (myBlockEntity, side) -> SoftFluidTankFluidHandlerWrapper.wrap((BlockEntity)myBlockEntity));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onUseBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult ret;
        if (!event.isCanceled() && (ret = ModEvents.onRightClickBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(ret);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityHurt(AttackEntityEvent event) {
        if (!event.isCanceled()) {
            ModEvents.onAttackEntity(event.getEntity(), event.getEntity().level(), InteractionHand.MAIN_HAND, event.getTarget(), null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onUseBlockHP(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult ret;
        if (!event.isCanceled() && (ret = ModEvents.onRightClickBlockHP(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(ret);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onUseItem(PlayerInteractEvent.RightClickItem event) {
        InteractionResultHolder<ItemStack> ret;
        if (!event.isCanceled() && (ret = ModEvents.onUseItem(event.getEntity(), event.getLevel(), event.getHand())).getResult() != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(ret.getResult());
        }
    }
}

