/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import java.util.Optional;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.tile.EnhancedSkullBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DoubleSkullBlockTile
extends EnhancedSkullBlockTile {
    @Nullable
    protected SkullBlockEntity innerTileUp = null;
    private Block candleUp = null;
    private ResourceLocation waxTexture = null;

    public DoubleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModRegistry.SKULL_PILE_TILE.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveInnerTile("SkullUp", this.innerTileUp, tag, registries);
        if (this.candleUp != null) {
            tag.putString("CandleAbove", Utils.getID((Block)this.candleUp).toString());
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ResourceLocation candle;
        Optional o;
        super.loadAdditional(tag, registries);
        this.innerTileUp = this.loadInnerTile("SkullUp", this.innerTileUp, tag, registries);
        Block b = null;
        if (tag.contains("CandleAbove") && (o = BuiltInRegistries.BLOCK.getOptional(candle = ResourceLocation.tryParse((String)tag.getString("CandleAbove")))).isPresent()) {
            b = (Block)o.get();
        }
        this.setCandleUp(b);
    }

    public ItemStack getSkullItemUp() {
        if (this.innerTileUp != null) {
            return new ItemStack((ItemLike)this.innerTileUp.getBlockState().getBlock());
        }
        return ItemStack.EMPTY;
    }

    public void rotateUp(Rotation rotation) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.getBlockState();
            int r = (Integer)this.innerTileUp.getBlockState().getValue((Property)SkullBlock.ROTATION);
            this.innerTileUp.setBlockState((BlockState)state.setValue((Property)SkullBlock.ROTATION, (Comparable)Integer.valueOf(rotation.rotate(r, 16))));
        }
    }

    public void rotateUpStep(int step) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.getBlockState();
            int r = (Integer)this.innerTileUp.getBlockState().getValue((Property)SkullBlock.ROTATION);
            this.innerTileUp.setBlockState((BlockState)state.setValue((Property)SkullBlock.ROTATION, (Comparable)Integer.valueOf((r - step + 16) % 16)));
        }
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, ItemStack skullStack, Player player, InteractionHand hand) {
        BlockItem bi;
        Block block;
        super.initialize(oldTile, skullStack, player, hand);
        Item item = skullStack.getItem();
        if (item instanceof BlockItem && (block = (bi = (BlockItem)item).getBlock()) instanceof SkullBlock) {
            BlockEntity entity;
            SkullBlock upSkull = (SkullBlock)block;
            BlockPlaceContext context = new BlockPlaceContext(player, hand, skullStack, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.UP, this.getBlockPos(), false));
            BlockState state = upSkull.getStateForPlacement(context);
            if (state == null) {
                state = upSkull.defaultBlockState();
            }
            if ((entity = upSkull.newBlockEntity(this.getBlockPos(), state)) instanceof SkullBlockEntity) {
                SkullBlockEntity blockEntity;
                this.innerTileUp = blockEntity = (SkullBlockEntity)entity;
                this.innerTileUp.setOwner((ResolvableProfile)skullStack.get(DataComponents.PROFILE));
            }
        }
    }

    public void updateWax(BlockState above) {
        this.setCandleUp(above.getBlock());
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    private void setCandleUp(Block above) {
        this.candleUp = null;
        if (above instanceof CandleBlock) {
            this.candleUp = above;
        }
        if (PlatHelper.getPhysicalSide().isClient()) {
            this.waxTexture = null;
            if (this.candleUp != null) {
                this.waxTexture = AmendmentsClient.SKULL_CANDLES_TEXTURES.get().get(this.candleUp);
            }
        }
    }

    public ResourceLocation getWaxTexture() {
        return this.waxTexture;
    }

    @Nullable
    public BlockState getSkullUp() {
        if (this.innerTileUp != null) {
            return this.innerTileUp.getBlockState();
        }
        return null;
    }

    @Nullable
    public BlockEntity getSkullTileUp() {
        return this.innerTileUp;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DoubleSkullBlockTile e) {
        BlockState b;
        e.tick(level, pos, state);
        BlockEntity tileUp = e.getSkullTileUp();
        if (tileUp != null && (b = tileUp.getBlockState()) instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)b;
            eb.getTicker(level, b, tileUp.getType());
        }
    }
}

