/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.Fertility;
import club.iananderson.seasonhud.impl.seasons.mods.SeasonModHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.SSItems;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;

public class SereneSeasonsHelper
implements SeasonModHelper {
    @Override
    public Item calendar() {
        return SSItems.CALENDAR;
    }

    @Override
    public boolean isTropicalSeason(Player player) {
        boolean showTropicalSeasons = SeasonHudClient.getShowTropicalSeason();
        boolean isInTropicalSeason = SeasonHelper.usesTropicalSeasons((Holder)player.level().getBiome(player.getOnPos()));
        return showTropicalSeasons && isInTropicalSeason;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return false;
    }

    @Override
    public String getCurrentSubSeason(Player player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((Level)player.level());
        if (this.isTropicalSeason(player)) {
            return currentSeasonState.getTropicalSeason().toString();
        }
        return currentSeasonState.getSubSeason().toString();
    }

    @Override
    public String getCurrentSeason(Player player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((Level)player.level());
        if (this.isTropicalSeason(player)) {
            String currentSubSeason = this.getCurrentSubSeason(player);
            return currentSubSeason.substring(currentSubSeason.length() - 3);
        }
        return currentSeasonState.getSeason().toString();
    }

    @Override
    public long getDate(Player player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((Level)player.level());
        long seasonDay = currentSeasonState.getDay();
        long subSeasonDuration = ModConfig.seasons.subSeasonDuration;
        long subSeasonDate = seasonDay % subSeasonDuration + 1L;
        long seasonDate = seasonDay % (subSeasonDuration * 3L) + 1L;
        if (SeasonHudClient.getShowSubSeason()) {
            if (this.isTropicalSeason(player)) {
                subSeasonDate = (seasonDay + subSeasonDuration * 3L) % (subSeasonDuration * 2L) + 1L;
            }
            return subSeasonDate;
        }
        if (this.isTropicalSeason(player)) {
            seasonDate = (seasonDay + subSeasonDuration * 3L) % (subSeasonDuration * 6L) + 1L;
        }
        return seasonDate;
    }

    @Override
    public int seasonDuration(Player player) {
        int duration = ModConfig.seasons.subSeasonDuration * 3;
        if (this.isTropicalSeason(player)) {
            duration *= 2;
        }
        if (SeasonHudClient.getShowSubSeason() && Calendar.validDetailedMode()) {
            duration /= 3;
        }
        return duration;
    }

    @Override
    public boolean infertileBiome(Player player) {
        Level level = player.level();
        BlockPos pos = player.getOnPos();
        Holder biome = level.getBiome(pos);
        if (!ModConfig.fertility.seasonalCrops || biome.is(ModTags.Biomes.BLACKLISTED_BIOMES) || !ModConfig.seasons.isDimensionWhitelisted(level.dimension())) {
            return false;
        }
        return biome.is(ModTags.Biomes.INFERTILE_BIOMES);
    }

    @Override
    public boolean alwaysWinterBiome(Player player) {
        Level level = player.level();
        BlockPos pos = player.getOnPos();
        Holder biome = level.getBiome(pos);
        if (!ModConfig.fertility.seasonalCrops || biome.is(ModTags.Biomes.BLACKLISTED_BIOMES) || !ModConfig.seasons.isDimensionWhitelisted(level.dimension())) {
            return false;
        }
        return !((Biome)biome.value()).warmEnoughToRain(pos);
    }

    @Override
    public boolean undergroundFertile(Player player) {
        Level level = player.level();
        BlockPos pos = player.getOnPos();
        Holder biome = level.getBiome(pos);
        if (!ModConfig.fertility.seasonalCrops || biome.is(ModTags.Biomes.BLACKLISTED_BIOMES) || !ModConfig.seasons.isDimensionWhitelisted(level.dimension())) {
            return true;
        }
        if (!level.canSeeSky(pos.above())) {
            return pos.getY() > ModConfig.fertility.undergroundFertilityLevel;
        }
        return true;
    }

    @Override
    public Fertility fertility(Player player) {
        if (this.infertileBiome(player)) {
            return Fertility.INFERTILE_BIOME;
        }
        if (this.alwaysWinterBiome(player)) {
            return Fertility.ALWAYS_WINTER;
        }
        if (!this.undergroundFertile(player)) {
            return Fertility.UNDERGROUND;
        }
        return Fertility.FERTILE;
    }
}

