/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.config;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.Location;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.config.DefaultValues;
import club.iananderson.seasonhud.util.StringLine;
import java.util.Arrays;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SeasonHudClient {
    public static final ModConfigSpec CLIENT_SPEC;
    private static ModConfigSpec.ConfigValue<Boolean> enableMod;
    private static ModConfigSpec.ConfigValue<Location> hudLocation;
    private static ModConfigSpec.ConfigValue<Integer> hudX;
    private static ModConfigSpec.ConfigValue<Integer> hudY;
    private static ModConfigSpec.ConfigValue<Double> hudScale;
    private static ModConfigSpec.ConfigValue<Boolean> enableSeasonNameColor;
    private static ModConfigSpec.ConfigValue<Integer> springColor;
    private static ModConfigSpec.ConfigValue<Integer> summerColor;
    private static ModConfigSpec.ConfigValue<Integer> autumnColor;
    private static ModConfigSpec.ConfigValue<Integer> winterColor;
    private static ModConfigSpec.ConfigValue<Integer> dryColor;
    private static ModConfigSpec.ConfigValue<Integer> wetColor;
    private static ModConfigSpec.ConfigValue<Boolean> showTropicalSeason;
    private static ModConfigSpec.ConfigValue<Boolean> showSubSeason;
    private static ModConfigSpec.ConfigValue<ShowDay> showDay;
    private static ModConfigSpec.ConfigValue<Boolean> showFertility;
    private static ModConfigSpec.ConfigValue<Boolean> enableMinimapIntegration;
    private static ModConfigSpec.ConfigValue<Boolean> showDefaultWhenMinimapHidden;

    private SeasonHudClient() {
    }

    private static void setupConfig(ModConfigSpec.Builder builder) {
        builder.push("SeasonHUD");
        enableMod = builder.comment(StringLine.builder().addLine("Enable the mod?").addLine("(true/false)").lastLine("Default is true.")).define("enable_mod", true);
        builder.push("HUD");
        hudLocation = builder.comment(StringLine.builder().addLine("Where to display the Hud when no minimap is installed.").lastLine("Default is " + String.valueOf((Object)DefaultValues.Client.DEFAULT_HUD_LOCATION) + ".")).defineEnum("hud_location", (Enum)DefaultValues.Client.DEFAULT_HUD_LOCATION);
        hudX = builder.comment(StringLine.builder().addLine("The horizontal offset of the HUD when no minimap is installed (in pixels)").addLine("'hudLocation' must be set to 'CUSTOM' to take effect").lastLine("Default is 2.")).define("hud_x_position", (Object)2);
        hudY = builder.comment(StringLine.builder().addLine("The vertical offset of the HUD when no minimap is installed (in pixels)").addLine("'hudLocation' must be set to 'CUSTOM' to take effect").lastLine("Default is 2.")).define("hud_y_position", (Object)2);
        hudScale = builder.comment(StringLine.builder().addLine("The scale of the HUD when no minimap is installed.").lastLine("Default is 1.0.")).defineInRange("hud_scale", 1.0, 0.5, 10.0);
        builder.push("Colors");
        enableSeasonNameColor = builder.comment(StringLine.builder().addLine("Display the season name in a color?").addLine("(true/false)").lastLine("Default is true.")).define("season_name_color", true);
        springColor = builder.comment(StringLine.builder().addLine("The RGB color (decimal) for spring.").addLine("(256 * 256 * r) + (256 * g) + (b) is the formula.").lastLine("Default is 16753595.")).defineInRange("spring_color", 16753595, 0, 0xFFFFFF);
        summerColor = builder.comment(StringLine.builder().addLine("The RGB color (decimal) for summer.").addLine("(256 * 256 * r) + (256 * g) + (b) is the formula.").lastLine("Default is 16705834.")).defineInRange("summer_color", 16705834, 0, 0xFFFFFF);
        autumnColor = builder.comment(StringLine.builder().addLine("The RGB color (decimal) for autumn.").addLine("(256 * 256 * r) + (256 * g) + (b) is the formula.").lastLine("Default is 12344871.")).defineInRange("autumn_color", 12344871, 0, 0xFFFFFF);
        winterColor = builder.comment(StringLine.builder().addLine("The RGB color (decimal) for winter.").addLine("(256 * 256 * r) + (256 * g) + (b) is the formula.").lastLine("Default is 14679292.")).defineInRange("winter_color", 0xDFFCFC, 0, 0xFFFFFF);
        dryColor = builder.comment(StringLine.builder().addLine("The RGB color (decimal) for dry tropical season.").addLine("(256 * 256 * r) + (256 * g) + (b) is the formula.").lastLine("Default is 16745216.")).defineInRange("dry_color", 16745216, 0, 0xFFFFFF);
        wetColor = builder.comment(StringLine.builder().addLine("The RGB color (decimal) for wet tropical season.").addLine("(256 * 256 * r) + (256 * g) + (b) is the formula.").lastLine("Default is 2068975.")).defineInRange("wet_color", 2068975, 0, 0xFFFFFF);
        builder.pop();
        builder.pop();
        builder.push("Season");
        showTropicalSeason = builder.comment(StringLine.builder().addLine("Show the Tropical seasons (Wet/Dry) in Tropical Biomes.").addLine("Will not change the season behavior in the biomes, just what is displayed").addLine("(true/false)").lastLine("Default is true.")).define("enable_show_tropical_season", true);
        showSubSeason = builder.comment(StringLine.builder().addLine("Show sub-season (i.e. Early Winter, Mid Autumn, Late Spring) instead of basic season?").addLine("(true/false)").lastLine("Default is true.")).define("enable_show_sub_season", true);
        if (Common.fabricSeasonsLoaded()) {
            showDay = builder.comment(StringLine.builder().addLine("Show the current day of the season/sub-season?").lastLine("Default is " + String.valueOf((Object)DefaultValues.Client.DEFAULT_SHOW_DAY) + ".")).defineEnum("enable_show_day", (Enum)ShowDay.SHOW_DAY, Arrays.asList(ShowDay.NONE, ShowDay.SHOW_DAY, ShowDay.SHOW_WITH_TOTAL_DAYS, ShowDay.SHOW_WITH_MONTH));
        }
        if (!Common.fabricSeasonsLoaded()) {
            showDay = builder.comment(StringLine.builder().addLine("Show the current day of the season/sub-season?").lastLine("Default is " + String.valueOf((Object)DefaultValues.Client.DEFAULT_SHOW_DAY) + ".")).defineEnum("enable_show_day", (Enum)DefaultValues.Client.DEFAULT_SHOW_DAY, Arrays.asList(ShowDay.NONE, ShowDay.SHOW_DAY, ShowDay.SHOW_WITH_TOTAL_DAYS));
        }
        showFertility = builder.comment(StringLine.builder().addLine("Show the current fertility of the biome").lastLine("Default is false.")).define("enable_show_fertility", false);
        builder.pop();
        builder.push("Minimap");
        enableMinimapIntegration = builder.comment(StringLine.builder().addLine("Enable integration with minimap mods?").addLine("(true/false)").lastLine("Default is true.")).define("enable_minimap_integration", true);
        showDefaultWhenMinimapHidden = builder.comment(StringLine.builder().addLine("Show the default SeasonHUD display when the minimap is hidden?").addLine("(true/false)").lastLine("Default is false.")).define("enable_show_minimap_hidden", false);
        builder.pop();
        builder.pop();
    }

    private static <T> T getOrDefault(ModConfigSpec.ConfigValue<T> config) {
        if (CLIENT_SPEC.isLoaded()) {
            return (T)config.get();
        }
        return (T)config.getDefault();
    }

    public static boolean getEnableMod() {
        return SeasonHudClient.getOrDefault(enableMod);
    }

    public static void setEnableMod(boolean enable) {
        enableMod.set((Object)enable);
    }

    public static Location getHudLocation() {
        return SeasonHudClient.getOrDefault(hudLocation);
    }

    public static void setHudLocation(Location location) {
        hudLocation.set((Object)location);
    }

    public static int getHudX() {
        return SeasonHudClient.getOrDefault(hudX);
    }

    public static void setHudX(int x) {
        hudX.set((Object)x);
    }

    public static int getHudY() {
        return SeasonHudClient.getOrDefault(hudY);
    }

    public static void setHudY(int y) {
        hudY.set((Object)y);
    }

    public static double getHudScale() {
        return SeasonHudClient.getOrDefault(hudScale);
    }

    public static void setHudScale(double scale) {
        hudScale.set((Object)scale);
    }

    public static boolean getEnableSeasonNameColor() {
        return SeasonHudClient.getOrDefault(enableSeasonNameColor);
    }

    public static void setEnableSeasonNameColor(boolean enable) {
        enableSeasonNameColor.set((Object)enable);
    }

    public static int getSpringColor() {
        return SeasonHudClient.getOrDefault(springColor);
    }

    public static void setSpringColor(int rgbColor) {
        springColor.set((Object)rgbColor);
    }

    public static int getSummerColor() {
        return SeasonHudClient.getOrDefault(summerColor);
    }

    public static void setSummerColor(int rgbColor) {
        summerColor.set((Object)rgbColor);
    }

    public static int getAutumnColor() {
        return SeasonHudClient.getOrDefault(autumnColor);
    }

    public static void setAutumnColor(int rgbColor) {
        autumnColor.set((Object)rgbColor);
    }

    public static int getWinterColor() {
        return SeasonHudClient.getOrDefault(winterColor);
    }

    public static void setWinterColor(int rgbColor) {
        winterColor.set((Object)rgbColor);
    }

    public static int getDryColor() {
        return SeasonHudClient.getOrDefault(dryColor);
    }

    public static void setDryColor(int rgbColor) {
        dryColor.set((Object)rgbColor);
    }

    public static int getWetColor() {
        return SeasonHudClient.getOrDefault(wetColor);
    }

    public static void setWetColor(int rgbColor) {
        wetColor.set((Object)rgbColor);
    }

    public static boolean getShowTropicalSeason() {
        return SeasonHudClient.getOrDefault(showTropicalSeason);
    }

    public static void setShowTropicalSeason(boolean enable) {
        showTropicalSeason.set((Object)enable);
    }

    public static boolean getShowSubSeason() {
        return SeasonHudClient.getOrDefault(showSubSeason);
    }

    public static void setShowSubSeason(boolean enable) {
        showSubSeason.set((Object)enable);
    }

    public static ShowDay getShowDay() {
        return SeasonHudClient.getOrDefault(showDay);
    }

    public static void setShowDay(ShowDay showDay) {
        SeasonHudClient.showDay.set((Object)showDay);
    }

    public static boolean getShowFertility() {
        return SeasonHudClient.getOrDefault(showFertility);
    }

    public static void setShowFertility(boolean showFertility) {
        SeasonHudClient.showFertility.set((Object)showFertility);
    }

    public static boolean getShowDefaultWhenMinimapHidden() {
        return SeasonHudClient.getOrDefault(showDefaultWhenMinimapHidden);
    }

    public static void setShowDefaultWhenMinimapHidden(boolean enable) {
        showDefaultWhenMinimapHidden.set((Object)enable);
    }

    public static boolean getEnableMinimapIntegration() {
        return SeasonHudClient.getOrDefault(enableMinimapIntegration);
    }

    public static void setEnableMinimapIntegration(boolean enable) {
        enableMinimapIntegration.set((Object)enable);
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        SeasonHudClient.setupConfig(builder);
        CLIENT_SPEC = builder.build();
    }
}

