/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.client.gui.components.buttons.MenuButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class SeasonHudScreen
extends Screen {
    public static final int MENU_PADDING = 50;
    public static final int TITLE_PADDING = 10;
    public static final int BUTTON_PADDING = 6;
    public static MenuButton doneButton;
    public static MenuButton cancelButton;
    public final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    public final Screen parentScreen;
    public int buttonWidth = 150;
    public int buttonHeight = 20;
    public int leftButtonX;
    public int rightButtonX;
    public int row;
    public int buttonStartY = 50;
    public int offsetY = this.buttonHeight + 6;
    protected boolean hasPendingChanges;
    protected List<ModConfigSpec.ConfigValue<?>> configOptions = new ArrayList();

    public SeasonHudScreen(Screen parentScreen, Component title) {
        super(title);
        this.parentScreen = parentScreen;
        this.minecraft = Minecraft.getInstance();
        this.width = this.minecraft.getWindow().getGuiScaledWidth();
        this.height = this.minecraft.getWindow().getGuiScaledHeight();
    }

    public void open() {
        Minecraft.getInstance().setScreen((Screen)this);
    }

    public boolean isPauseScreen() {
        return true;
    }

    public boolean shouldCloseOnEsc() {
        return !this.hasPendingChanges;
    }

    private Stream<ModConfigSpec.ConfigValue<?>> getAllSettings() {
        return this.configOptions.stream();
    }

    private void undoChanges() {
        this.getAllSettings().forEach(ModConfigSpec.ConfigValue::clearCache);
    }

    public void saveConfig() {
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parentScreen);
    }

    public void onDone() {
        Minecraft.getInstance().setScreen(this.parentScreen);
    }

    protected void rebuildWidgets() {
        this.clearWidgets();
        this.clearFocus();
        this.init();
    }

    public void rebuildUI() {
        this.rebuildWidgets();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.getTitle(), this.width / 2, 10, 0xFFFFFF);
    }

    public void init() {
        super.init();
        this.widgets.clear();
        this.leftButtonX = this.width / 2 - (this.buttonWidth + 6);
        this.rightButtonX = this.width / 2 + 6;
        cancelButton = MenuButton.builder(MenuButton.MenuButtons.CANCEL, press -> this.onClose()).withPos(this.width / 2 - 156, this.height - 20 - 6).build();
        doneButton = MenuButton.builder(MenuButton.MenuButtons.DONE, press -> this.onDone()).withPos(this.rightButtonX, this.height - 20 - 6).build();
        this.widgets.addAll(Arrays.asList(cancelButton, doneButton));
    }
}

