/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders.rgb;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.client.gui.components.sliders.BasicSlider;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RgbSlider
extends BasicSlider {
    public static final int SLIDER_PADDING = 2;
    protected final Seasons season;
    private final boolean enableColor = SeasonHudClient.getEnableSeasonNameColor();
    protected ColorEditBox seasonBox;
    protected int red;
    protected int green;
    protected int blue;
    protected int rgb;

    public RgbSlider(int x, int y, int initial, ColorEditBox seasonBox, ChatFormatting textColor) {
        super(x, y, seasonBox.getWidth() + 2, seasonBox.getHeight() - 6, true, initial, 0.0, 255.0, seasonBox.getSeason().getDefaultColor(), textColor);
        this.seasonBox = seasonBox;
        this.season = seasonBox.getSeason();
        this.rgb = Integer.parseInt(seasonBox.getValue());
        this.red = Rgb.red(this.rgb);
        this.green = Rgb.green(this.rgb);
        this.blue = Rgb.blue(this.rgb);
        this.updateMessage();
    }

    @Override
    public void onClick(double x, double y) {
        if (this.enableColor) {
            super.onClick(x, y);
        }
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.enableColor) {
            super.onDrag(mouseX, mouseY, dragX, dragY);
        }
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.enableColor) {
            this.active = false;
            this.isHovered = false;
        }
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
    }

    public void setValue(int newValue) {
        double oldValue = this.value;
        this.value = this.snapToNearest(((double)newValue - this.minValue) / (this.maxValue - this.minValue));
        if (!Mth.equal((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    @Override
    protected void updateMessage() {
        MutableComponent colorString = Common.literalText(this.getValueString());
        this.setMessage((Component)colorString.copy().withStyle(this.textColor));
        if (!this.enableColor) {
            this.setMessage((Component)colorString.copy().withStyle(ChatFormatting.GRAY));
        }
    }
}

