/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.sliders.BasicSlider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HudOffsetSlider
extends BasicSlider {
    protected Component prefix;

    protected HudOffsetSlider(int x, int y, int width, int height, Component prefix, int initial, int minValue, int maxValue, int defaultValue) {
        super(x, y, width, height, true, initial, minValue, maxValue, defaultValue);
        this.prefix = prefix;
        this.updateMessage();
    }

    public static Builder builder(Component prefix) {
        return new Builder(prefix);
    }

    protected boolean clicked(double d, double e) {
        return this.active && this.visible && d >= (double)this.getX() && e >= (double)this.getY() && d < (double)(this.getX() + this.width) && e < (double)(this.getY() + this.height);
    }

    @Override
    protected void updateMessage() {
        if (this.drawString) {
            this.setMessage((Component)Common.literalText("").append(this.prefix).append(this.getValueString()));
        } else {
            this.setMessage((Component)Component.empty());
        }
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
    }

    public static class Builder {
        protected final Component prefix;
        protected int posX;
        protected int posY;
        protected int width = 180;
        protected int height = 20;
        protected int minValue;
        protected int maxValue;
        protected int initial;
        protected int defaultValue;
        protected Tooltip tooltip;

        public Builder(Component prefix) {
            this.prefix = prefix;
        }

        public Builder withPos(int x, int y) {
            this.posX = x;
            this.posY = y;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withBounds(int x, int y, int width, int height) {
            this.posX = x;
            this.posY = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withValueRange(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            return this;
        }

        public Builder withInitialValue(int initial) {
            this.initial = initial;
            return this;
        }

        public Builder withDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withValues(int minValue, int maxValue, int initial, int defaultValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.defaultValue = defaultValue;
            this.initial = Mth.clamp((int)initial, (int)this.minValue, (int)this.maxValue);
            return this;
        }

        public Builder withTooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public HudOffsetSlider build() {
            HudOffsetSlider slider = new HudOffsetSlider(this.posX, this.posY, this.width, this.height, this.prefix, this.initial, this.minValue, this.maxValue, this.defaultValue);
            slider.setTooltip(this.tooltip);
            return slider;
        }
    }
}

