/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu.Input;

import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.weido.create_bb.data.menu.Entry.StyleEntry;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class LengthScrollInput
extends ScrollInput {
    private final MutableComponent scrollToSelect = Component.translatable((String)"create_bb.menu.scroll_selection");
    private final MutableComponent noOptionAvailable = Component.translatable((String)"create_bb.menu.no_options_available");
    public StyleEntry.Length[] bogieLength = StyleEntry.Length.values();

    public LengthScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.withRange(0, this.bogieLength.length).titled(Component.translatable((String)"create_bb.menu.length")).format(index -> index >= this.bogieLength.length ? Component.empty() : this.bogieLength[index].getDisplayText()).inverted().setState(0);
        this.updateTooltip();
    }

    public void updateOptions(Set<StyleEntry.Length> validVariants) {
        LinkedList<StyleEntry.Length> sortedList = new LinkedList<StyleEntry.Length>(validVariants);
        List<StyleEntry.Length> priorityOrder = List.of(StyleEntry.Length.NORMAL, StyleEntry.Length.EXTENDED, StyleEntry.Length.SPACED, StyleEntry.Length.OFFSET);
        sortedList.sort(Comparator.comparingInt(priorityOrder::indexOf));
        this.bogieLength = sortedList.toArray(new StyleEntry.Length[0]);
        this.withRange(0, this.bogieLength.length);
        if (this.state >= this.bogieLength.length) {
            this.setState(0);
        }
        this.format(index -> index >= this.bogieLength.length ? Component.empty() : this.bogieLength[index].getDisplayText());
        this.updateTooltip();
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title != null) {
            this.toolTip.add(this.title.copy().withStyle(s -> s.withColor(HEADER_RGB.getRGB())));
        }
        for (int i = 0; i < this.bogieLength.length; ++i) {
            MutableComponent valvegear = Component.empty().append(i == this.state ? "-> " : "> ").append(this.bogieLength[i].getDisplayText());
            this.toolTip.add(valvegear.withStyle(i == this.state ? ChatFormatting.WHITE : ChatFormatting.GRAY));
        }
        if (this.bogieLength.length == 1) {
            this.toolTip.add(this.noOptionAvailable.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            this.toolTip.add(this.scrollToSelect.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }
}

