/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipeDatapackPlugin;
import com.supermartijn642.rechiseled.screen.DisplayEntry;
import com.supermartijn642.rechiseled.screen.preview.ScreenItemRenderer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class EntryButtonWidget
extends AbstractButtonWidget {
    private static final ResourceLocation TEXTURE = Rechiseled.identifier("textures/screen/buttons.png");
    private final int anchorY;
    private final Supplier<DisplayEntry> entry;
    private final Supplier<DisplayEntry> selectedEntry;
    private final Supplier<Boolean> connecting;

    public EntryButtonWidget(int x, int y, int width, int height, Supplier<DisplayEntry> entrySupplier, Supplier<DisplayEntry> selectedEntrySupplier, Runnable onClick, Supplier<Boolean> connecting) {
        super(x, y, width, height, onClick);
        this.anchorY = y;
        this.entry = entrySupplier;
        this.selectedEntry = selectedEntrySupplier;
        this.connecting = connecting;
    }

    public void setVerticalOffset(float offset) {
        this.y = (int)((float)this.anchorY - offset * (float)this.height);
    }

    protected boolean isClickable() {
        return this.entry.get() != null && this.entry.get() != this.selectedEntry.get();
    }

    public Component getNarrationMessage() {
        ItemWithWorth item;
        DisplayEntry display = this.entry.get();
        ItemWithWorth itemWithWorth = item = display == null ? null : display.getItem(this.connecting.get());
        if (item == null) {
            return null;
        }
        return TextComponents.translation((String)"rechiseled.chiseling.select_block", (Object[])new Object[]{TextComponents.item((Item)item.item()).get()}).get();
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        ItemWithWorth item;
        DisplayEntry display = this.entry.get();
        ItemWithWorth itemWithWorth = item = display == null ? null : display.getItem(this.connecting.get());
        if (item != null) {
            tooltips.accept((Component)TextComponents.item((Item)item.item()).get());
            if (ClientUtils.getMinecraft().options.advancedItemTooltips) {
                ResourceLocation owner;
                ResourceLocation recipe = display.entry().recipe();
                if (recipe != null) {
                    tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.entry.recipe", (Object[])new Object[]{TextComponents.string((String)recipe.toString()).color(ChatFormatting.DARK_GRAY).get()}).color(ChatFormatting.GRAY).get());
                }
                if (!(owner = display.entry().owner()).equals((Object)ChiselingRecipeDatapackPlugin.IDENTIFIER)) {
                    tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.entry.owner", (Object[])new Object[]{TextComponents.string((String)owner.toString()).color(ChatFormatting.DARK_GRAY).get()}).color(ChatFormatting.GRAY).get());
                }
            }
        }
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        DisplayEntry display = this.entry.get();
        boolean hasEntry = display != null;
        boolean selected = hasEntry && this.selectedEntry.get() == display;
        boolean hasCorrectItem = hasEntry && display.hasItem(this.connecting.get());
        ScreenUtils.bindTexture((ResourceLocation)TEXTURE);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(selected ? 1 : (hasEntry ? (hasCorrectItem ? (this.isFocused() ? 2 : 0) : (this.isFocused() ? 4 : 3)) : 0)) / 5.0f), (float)1.0f, (float)0.2f);
    }

    public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
        ItemWithWorth item;
        DisplayEntry display = this.entry.get();
        ItemWithWorth itemWithWorth = item = display == null ? null : display.getItem(this.connecting.get());
        if (display != null) {
            ScreenItemRenderer.drawItem(context.poseStack(), item.item(), (double)this.x + (double)this.width / 2.0, (double)this.y + (double)this.height / 2.0, this.width - 4, 0.0f, 0.0f, false);
        }
    }
}

